C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine lavo (jtr, nsamp, gather, dists, a, b,
     1                 sig, search, iwin, iswin, peak, trough,
     2                 lags, recnum, trcnum, ili, idi, lilar,
     3                 weight, istart, iend, istk)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c  routine to take a gather of jtr traces and sample-by-sample
c  compute a linear fit to the amplitude-distance points
c  outputting the sample-by-sample slopes, b, and intercepts, a
c  for all available samples, nsamp

      real      gather(nsamp,jtr), dists(*), a(*), b(*), sig(*)
      real      weight (iswin)
      real      lilar(iswin,jtr)
      real      X (SZLNHD), Y (SZLNHD)
      real      W (SZLNHD)
      integer   jtr, nsamp, iswin, lags, recnum, trcnum, ili, idi
      integer   iwin
      logical   search, trough, peak, got

      do  i = istart, iend
          amp = 0.
          ia = 0
          do  j = jtr-istk+1, jtr
              ia = ia + 1
              amp = amp + gather (i,j)
          enddo
          W (i) = abs (amp / float(ia) )
      enddo


      IF ( search ) THEN

      iwin1 = iwin + 1
      lags1 = lags + 1

      if (istart .ge. iwin1) then
          is = istart
      else
          is = iwin1
      endif
      if (iend .le. nsamp-iwin) then
          ie = iend
      else
          ie = nsamp-iwin
      endif

      do  i = is, ie    !  for each sample
 
          got = .false.
          nj = 0
          do  j = 1, jtr

              iw = 0
              do  ii = i-iwin, i+iwin
                  iw = iw + 1
                  wt = weight (iw)
                  Y (iw) = wt * gather(ii,j)
              enddo
              if (.not. got) then
                 call dotpr (Y, 1, Y, 1, ydot, iswin)
                 if (ydot .ne. 0.0) got = .true.
                 nj = 1
              else
                 nj = nj + 1
              endif

              if ( got ) then
                 X (nj) = dists (j)
                 iw = 0
                 do  ii = i-iwin, i+iwin
                     iw = iw + 1
                     wt = weight (iw)
                     lilar (iw,nj) = Y (iw)
                 enddo

              endif

          enddo

          call intshift (iswin, iwin1, nj, lags, lags1,
     1                   weight, lilar)

          do  j = 1, nj

              Y (j) = lilar (iwin1,j)
          enddo

          if (nj .ge. 3) then
             call fit (X, Y, nj, sig, 0, a(i), b(i),
     1                  siga, sigb, chi)
          else
             a (i) = 0.
             b (i) = 0.
          endif
 
      enddo

      ELSE

      do  i = istart, iend    !  for each sample

          nj = 0
          do  j = 1, jtr
              ampj = gather(i,j)
              if (abs (ampj) .gt. 1.e-30) then
                 nj = nj + 1
                 X (nj) = dists (j)
                 Y (nj) = ampj
              endif
          enddo

          if (nj .ge. 3) then
             call fit (X, Y, nj, sig, 0, a(i), b(i),
     1                  siga, sigb, chi)
          else
             a (i) = 0.
             b (i) = 0.
          endif

      enddo

      ENDIF

      do  i = istart, iend
          b (i) = W (i) * b (i)
      enddo

      return
      end

