C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine mrfft(ur,work,itabin,itabout,rtabin,rtabout,
     1                 urtemp,uitemp,fwgtr,fwgti,filter, 
     2                 ntin,ntout,ntr,ntdimen,initin,initout,
     3                 nfcut,lerr)
c
      dimension ur (0:ntdimen,ntr)
c
      integer   itabin(ntin+34),itabout(ntout+34)
      real      rtabin(3*(ntin/2)+13),rtabout(3*(ntout/2)+13)
      real      work(18*ntr)
c
      dimension urtemp(ntr)
      dimension uitemp(ntr)
      dimension fwgtr(0:nfcut)
      dimension fwgti(0:nfcut)
      logical   filter
#include <f77/sisdef.h>
c
#ifdef CRAYSYSTEM
c_____________________________________________________________________
c     cray scilib intialization routines.
c_____________________________________________________________________
      if(initin .eq. 1) then
         call fftfax( ntin , itabin , rtabin )
         if(itabin(1) .eq. -99) then
            write(lerr,*) 'error in routine mrfft'
            write(lerr,*) 'ntin = ',ntin,' unacceptable fft length'
            stop 46666
         endif
      endif
      if(initout .eq. 1) then
         call fftfax( ntout, itabout, rtabout)
         if(itabout(1) .eq. -99) then
            write(lerr,*) 'error in routine mrfft'
            write(lerr,*) 'ntout = ',ntout,' unacceptable fft length'
            stop 56666
         endif
       endif
#endif
c_____________________________________________________________________
c     forward fft:   t-->f       
c_____________________________________________________________________
#ifdef CRAYSYSTEM
c_____________________________________________________________________
c     cray scilib routines.
c_____________________________________________________________________
      call rfftmlt(ur,work,rtabin,itabin,1,ntdimen+1,ntin,ntr,-1)
#else
      write(23,*) 'before fft'
      write(23,'(i10,5e12.3)') (k,(ur(k,jtr),jtr=1,81,20),k=0,ntin-1)
c_____________________________________________________________________
c     qtc mathadvantage routines (machine independent version).
c_____________________________________________________________________
      call rnfftm(ur,ntdimen+1,ntin,ntr,+1,initin,
     1            itabin,rtabin,work,ierr)
      if(ierr .ne. 0) then
         write(lerr,*) 'error in routine mrfft forward transform'
         write(lerr,*) 'ntin = ',ntin,' ierr = ',ierr
         stop 6666
      endif
c_____________________________________________________________________
c     unpack and scale
c_____________________________________________________________________
      do 10000 itr=1,ntr
       call rfftsc(ur(0,itr),ntin,+2,1)
10000 continue
      write(23,*) 'after fft'
      write(23,'(i10,5e12.3)') (k,(ur(k,jtr),jtr=1,81,20),k=0,ntin-1)
#endif
      if(filter) then
C*********************************************************************
C        APPLY COMPLEX filter/WEiGHTS STOrED AS rEAL AND iMAGiNArY
C        PArTS: CMPLX(fwgtr(jf),fwgti(jf))
C*********************************************************************
         call vclr(ur(0,1),ntr,ntr)
         call vclr(ur(1,1),ntr,ntr)
         do 18000 jf = 1,nfcut
           jfr=jf*2
           jfi=jfr+1
           do 15000 jtr = 1,ntr
            urtemp(jtr) = fwgtr(jf)*ur(jfr,jtr)-fwgti(jf)*ur(jfi,jtr)
            uitemp(jtr) = fwgti(jf)*ur(jfr,jtr)+fwgtr(jf)*ur(jfi,jtr)
15000      continue
           do 17000 jtr = 1,ntr
             ur(jfr,jtr) = urtemp(jtr)
             ur(jfi,jtr) = uitemp(jtr)
17000      continue
18000    continue
      endif
c_____________________________________________________________________
c     zero pad in frequency domain (sinc interpolation in time domain).
c_____________________________________________________________________
      lenur=ntout-(2*nfcut+2)
      do 20000 jtr=1,ntr
       call vclr(ur(2*nfcut+2,jtr),1,lenur)
20000 continue
      write(23,*) 'after filt'
      write(23,'(i10,5e12.3)') (k,(ur(k,jtr),jtr=1,81,20),k=0,ntin-1)
#ifdef CRAYSYSTEM
c_____________________________________________________________________
c     cray scilib routines.
c_____________________________________________________________________
      call rfftmlt(ur,work,rtabout,itabout,1,ntdimen+1,ntout,ntr,+1)
c_____________________________________________________________________
#else
c_____________________________________________________________________
c     qtc mathadvantage routines (machine independent version).
c
c     pack 
c_____________________________________________________________________
      do 40000 itr=1,ntr
       call rfftsc(ur(0,itr),ntin,-2,1)
40000 continue
c_____________________________________________________________________
c     inverse fft:   f-->t       
c_____________________________________________________________________
      call rnfftm(ur,ntdimen+1,ntout,ntr,-1,initout,
     1            itabout,rtabout,work,ierr)
      if(ierr .ne. 0) then
         write(lerr,*) 'error in routine mrfft inverse transform'
         write(lerr,*) 'ntout = ',ntout,' ierr = ',ierr
         stop 7666
      endif
#endif
C
      return
      end
