C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C----------------------------------------------------------------------
C   PROGRAM LEVEL  -  UPWARD EXTRAPOLATION FROM TOPOGRAPHY
C
C
c-----------------------------------------------------------------------
c
#include  <save_defs.h>
#include  <localsys.h>
#include  <f77/iounit.h>
#include  <f77/lhdrsz.h>
#include  <f77/sisdef.h>
c-----------------------------------------------------------------------
c
      REAL    * 4 tau(5000), angle(5000), xhyp(5000)
      complex xx1(6000), w1(6000),  w, iii, czero
c
      real    * 4 udt(1:3001,1:2000), u2(1:3001,1:2000)
c     pointer (udtadr,udt(1:3001,1))
c     pointer (u2adr,u2(1:3001,1))
c
      integer * 4 istatic( 3001 ), ielev( 3001 ), idist( 3001 )
      integer * 4 itr ( 6128 ), iheadr(128 , 3001  )
c
      character   ntap * 120, otap * 120 ,name * 5, grp*4
      character   line*120
c
#include  <f77/pid.h>
c
      logical verbos, query, post, shot, down
      integer argis
c
      DATA pi / 3.141592 /
      DATA name /'LEVEL' /
      data iabort / 0 /
C-----------------------------------------------------------------------
#include <f77/open.h>
C-----------------------------------------------------------------------
C
C      get online help
C
C-----------------------------------------------------------------------
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query ) then
            call help()
            stop
      end if
C
      call gcmdln (ntap, otap, ns, ne, irs, ire, tzero, vmute,
     :	itaper, grpint, dipmax,verbos,geom,velmod,iref,post,shot,down)
c
      write(LER,*)
      write(LER,*)
     :'THIS IS A NEW VERSION OF LEVEL. NO DIFFR IS NECESSARY',
     :'AND THERE IS SLIGHTLY BETTER PRESERVATION OF',
     :'ORIGINAL WAVELET PHASE.'
      write(LER,*)
      write(LER,*)
C-----------------------------------------------------------------------
C
C      get logical unit numbers for input and output
C
C-----------------------------------------------------------------------
      call getln (luin,  ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )
C-----------------------------------------------------------------------
C
C      read lineheader and save key values
C
C-----------------------------------------------------------------------
      lbytes = 0
      call rtape ( luin, itr, lbytes )
      if (lbytes .eq. 0) then
            write(LOT, *)'DATUM: no header read from unit ', luin
            write(LOT, *)'FATAL'
            stop
      endif
#include <f77/saveh.h>
c     call hlhprt    ( itr, lbytes, name, 5, lerr)
c     get line header values
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
c
C-----------------------------------------------------------------------
c     build pointers to selected trace headers
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('GrpElv',ifmt_GrpElv,l_GrpElv,ln_GrpElv,TRACEHEADER)
      call savelu('SrPtEl',ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl,TRACEHEADER)
      call savelu('DePtEl',ifmt_DePtEl,l_DePtEl,ln_DePtEl,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
C-----------------------------------------------------------------------
C
C      verify command line parameters
C
C-----------------------------------------------------------------------
      call cmdchk ( ns, ne, irs, ire, ntrc, nrec )
C-----------------------------------------------------------------------
C
C      modify lineheader to agree with command line arguments
C
C-----------------------------------------------------------------------
      nrecc = ire -irs + 1
      ntrace = ne - ns + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc', ntrace,   LINHED)
      call savhlh(itr, lbytes, lbyout )
      CALL WRTAPE ( LUOUT, ITR, lbyout                      )
c-----------------------------------------------------------------------
c     set general parameters
c
      dipmax = pi * dipmax/180.
      sinmax = amin1( sin (dipmax), .9999)
c
      dt = real (nsi) * unitsc
c
      tmax = dt * float( nsamp - 1 )
      scale = 1.0 / dt
      if (itaper .gt. (ne - ns )/ 2 - 1 ) itaper = ( ne - ns)/ 2 + 1
c
c-----------------------------------------------------------------------
c     complex fft stuff
c
c     next higher power of 2 for fft
      al=(alog10(float(nsamp)))/(alog10(2.0))
      nfft=2**(int(aint(al))+1)                
      nfft2=nfft/2
c     write(ler,*) 'nfft = ', nfft
c
c     compute square root of -1
      iii = csqrt( cmplx( -1., 0.) )
c
c     table of (sqrt( -i * w ) )
      if ( .not. down ) then
         do 100 ii = 1, nfft2
            freq = (.5/dt)*float(ii-1)/float(nfft2-1)
            temp = 2. * pi * freq
            w = cmplx(temp, 0.)
            w1(ii) =  cmplx(1.0, 0.) * csqrt( iii * w )
            w1(nfft - ii + 1) =  cmplx(1.0, 0.) * csqrt( iii * (-w))
c           write(ler,*) "ii, freq, w1 = ",  ii, " ",freq," ", w1(ii)
100      continue
      else
         do 101 ii = 1, nfft2
            freq = (.5/dt)*float(ii-1)/float(nfft2-1)
            temp = - 2. * pi * freq
            w = cmplx(temp, 0.)
            w1(ii) =  cmplx(1.0, 0.) * csqrt( iii * w )
            w1(nfft - ii + 1) =  cmplx(1.0, 0.) * csqrt( iii * (-w))
101      continue
      endif
C-----------------------------------------------------------------------
C
C      verbose listing of parameters
C
      if (verbos) then
        call verbal(nsamp, nsi, ntrc, nrec, iform, grpint,
     :     ntap,otap,dipmax,velmod,iref,shot,geom,post,down)
      end if
c-----------------------------------------------------------------------
c
c      get array space
c

      
c     ispace = 3001*ntrace*SZSMPD
c     call galloc(udtadr,ispace,ierr,iabort)
c     if (ierr .ne. 0) then
c       write(ler,10) ispace
c       stop
c     endif
c       write(lerr,*) 'Mem Alloc. on udtadr', ispace

c     ispace = 3001*ntrace*SZSMPD
c     call galloc(u2adr,ispace,ierr,iabort)
c     if (ierr .ne. 0) then
c       write(ler,10) ispace
c       stop
c     endif
c       write(lerr,*) 'Mem Alloc. on u2adr', ispace
c  10 format(' DATUM: memory allocation failed: attempted to get ',
c    1     i7,' bytes ',/,' FATAL')

C-----------------------------------------------------------------------
C       skip unwanted records
C
       call recskp(1, irs - 1, luin, ntrc, itr)
c      call skprec(1, irs - 1, luin, ntrc, itr, lbytes, nsamp, iform )
C-----------------------------------------------------------------------
C
C-----Loop over Records
C
      do 450 irec = irs, ire
        write (LERR, * )' PROCESSING RECORD' ,IREC
c       write(ler,*)    ' PROCESSING RECORD' ,IREC
C-----------------------------------------------------------------------
C
C       Initialize Output Array udt.
C
          do 160 jxii = 1,ntrace
            do 158 ii = 1, nsamp
                  udt(ii,jxii) = 0.0
158            continue
160       continue
C-----------------------------------------------------------------------
C
C       Read Record into 2D array and get trace header info
C
        do 460 jx = 1,ntrace
C-----------------------------------------------------------------------
C
C         READ A TRACE.
C
          NBYTES = 0
          CALL RTAPE ( LUIN, ITR, NBYTES                 )
            if (nbytes .le. 0 ) then
                  write(LER,*) 'read EOF on record',jxii
                  write(LER,*) 'terminating job'
                      go to 9999
            end if

         call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                  istatic(jx), TRACEHEADER)
c        call saver2(itr,ifmt_RecInd,l_RecInd, ln_RecInd,
c    1                  igi, TRACEHEADER)
c        call saver2(itr,ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,
c    1                  ipri, TRACEHEADER)
         call saver2(itr,ifmt_GrpElv,l_GrpElv, ln_GrpElv,
     1                  igrpel, TRACEHEADER)
         call saver2(itr,ifmt_SrPtEl,l_SrPtEl, ln_SrPtEl,
     1                  isrcel, TRACEHEADER)
         call saver2(itr,ifmt_DePtEl,l_DePtEl, ln_DePtEl,
     1                  icmpel, TRACEHEADER)
         call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                  idist(jx), TRACEHEADER)

         call vmov( itr, 1, iheadr(1,jx), 1, SZTRHD )

         if (istatic( jx )  .ne. 30000 ) then
            call vmov(itr(ITHWP1),1,u2(1,jx),1,nsamp)
c
            call checka ( nsamp, u2(1,jx) )
            if( shot ) then
              ielev( jx ) = isrcel
            elseif ( post ) then
              ielev( jx ) = icmpel
              idist( jx ) = jx * grpint
            else
              ielev( jx ) = igrpel
            endif
c
            if( ielev( jx ) .gt. iref ) then
              write(lerr,*)
     1        'Elevation encountered at rec ', irec, ', trace, ',jx,
     2        ', is greater then the reference surface.'
              stop
            endif
         endif
460   continue
c
c     Taper input data -- if desired
      do 470 jx = 1,ntrace
         if( istatic( jx )  .ne. 30000 ) then
            if (itaper .gt. 0) then
 	       if (jx .le. itaper) then
 	          wt = float(jx)/float(itaper)
 	          call vsmul( u2(1,jx), 1, wt, u2(1,jx), 1, nsamp)
 	       elseif (jx .gt.(ne-itaper) ) then
 	          wt = float((ne+1-jx))/float(itaper)
 	          call vsmul( u2(1,jx), 1, wt, u2(1,jx), 1, nsamp)
                endif
 	    endif
c
c           apply geometric scaling to trace
            if (geom .ne. 0.) then
	       do 6565 ijk = 1, nsamp
                  u2(ijk,jx) = u2( ijk, jx ) * (float( ijk ) ** geom)
6565	       continue
            endif
c
C-----------------------------------------------------------------------
c           (( d/dt ) ** 1/2) Filter
c	
            czero = cmplx( 0., 0.)
            do 463 ic = 1,nfft
            xx1(ic) = czero
463         continue

            do 464 icc = 1,nsamp
               xx1(icc) = cmplx( u2( icc, jx), 0. )
464         continue

            call cfft(xx1,nfft,1)

            do 465 icc = 1, nfft
               xx1( icc ) = xx1( icc ) * w1( icc )
465         continue
 
            call cfft(xx1,nfft,-1)

            do 466 icc =1, nsamp
            u2(icc, jx) = real( xx1( icc ) )
466         continue
            

c           Reverse input data if upward continuation
            if ( .not. down ) then
            call vrvrs ( u2(1,jx), 1, nsamp)
            endif
C-----------------------------------------------------------------------
c           Compute travel times, angles
            do 340 jxi = 1, ntrace
               if ( istatic( jxi ) .eq. 30000 ) then
                  tau( jxi ) = -10000.
               else
                  xdist = float(idist( jxi ) - idist( jx ) )
                  depth = float(iref - ielev(jx))
                  xhyp( jxi )  = sqrt( xdist**2 + depth**2)
                  tau(jxi) = xhyp( jxi )/velmod
                  angle( jxi ) = atan( xdist/depth )
                  if (abs(sin(angle(jxi))) .gt. sinmax) then 
                       tau(jxi) = -10000.
                  endif
               endif
340         continue
C-----------------------------------------------------------------------
c           Double travel-times if post-stack data
            if ( post ) then
               do 345 jxi = 1,ntrace
                  tau( jxi ) = 2.0 * tau( jxi )
                  xhyp( jxi ) = 2.0 * xhyp( jxi )
345            continue
            endif
C-----------------------------------------------------------------------
c           Extrapolate data to the refernce surface
            do 360 jxi = 1,ntrace
               if ( tau( jxi ) .gt. -0.001) then
                  tau( jxi ) = tau( jxi ) * scale
                  jt1 = int ( tau( jxi ) + .5)
                  jt1 = min(jt1,nsamp-1)
                  obliq = tau(jxi) *  cos( angle( jxi ) ) / xhyp(jxi) 
c
                  do 350 jt = 1,nsamp-jt1
                     term = u2(jt1+jt, jx ) * obliq
                     udt(jt,jxi) = udt (jt,jxi) + term
350               continue
               endif
360         continue
C
         endif
470   continue
C-----------------------------------------------------------------------
C       Reverse Extrapolated data and remove geometric scaling
C
        do 480 jxi = 1,ntrace
              if ( istatic(jxi) .eq. 30000 ) then
                 call vclr(udt(1,jxi), 1, nsamp )
              endif
c
              if ( .not. down ) then
              call vrvrs (udt(1,jxi), 1, nsamp)
              endif
c
c             remove geometric scaling
              if (geom .ne. 0.) then
 	        do 485 kk = 1, nsamp
                  udt( kk, jxi ) =
     :              udt(kk, jxi ) * (float(kk) ** (-geom))
485             continue
 	      endif
c
480     continue
C-----------------------------------------------------------------------
C       APPEND TRACE HEADERS AND WRITE OUT AN EXTRAPOLATED RECORD
C
        DO 540 JXI = 1,ntrace
           call vmov( iheadr(1,jxi), 1, itr, 1, SZTRHD )
           call vmov( udt(1,jxi), 1, itr(ITHWP1), 1, nsamp )
           call wrtape( luout, ITR, nbytes )
540     continue
C
C     END LOOP OVER INPUT RECORDS
C
450   continue
9999  continue
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP
      END
C***********************************************************************
c
      SUBROUTINE CHECKA ( NX  , X )
      REAL    * 4 X ( * ), XMAX, XMIN
      INTEGER * 4 NX
      DATA  XMAX  ,   XMIN / 1.0e+15, 1.0e-15/
C                                                                   C
      DO 10 I = 1, NX
        IF (ABS ( X (I) ) .LT. XMIN       ) THEN
            X ( I ) = 0.0
        ENDIF
        IF (ABS ( X (I) ) .GT. XMAX       ) THEN
            X ( I ) = 0.0
        ENDIF
10      continue
      RETURN
      END
c-----------------------------------------------------------------------
      subroutine help
#include <f77/iounit.h>
 
      write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'level - topography correction via wavefield extrapolation'
      write(LER,*)
      write(LER,*)
     :'THIS IS A NEW VERSION OF LEVEL. NO DIFFR IS NECESSARY'
      write(LER,*)
     :'AND THERE SHOULD BE A SLIGHTLY BETTER PRESERVATION OF'
      write(LER,*)
     :'ORIGINAL WAVELET PHASE.'
      write(LER,*)
      write(LER,*)
     :'execute level by typing level followed by command line',
     :' parameters.'
      write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)
        write(LER,*)
     :' -N [ntap]        (none) : input data file name'
        write(LER,*)
     :' -O [otap]        (none) : output data file name'
       write(LER,*)
     :' -ns[ns]          (first : start trace number'
       write(LER,*)
     :' -ne[ne]          (last) : end trace number'
       write(LER,*)
     :' -rs[irs]         (first : start record number'
       write(LER,*)
     :' -re[ire]         (last) : end record number'
       write(LER,*)
     :' -Vel[velmod]     (none) : replacement velocity'
       write(LER,*)
     :' -Ref[iref]       (none) : reference surface'
       write(LER,*)
     :' -dipmax[dipmax]  (90 )  : max dip (degrees)'
       write(LER,*)
     :' -trint[grpint]   (none) : trace distance interval'
       write(LER,*)
     :' -taper[itaper]   (0)    : Number of traces to taper'
       write(ler,*)
     :'                           the endch record.'
       write(LER,*)
     :' -gs[geom]        (0)    : t**geom exponent for scaling,'
       write(ler,*)
     :'                           applied before extrapolation,'
       write(ler,*)
     :'                           and then removed.'
       write(LER,*)
     :' -S                      : -S to use source elevations'
       write(LER,*)
     :' -POST                   : -POST to extrapolate stack data,'
       write(ler,*)
     :'                           uses CDP elevation.'
       write(LER,*)
     :' -V                      : -V to get additional printout.'
       write(LER,*)
     :' -?                      : enter -? to get online help.'
        write(LER,*)
        write(LER,*)
     :'usage:   level -N[ntap] -O[otap] -ns[ns] -ne[ne] -rs[irs] '
        write(LER,*)
     :'-re[ire] -Vel[velmod] -Ref[iref] -gs[geom] -taper[itaper]'
        write(LER,*)
     :'-trint[grpint] -S -POST -V -?'
         write(LER,*)
     :'***************************************************************'
      return
 
      end
 
C***********************************************************************
      subroutine gcmdln (ntap, otap, ns, ne, irs, ire, tzero, vmute,
     :	 itaper, grpint, dipmax, verbos,geom,velmod,iref,post,shot,down)

#include <f77/iounit.h>

      character ntap*(*), otap*(*)
      integer *4 ns, ne, irs, ire
      logical verbos, shot,post,down
      integer argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argr4('-t0', tzero, 0.0, 0.0 )
            call argr4('-vm', vmute, 99999.0, 99999.0 )
            call argi4('-taper', itaper, 0, 0 )
	    call argr4('-trint',grpint,0.0, 0.0)
            call argr4('-dipmax', dipmax, 90.0, 90.0)
            call argr4('-gs', geom, 0.0, 0.0)
            call argr4('-Vel', velmod, 0.0, 0.0)
            call argi4('-Ref', iref, -99999, -99999)
            shot = ( argis('-S') .gt. 0 )
            down = ( argis('-U') .gt. 0 )
            post = ( argis('-POST') .gt. 0 )
            verbos = ( argis( '-V' ) .gt. 0 )
c
      return
      end
C***********************************************************************
c
        subroutine verbal(nsamp, nsi, ntrc, nrec, iform, grpint,
     :     ntap,otap,dipmax,velmod,iref,
     :     shot,geom,post,down)
c
#include <f77/iounit.h>
c
      integer*4 nsamp, nsi, ntrc, nrec, iform
      character ntap*(*), otap*(*)
      logical shot, post, down
 
            write(LERR ,*)' '
            write(LERR ,*)' line header values after default check '
            write(LERR, *) ' # of samples/trace =  ', nsamp
            write(LERR ,*) ' sample interval    =  ', nsi
            write(LERR ,*) ' traces per record  =  ', ntrc
            write(LERR, *) ' records per line   =  ', nrec
            write(LERR ,*) ' format of data     =  ', iform
            write(LERR ,*) ' input data         =  ', ntap
            write(LERR ,*) ' output data set    =  ', otap
            write(LERR ,*)' '
            write(LERR ,*)' Program Run Parameters '
            write(LERR ,*) ' trace dis interval =  ', grpint
            write(LERR, *) ' Maximum dip        =  ', dipmax
            write(LERR, *) ' Geom. Amp. Gain    =  ', geom
            write(LERR, *) ' Replacement Vel    =  ', velmod
            write(LERR, *) ' Referenece Elev    =  ', iref
            write(LERR ,*)' '
            if ( down ) then
            write(LERR, *) 'Downward continue from a flat reference'
            write(LERR, *) 'too original topography'
            else
            write(LERR, *) ' Upward continue from topography '
            write(LERR, *) ' too a flat reference surface '
            endif
            write(LERR ,*)' '
            if ( shot ) then
            write(LERR, *) ' Datum Sources'
            elseif ( post ) then
            write(LERR, *) ' Datum Stacked data'
            else
            write(LERR, *) ' Datum Receivers'
            endif
            write(LERR ,*)' '
 
      return
      end
