C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine minimizer(restart,niter,decrease,weight,lerr,file_data,
     1                     file_guess,file_guess_old,file_grad,
     2                     file_fmdata,file_fmdata_old,file_error,
     3                     file_temp,cmdforward,cmdbackward,verbose,
     4                     lmin,unitrestart,file_prior,file_temp2,
     5                     current_pwd,nodelist)


c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c      Conjugate gradient method
c
c      The function to minimize with this conjugate gradient method
c      must be quadratic because this method doesn't use a linear
c      search 
c      This routine is abble to restart from a given iteration.
c      The algorithm used is :
c
c          * X_0 , J(X_0) and G(X_0) known , starting from l=0
c
c      |-> * X_m = X_k + W_m ( alpha_l * G_l + X_l - X_k )
c      |
c      |   * alpha_l = - ( G(X_l) , G(X_l) ) /
c      |                 ( [F+weight*I] G(X_l) , [F+weight*I] G(X_l) )
c      |
c      |   * 1/W_m = 1 - alpha_l * ( G(X_l) , G(X_l) ) / 
c      |             ( W_l * alpha_k * ( G(X_k) , G(X_k) )
c      |     W_1 = 1
c      |
c      |   * if J(X_m) < decrease * J(X_0) then stop
c      |
c      |   * if J(X_m) < J(X_l) then X_m = X_l and stop
c      |
c      |-- * loop with k = l , l = m
c       
c      where :
c
c        J(X) is the total objective function 
c        J(X) = 1/2 || F.X - d ||**2 + weight*1/2 || X - m0 ||**2
c
c        G(X) = tF(FX-d) + weight(X-m0)  is the gradient
c
c        U(X) is the model generated by X
c
c        X_k is the solution at iteration k
c        X_l is the solution at iteration l
c        X_m is the solution at iteration m
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------



      implicit none

c-----------------------------------------------------------------------
c---->Type declarations for arguments
      character*256 file_guess_old,file_guess,file_grad,file_prior
      character*256 file_data,file_fmdata,file_fmdata_old,file_temp2
      character*700 cmdforward,cmdbackward
      character*256 current_pwd,nodelist,file_temp,file_error
      integer       lmin,unitrestart
      integer       lerr
      real          decrease,weight
      integer       niter
      logical       restart,verbose

c---->Type declarations for local variables
      real          coeff,coeff1,coeff2
      real*8        j_X_k,j_X_l,j_X_0,j1_X_0,percent,percent1
      real*8        j1_X_k,j1_X_l,j2_X_k,j2_X_l
      real*8        fgfg,dgdg,ps_k,alpha_k,w_l,ps_l,alpha_l,w_m
      real*8        num,den,two,one,minhalf
      integer       iter,iterstop
c-----------------------------------------------------------------------



      one = 1.
      minhalf = -0.50
      two = 2.


c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c---->First iteration (it can be also the last iteration of the
c---->previous minimization)
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------


c---->Case of first time of minimization
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
      if (.not.restart) then


c------->iterstop is the last iteration of the previous minimization
c------->so when restart=false iterstop must be 0
c-----------------------------------------------------------------------
         iterstop = 0
         niter = niter - 1

c------->X_0 must be 0. so intialize F(X_0) to 0
c-----------------------------------------------------------------------
         call putzero(file_data,file_fmdata,lerr,verbose)

c------->Calculates J1(X_0) (J1(F(X_0)))
c-----------------------------------------------------------------------
         call erreur(file_fmdata,file_data,file_error,lerr,verbose)
         call normdata(file_error,j1_X_k,lerr,verbose,file_temp2)
         j1_X_k = 0.5 * j1_X_k

c------->Calculates G1(X_0)
c-----------------------------------------------------------------------
         call backward(file_error,file_grad,cmdbackward,lerr,
     1                 verbose,current_pwd,nodelist)

c------->Calculates J2(X_0) (J2(F(X_0)))
c-----------------------------------------------------------------------
         if ((weight.gt.0.).and.(file_prior.ne.' ')) then
          call norm(file_prior,j2_X_k,lerr,verbose,file_temp2)
          j2_X_k = 0.5 * j2_X_k
         else
          j2_X_k = 0.
         endif
         if ((file_prior.ne.' ').and.(weight.gt.0.))
     1     weight = weight*j1_X_k/j2_X_k

c------->Add G2(X_0) to G1(X_0)
c-----------------------------------------------------------------------
         if ((weight.gt.0.).and.(file_prior.ne.' ')) then
          coeff = -1.*weight
          call linear(file_grad,file_prior,1.,coeff,lerr,verbose,
     1                file_temp)
         endif

c------->Initialise X_0 to 0.
c-----------------------------------------------------------------------
         call putzero(file_grad,file_guess,lerr,verbose)

c------->Defines X_(-1) as X_0
c-----------------------------------------------------------------------
         call copy(file_guess,file_guess_old,verbose,lerr)
         call copy(file_fmdata,file_fmdata_old,verbose,lerr)

c------->Defines the total objective function
c-----------------------------------------------------------------------
         j_X_k = j1_X_k + weight*j2_X_k

c------->Defines Values of the 0th iteration
c-----------------------------------------------------------------------
         j_X_0 = j_X_k
         j1_X_0 = j1_X_k
         percent = j_X_0 / 100.
         percent1 = j1_X_0 / 100.

c------->Compute ( G(X_0) , G(X_0) )
c-----------------------------------------------------------------------
         call norm(file_grad,ps_k,lerr,verbose,file_temp2)

c------->Compute F.G(X_0)
c-----------------------------------------------------------------------
         call forward(file_grad,file_error,cmdforward,lerr,
     1                verbose,current_pwd,nodelist)

c------->Test the accuracy of cmdbackward as adjoint cmdforward
c-----------------------------------------------------------------------
         if (file_prior.eq.' ') then
          call test(cmdforward,cmdbackward,ps_k,file_data,
     1              file_error,file_temp,file_temp2,lerr,lmin,verbose)
         endif

c------->Compute 0.5 * ( F.G(X_0) , F.G(X_0) )
c-----------------------------------------------------------------------
         call normdata(file_error,fgfg,lerr,verbose,file_temp2)
         fgfg = 0.5 * fgfg

c------->Compute 0.5 * ( G(X_0) , G(X_0) )
c-----------------------------------------------------------------------
         if (weight.gt.0.) then
          dgdg = 0.5 * ps_k
         else
          dgdg = 0.
         endif

c------->Add weight*( G(X_0) , G(X_0) ) to ( F.G(X_0) , F.G(X_0) )
c-----------------------------------------------------------------------
         if ((file_prior.eq.' ').and.(weight.gt.0.))
     1     weight = fgfg/dgdg*weight
         fgfg = fgfg + weight*dgdg

c------->Compute alpha_0
c-----------------------------------------------------------------------
         alpha_k = minhalf * ps_k / fgfg

c------->W_1 = 1
c-----------------------------------------------------------------------
         w_l = one

c------->Compute X_1 = alpha_0 * G(X_0) + X_0
c-----------------------------------------------------------------------
         coeff = real( alpha_k )
         call linear(file_guess,file_grad,1.,coeff,lerr,verbose,
     1               file_temp)
         call linear(file_fmdata,file_error,1.,coeff,lerr,verbose,
     1               file_temp)

c------->Write usefull information about the minimization at the zero_th
c------->iteration
c-----------------------------------------------------------------------
         write(lerr,'(a,E11.4)') '  MINIMIZER   WEIGHT=     ',weight
         write(lerr,*) ' '
         call info(lerr,0,j_X_k,j1_X_k,j2_X_k,ps_k,alpha_k,
     1             percent,percent1)
         write(lmin,'(a,E11.4)') '  MINIMIZER   WEIGHT=     ',weight
         write(lmin,*) ' '
         call info(lmin,0,j_X_k,j1_X_k,j2_X_k,ps_k,alpha_k,
     1             percent,percent1)

c------->Write necessary value for a restart in restartfile
c-----------------------------------------------------------------------
         call writerestart(unitrestart,j_X_0,j1_X_0,j_X_k,ps_k,alpha_k,
     1                     w_l,0,weight)



c---->Case of restart of minimization
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
      else


c------->Read necessary value of the previous minimization to go on the
c------->minimization
c-----------------------------------------------------------------------
         call readrestart(unitrestart,j_X_0,j1_X_0,j_X_k,ps_k,alpha_k,
     1                    w_l,iterstop,weight)
         percent = j_X_0 / 100.
         percent1 = j1_X_0 / 100.

      endif





c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c---->Next iteration
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
      do 80 iter=iterstop+1,iterstop+niter


c------->Compute J1(X_l) (J1(F(X_l)))
c-----------------------------------------------------------------------
         call erreur(file_fmdata,file_data,file_error,lerr,verbose)
         call normdata(file_error,j1_X_l,lerr,verbose,file_temp2)
         j1_X_l = 0.5 * j1_X_l

c------->Compute G1(X_l)
c-----------------------------------------------------------------------
         call backward(file_error,file_grad,cmdbackward,lerr,
     1                 verbose,current_pwd,nodelist)

c------->Add G2(X_l) to G1(X_l)
c-----------------------------------------------------------------------
         if (weight.gt.0.) then
          if (file_prior.ne.' ') then
           call erreur(file_guess,file_prior,file_error,lerr,verbose)
           call linear(file_grad,file_error,1.,weight,lerr,verbose,
     1                 file_temp)
          else
           call linear(file_grad,file_guess,1.,weight,lerr,verbose,
     1                 file_temp)
          endif
         endif

c------->Compute J2(X_l)
c-----------------------------------------------------------------------
         if (weight.gt.0.) then
          if (file_prior.ne.' ') then
           call norm(file_error,j2_X_l,lerr,verbose,file_temp2)
          else
           call norm(file_guess,j2_X_l,lerr,verbose,file_temp2)
          endif
         else 
          call norm(file_guess,j2_X_l,lerr,verbose,file_temp2)
         endif
         j2_X_l = 0.5 * j2_X_l

c------->Compute J(X_l)
c-----------------------------------------------------------------------
         j_X_l = j1_X_l + weight*j2_X_l

c------->Compute ( G(X_l) , G(X_l) )
c-----------------------------------------------------------------------
         call norm(file_grad,ps_l,lerr,verbose,file_temp2)

c------->Test of convergence
c-----------------------------------------------------------------------
         if ( j_X_l .lt. (j_X_0*decrease) ) goto 500
         if ( j_X_l .gt. j_X_k ) goto 700
         if ( (j_X_k-j_X_l) .lt. (j_X_0*decrease) ) goto 400
 
c------->Compute F.G(X_l)
c-----------------------------------------------------------------------
         call forward(file_grad,file_error,cmdforward,lerr,
     1                verbose,current_pwd,nodelist)

c------->Compute 0.5 * ( F.G(X_l) , F.G(X_l) )
c-----------------------------------------------------------------------
         call normdata(file_error,fgfg,lerr,verbose,file_temp2)
         fgfg = 0.5 * fgfg
 
c------->Compute 0.5 * ( G(X_l) , G(X_l) )
c-----------------------------------------------------------------------
         if (weight.gt.0.) then
          dgdg = 0.5 * ps_l
         else
          dgdg = 0.
         endif

c------->Add weight( S.G(X_l) , S.G(X_l) ) to ( F.G(X_l) , F.G(X_l) )
c-----------------------------------------------------------------------
         fgfg = fgfg + weight*dgdg

c------->Compute alpha_l
c-----------------------------------------------------------------------
         alpha_l = minhalf * ps_l / fgfg 

c------->Compute W_m
c-----------------------------------------------------------------------
         num = w_l * alpha_k * ps_k 
         den = num - alpha_l * ps_l
         w_m = num / den
 
c------->Compute 1 - W_m
c-----------------------------------------------------------------------
         coeff = real( one - num / den )

c------->Compute W_m * alpha_l
c-----------------------------------------------------------------------
         coeff2 = real( w_m * alpha_l )

c------->Compute X_m = (1-W_m).X_k + W_m.alpha_l.G(X_l) + W_m.X_l
c-----------------------------------------------------------------------
         coeff1 = real( w_m )
         call linear2(file_grad,file_guess_old,file_guess,coeff2,coeff,
     1                coeff1,lerr,verbose,file_temp)

c------->Compute F(X_m) = (1-W_m).F(X_k) + W_m.alpha_l.F(G(X_l))
c------->                 + W_m.F(X_l)
c-----------------------------------------------------------------------
         call linear2(file_error,file_fmdata_old,file_fmdata,coeff2,
     1                coeff,coeff1,lerr,verbose,file_temp)

c------->Write usefull information about the minimization 
c-----------------------------------------------------------------------
         call info(lerr,iter,j_X_l,j1_X_l,j2_X_l,ps_l,alpha_l,
     1             percent,percent1)
         call info(lmin,iter,j_X_l,j1_X_l,j2_X_l,ps_l,alpha_l,
     1             percent,percent1)

c------->Save G(X_l) as X_l and X_l as X_k for new iteration
c-----------------------------------------------------------------------
         call movebis(file_guess,file_guess_old,verbose,lerr)
         call movebis(file_fmdata,file_fmdata_old,verbose,lerr)

c------->Save F(G(X_l)) as F(X_l) and F(X_l) as F(X_k) for new iteration
c-----------------------------------------------------------------------
         call movebis(file_grad,file_guess,verbose,lerr)
         call movebis(file_error,file_fmdata,verbose,lerr)

c------->Update w_l, alpha_l, ( G(X_k) , G(X_k) ), J(X_k) for the next
c------->iteration
c-----------------------------------------------------------------------
         w_l = w_m
         alpha_k = alpha_l
         ps_k = ps_l
         j_X_k = j_X_l

c------->Write necessary value for a restart in restartfile
c-----------------------------------------------------------------------
         call writerestart(unitrestart,j_X_0,j1_X_0,j_X_k,ps_k,alpha_k,
     1                     w_l,iter,weight)


80    continue
 




c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c---->Last iteration
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------


c---->Compute the cost of the solution (last iteration)
c-----------------------------------------------------------------------
      call erreur(file_fmdata,file_data,file_error,lerr,verbose)
      call normdata(file_error,j1_X_l,lerr,verbose,file_temp2)
      j1_X_l = 0.5 * j1_X_l

      if (weight.gt.0.) then
       if (file_prior.ne.' ') then
        call erreur(file_guess,file_prior,file_temp,lerr,verbose)
        call norm(file_temp,j2_X_l,lerr,verbose,file_temp2)
       else
        call norm(file_guess,j2_X_l,lerr,verbose,file_temp2)
       endif
      else
       call norm(file_guess,j2_X_l,lerr,verbose,file_temp2)
      endif
      j2_X_l = 0.5 * j2_X_l

      j_X_l = j1_X_l + weight*j2_X_l

c---->Write usefull information about the minimization of the last
c---->iteration
c-----------------------------------------------------------------------
      ps_l = -1.
      alpha_l = 1.
      call info(lerr,niter+iterstop+1,j_X_l,j1_X_l,j2_X_l,ps_l,
     1          alpha_l,percent,percent1)
      call info(lmin,niter+iterstop+1,j_X_l,j1_X_l,j2_X_l,ps_l,
     1          alpha_l,percent,percent1)

c---->Go to end of the subroutine
c-----------------------------------------------------------------------
      goto 600




c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c---->The minimization must stop because j(X_l) < j(X_0) * decrease
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
500   continue


c---->Write usefull information about the minimization 
c-----------------------------------------------------------------------
      alpha_l = 1.
      call info(lerr,iter,j_X_l,j1_X_l,j2_X_l,ps_l,alpha_l,
     1          percent,percent1)
      write(lerr,'(a)') '  MINIMIZER   J DECREASE SUFFICENTLY'
      call info(lmin,iter,j_X_l,j1_X_l,j2_X_l,ps_l,alpha_l,
     1          percent,percent1)
      write(lmin,'(a)') '  MINIMIZER   J DECREASE SUFFICENTLY'

c---->Write necessary value for a restart in restartfile
c-----------------------------------------------------------------------
      call writerestart(unitrestart,j_X_0,j1_X_0,j_X_k,ps_k,w_l,fgfg,
     1                  iter-1,weight)

c---->Go to end of the subroutine
c-----------------------------------------------------------------------
      goto 600




c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c---->The minimization must stop because j(X_l)-j(X_k) < j(X_0)*decrease
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
400   continue


c---->Write usefull information about the minimization 
c-----------------------------------------------------------------------
      alpha_l = 1.
      call info(lerr,iter,j_X_l,j1_X_l,j2_X_l,ps_l,alpha_l,
     1          percent,percent1)
      write(lerr,'(a)') '  MINIMIZER   J DOESN''T DECREASE'
      call info(lmin,iter,j_X_l,j1_X_l,j2_X_l,ps_l,alpha_l,
     1          percent,percent1)
      write(lmin,'(a)') '  MINIMIZER   J DOESN''T DECREASE'

c---->Write necessary value for a restart in restartfile
c-----------------------------------------------------------------------
      call writerestart(unitrestart,j_X_0,j1_X_0,j_X_k,ps_k,w_l,fgfg,
     1                  iter-1,weight)

c---->Go to end of the subroutine
c-----------------------------------------------------------------------
      goto 600




c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c---->The minimization must stop because j(X_l) > j(X_k)
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
700   continue


c---->Write usefull information about the minimization 
c-----------------------------------------------------------------------
      alpha_l = 1.
      call info(lerr,iter,j_X_l,j1_X_l,j2_X_l,ps_l,alpha_l,
     1          percent,percent1)
      write(lerr,'(a)') '  MINIMIZER   J INCREASE'
      call info(lmin,iter,j_X_l,j1_X_l,j2_X_l,ps_l,alpha_l,
     1          percent,percent1)
      write(lmin,'(a)') '  MINIMIZER   J INCREASE'

c---->Go to end of the subroutine
c-----------------------------------------------------------------------
      goto 600




c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c---->End of the subroutine
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
600   continue



      return
      end
