C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getmax (x, y, lslide,nwin,iovlp,ns,
     1                   med, rms, max, ave, sgn)

      real    x (*), y (*)
      real    winwork (8192)
      integer lslide,nwin,iovlp,ns
      logical med, rms, max, ave, sgn
C +---------------------------------------------------------+
C |                                                         |
C | Parameters are:                                         |
C |    x     - Data to be processed                         |
C |   ns     - Number of samples to process (total)         |
C |   lslide - Length of the sliding window                 |
C |   nwin   - Number of windows                            |
C |   iovlp  - Overlap between windows                      |
C |                                                         |
C +---------------------------------------------------------+


         if ( .not. sgn) call vabs (x, 1, x, 1, ns)
C +----------------------------------------------------+
C | generate sliding windows & extract max amps        |
C +----------------------------------------------------+
      imid1 = 0

      DO  kk = 1, nwin

         if (kk.eq.1)then
            nmove  = lslide
            ilast  = lslide
            ifirst = 1
            if (lslide .eq. ns) nmove = ns
            jmove  = nmove
         else
            nmove  = lslide
            jmove  = nmove
            ifirst = ifirst + iovlp
            imid1  = ifirst
            ilast  = ifirst + nmove - 1
            if (ilast .gt. ns) then
               jmove = ns - ifirst + 1
            endif
         endif

         lwind = nmove

         do  mm = 1, nmove
             winwork (mm) = 0.
         end do

         call vmov (x(ifirst), 1, winwork, 1, lwind)

         if ( sgn ) then
            sum = 0.
            do  i = 1, lwind
                sum = sum + winwork (i)
            enddo
            fact = sum / abs(sum)
         else
            fact = 1.0
         endif

         amax = 0.

         if (med) then

            call mdian2 (winwork, lwind, amax, 1)

         elseif (rms) then
 
            live = 0
            do  i = 1, lwind
 
                amp = winwork(i)
                if (amp .gt. 1.e-30) live = live + 1
                amp = sqrt ( amp )
                amax = amax + amp
            enddo
            amax = amax / float (live)

         elseif (max) then

            amax = -1.
            do  i = 1, lwind
 
                amp =  winwork(i)
                if (amp .ge. amax) amax = amp
            enddo

         elseif (ave) then

            live = 0
            do  i = 1, lwind

                amp =  winwork(i)
                if (amp .gt. 1.e-30) live = live + 1
                amax = amax + amp
            enddo
            amax = amax / float (live)

         endif

         y (kk) = fact * amax

      ENDDO

      RETURN
      END
