C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine process(u, uout, uhdr, tsum, 
     1                   live, liverec, livesum, usort,
     2                   ii, jj, kk, im, jm, km,
     3                   isamp, istart, iskip, iend, 
     4                   NumSmp, NumTrc, NumRec,
     5                   lenhed, lbyout, Nx_Pad, luin, luout, ler, lerr,
     6                   cputim, waltim, 
     7                   ifmt_StaCor, l_StaCor, ln_StaCor, fdead)

      implicit none

c-----------------------------------------------------------------------
c Bertram Kaufhold 	05/01/98
c
c This routine contains the rolling median process necessary for the 
c median calculation of routine median3d
c
c-----------------------------------------------------------------------

#include <save_defs.h>

      integer ii, jj, kk, im, jm, km, isamp, istart, iskip, iend
      integer NumSmp, NumTrc, NumRec, lenhed, lbyout, Nx_Pad
      double precision usort(ii*jj*kk) 
      real u(-lenhed+1:NumSmp), uout(isamp, NumTrc) 
      real uhdr(lenhed, NumTrc, kk), tsum(isamp, NumTrc, kk) 
      integer live(NumTrc, kk), liverec(NumTrc), livesum(NumTrc)
      integer luin, luout, ler, lerr
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      logical fdead


      real cputim(*), waltim(*)
      integer irec, itrc, header, current, StaCor, lbytes
      integer i, i_dim
      real v1, vtot1, w1, wtot1
      real v2, vtot2, w2, wtot2
      real v3, vtot3, w3, wtot3
      real v8, vtot8, w8, wtot8
      real time_per_line, time_left
      integer nhour, nmin, nsec

      call timstr(v2,w2)


c-----------------------------------------------------------------------
c These variables determine which record should be dropped or added from 
c the current sums.  Once we accumulate the entire window of sums into
c current, then header tells us which record we are actually writing out.

      current = 1
      header = 1

c Start the timer that we will use to gauge how long until we finish

      call timstr(v8,w8)
     
c-----------------------------------------------------------------------
c Process the records
 
      do irec = 1, NumRec			!=> START OUTER LOOP=>

c Diagnostic message.  What line are we on and how much time until done?
 
         if (irec .ge. kk) then
            call timstr(vtot8,wtot8)                 
            time_per_line = (wtot8-w8)/(irec-1) 
            time_left = (NumRec-irec+1)*time_per_line  
            nhour=time_left/3600.
            nmin=(time_left-3600.*nhour)/60.
            nsec=time_left-3600.*nhour-60.*nmin
            write(ler,'(a,i5,a,i5,a,i5,a,i5,a,i5,a)')
     1         '(median3d) Processing line ',irec,' of ',NumRec,
     2         ' time left: ',nhour, ' hr',
     3         nmin, ' min', nsec, ' sec'
         else
            write(ler,'(a,i5,a,i5)')
     1         '(median3d) Processing line ',irec,' of ',NumRec
         endif
         
c-----------------------------------------------------------------------
c Sum up the number of dead/live traces in y-direction.  
c If we have summed across the entire window in y-direction, we have to
c drop and add dead/live traces into array liverec. The dropping is done
c just before START INNER LOOP, the adding just after END INNER LOOP
c The subroutine drop_liverec does the subtraction and the subroutine 
c add_liverec does the addition!

         if (irec .gt. kk) then
            call drop_liverec(liverec, live(1,current), NumTrc)
         endif

c-----------------------------------------------------------------------
c Process the traces
 
         do itrc = 1, NumTrc		!=> START INNER LOOP=>

            call timend(cputim(2),v2,vtot2,waltim(2),w2,wtot2)
            call timstr(v1,w1)
            call rtape(luin, u(-lenhed+1), lbytes)
            call timend(cputim(1),v1,vtot1,waltim(1),w1,wtot1)
            call timstr(v2,w2)

c Save the header for later use and rearrange the data entries 
c according to the specifications (see tstart, tskip, tend, apheight,
c aplenght and apwidth) made in the command line. 

            call vmov(u(-lenhed+1), 1, uhdr(1,itrc,current), 1, lenhed)
            i_dim = 1
            do i = istart, iend, iskip
               u(i_dim)=u(i)
               i_dim = i_dim + 1
            enddo

c Write the traces into array tsum

            call vmov(u(1), 1, tsum(1,itrc,current), 1, isamp)

c-----------------------------------------------------------------------
c By convention a "Station Correction" of 30000 is used as a dead trace 
c flag. If it is a dead trace report this fact in array live 

            call saver2(u(-lenhed+1), ifmt_StaCor, l_StaCor, ln_StaCor,
     1                  StaCor, TRACEHEADER)
            if (StaCor .ne. 30000) then
               live(itrc, current) = 1	
            else
               live(itrc, current) = 0
            endif
         enddo				!=END INNER LOOP=>

c-----------------------------------------------------------------------
c Sum up the number of dead/live traces in y-direction.
c If we have summed across the entire window in y-direction, we have to
c drop and add dead/live traces into array liverec. The dropping is done
c just before START INNER LOOP, the adding just after END INNER LOOP

         if (irec .gt. kk) then
            call add_liverec(liverec, live(1,current), NumTrc)
         endif

         if (irec .eq. 1) then

c For first record, just copy current dead/live trace assignments from
c array live into array liverec
 
            call copy_liverec(liverec, live(1,current), NumTrc)

         else if (irec .gt. 1 .and. irec .le. kk) then

c Until we have summed across the entire window in y-direction, continue
c to add the current live/dead trace assignment from array live to 
c array liverec.

            call add_liverec(liverec, live(1,current), NumTrc)

         endif   
               
c-----------------------------------------------------------------------
c We can't write anything out until we have read in km records.

         if (irec .ge. km) then

c-----------------------------------------------------------------------
c Do median calculation for the first NumRec-kap records

            call window_median(uout, tsum, live, usort, 
     1                         isamp, NumTrc, NumRec,
     2                         ii, jj, kk, im, jm, km, current, irec)

c-----------------------------------------------------------------------
c Obtain the number of dead/live traces in x-y-direction

            call isample_sums(livesum, liverec, NumTrc, jm)
            
c-----------------------------------------------------------------------
c Write out results for the first NumRec-kap records

            call timend(cputim(2),v2,vtot2,waltim(2),w2,wtot2)
            call timstr(v3,w3)
            call write_avg_record(u, uhdr(1,1,header),live(1,header),
     1                            uout, livesum, isamp, NumTrc,
     2                            Nx_Pad, luout,lerr, lbyout, 
     3                            lenhed, im, kk, jj, fdead)
     
            call timend(cputim(3),v3,vtot3,waltim(3),w3,wtot3)    
            call timstr(v2,w2)
            header = header + 1
            if (header .gt. kk) header = 1
         endif

         current = current + 1
         if (current .gt. kk) current = 1
      enddo					!=>END OUTER LOOP=>

c-----------------------------------------------------------------------
c Even though we have read through the entire dataset, we still have some
c records to write out.  We still have to obtain the median of the last 
c km-1 records. Note that we are once again working with less than a full 
c window.

      do irec = NumRec+1, NumRec+km-1

c-----------------------------------------------------------------------
c Do median calculation for the last km-1 records 

            call window_median(uout, tsum, live, usort,
     1                         isamp, NumTrc, NumRec,
     2                         ii, jj, kk, im, jm, km, current, irec)            

c-----------------------------------------------------------------------
c Sum up the number of dead/live traces in y-direction.  
c Subtract the oldest set of dead/live trace assignment found in array 
c live from array liverec.

         call drop_liverec(liverec, live(1,current), NumTrc)
         current = current + 1
         if (current .gt. kk) current = 1

c-----------------------------------------------------------------------
c Obtain the number of dead/live traces in x-y-direction

            call isample_sums(livesum, liverec, NumTrc, jm)
            
c-----------------------------------------------------------------------
c Write out results for the last km-1 records

         call timend(cputim(2),v2,vtot2,waltim(2),w2,wtot2)
         call timstr(v3,w3)
         call write_avg_record(u, uhdr(1,1,header),live(1,header), 
     1                         uout, livesum, isamp, NumTrc, 
     2                         Nx_Pad, luout, lerr, lbyout,
     3                         lenhed, im, kk, jj, fdead)
     
         call timend(cputim(3),v3,vtot3,waltim(3),w3,wtot3)
         call timstr(v2,w2)
         header = header + 1
         if (header .gt. kk) header = 1
      enddo
      call timend(cputim(2),v2,vtot2,waltim(2),w2,wtot2)

      end
