C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

      subroutine sort_for_median(usort, tsum, live, 
     1                           ii, jj, kk, 
     2                           isamp, NumTrc, length_usort,
     3                           starti, startj, startk,
     4                           lengthi, lengthj, lengthk)

      implicit none
      
c-----------------------------------------------------------------------
c Bertram Kaufhold	05/01/98
c
c Selection sort routine based on finding the minimum value and placing
c it first in the list , finding the next smallest value and placing it
c second in the list, and so on.
c usort 	=> sorting vector, contains sorted elements of selected
c		   part of input matrix at output 
c tsum  	=> input matrix 
c isamp		=> z-direction dimensionality of input matrix	
c live		=> dead/live trace assignment array
c ii		=> height analysis window size		
c jj		=> length analysis window size
c kk 		=> width analysis window size, identical to
c                  y-direction dimensionality of input matrix
c isamp		=> z-direction dimensionality of input matrix
c NumTrc	=> x-direction dimensionality of input matrix
c length_usort	=> length of sorting vector at output
c starti	=> z-direction start index
c startj	=> x-direction start index
c startk	=> y-direction start index
c lengthi	=> # of elements to be sorted in z-direction
c lengthj	=> # of elements to be sorted in x-direction
c lengthk	=> # of elements to be sorted in y-direction 


      integer isamp, NumTrc, length_usort
      integer ii, jj, kk
      integer starti, startj, startk
      integer lengthi, lengthj, lengthk 

      double precision usort(ii*jj*kk) 
      real tsum(isamp, NumTrc, kk)
      integer live(NumTrc,kk)

      integer i, j, k, l, first, ptr, indexk, indexj, indexi
      double precision hold

c-----------------------------------------------------------------------
c Copy entries from selected part of input matrix into sorting vector 
c The y-direction has to be given special attention as the records are
c stored in a rotating manner in the input matrix array tsum (important
c for the last km-1 records).
c Note: Dead traces are taken out of the sorting process, i.e.. only 
c       entries that correspond to live traces are sorted!
 
      l = 1
      do k = 1, lengthk
         indexk = startk+k-1
         if (indexk .gt. kk) indexk = iabs(kk-indexk)
         do j = 1, lengthj 
            indexj = startj+j-1
            do i = 1, lengthi 
               indexi = starti+i-1
               if (live(indexj,indexk) .ne. 0) then
                  usort(l) = tsum(indexi, indexj, indexk)
                  l = l + 1
               endif
            enddo
         enddo
      enddo
      length_usort = l-1

c-----------------------------------------------------------------------
c Sort the entries of vector array usort. If the analysis window only
c contained dead traces then length_usort will be zero and nothing has
c to be sorted. To return a specified value to the calling routine we
c will then set length_usort to 1 and set the value of usort(1) to zero.

      if (length_usort .ne. 0) then   
         do i = 1, l-2
            ptr = i
            first = i + 1
            do j = first, l-1 
               if (usort(j) .lt. usort(ptr)) ptr = j
            enddo
            hold = usort(i)
            usort(i) = usort(ptr)
            usort(ptr) = hold
         enddo
      else
         usort(1) = 0.0D+00
         length_usort = 1 
      endif
    
      end
