C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine window_median(uout, tsum, live, usort, 
     1                         isamp, NumTrc, NumRec,
     1                         ii, jj, kk, im, jm, km, current, irec)

      implicit none
      
c-----------------------------------------------------------------------
c Bertram Kaufhold	05/01/98
c
c Generates rolling medians.  Given a three-dimensional array, tsum, 
c generate rolling 3-dimension-medians of length ii * jj * kk (with 
c ii = 2*im-1, jj = 2*jm-1, kk = 2*km-1).
c
c This code also computes partial medians for uout(i) where, e.g. 
c i < im and i > isamp-im+1 (Note-> im = iap+1)
c
c uout		=> output matrix of medians
c tsum		=> input matrix
c live		=> dead/live trace assignment array
c usort 	=> output of subroutine sort_for_median, sorting 
c		   vector that contains sorted elements of selected  
c		   part of input matrix tsum at return  
c isamp		=> z-direction dimensionality of input matrix	
c NumTrc	=> x-direction dimensionality of input matrix
c NumRec	=> Number of records for existing data set
c ii		=> height analysis window size		
c jj		=> length analysis window size
c kk 		=> width analysis window size, identical to
c                  y-direction dimensionality of input matrix for 
c                  subroutine sort_for_median
c im		=> center point of height analysis window
c jm		=> center point of length analysis window
c km		=> center point of width analysis window
c current	=

      integer ii, jj, kk, im, jm, km, current, irec
      integer i, iap, j, jap, k, kap, kend
      integer choose, length_usort
      integer isamp, NumTrc, NumRec

      double precision usort(ii*jj*kk)
      real uout(isamp,NumTrc), tsum(isamp, NumTrc, kk)
      integer live(NumTrc,kk)

      iap = im - 1
      jap = jm - 1
      kap = km - 1

c-----------------------------------------------------------------------
c-----------------------------------------------------------------------     
c-----------------------------------------------------------------------
c     Compute partial medians for k < km, and a full median for k == km


      if (irec-km .lt. km) then 
      
         k = irec-km+1


c-----------------------------------------------------------------------     
c-----------------------------------------------------------------------
c     Compute partial medians for j < jm, and a full median for j == jm

         do j = 1,jm

c-----------------------------------------------------------------------
c     Compute partial medians for i < im, and a full median for i == im

            do i = 1,im
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              1, 1, 1,
     3                              i+iap, j+jap, k+kap)
               choose = length_usort/2     
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                       
            enddo

c-----------------------------------------------------------------------
c     Compute medians for im+1 <= i <= isamp-iap

            do i = im+1, isamp-iap
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, 1, 1,
     3                              ii, j+jap, k+kap)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif          
            enddo

c-----------------------------------------------------------------------
c     Compute partial sums for i >= isamp-im+2

            do i = isamp-im+2, isamp
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, 1, 1,
     3                              isamp-i+im, j+jap, k+kap)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                   
            enddo         
         enddo    

c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c     Compute medians for jm+1 <= j <= NumTrc-jap
      
         do j = jm+1, NumTrc-jap
         
c-----------------------------------------------------------------------
c     Compute partial medians for i < im, and a full median for i == im

            do i = 1,im
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              1, j-jap, 1,
     3                              i+iap, jj, k+kap)     
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                       
            enddo

c-----------------------------------------------------------------------
c     Compute medians for im+1 <= i <= isamp-iap

            do i = im+1, isamp-iap
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, j-jap, 1,
     3                              ii, jj, k+kap)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif          
            enddo

c-----------------------------------------------------------------------
c     Compute partial sums for i >= isamp-im+2

            do i = isamp-im+2, isamp
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, j-jap, 1,
     3                              isamp-i+im, jj, k+kap)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                   
            enddo
         enddo   
 
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c     Compute partial medians for j >= NumTrc-jm+2
      
         do j = NumTrc-jm+2, NumTrc
         
c-----------------------------------------------------------------------
c     Compute partial medians for i < im, and a full median for i == im

            do i = 1,im
               call sort_for_median(usort, tsum, live, ii, jj, kk,  
     1                              isamp, NumTrc, length_usort,
     2                              1, j-jap, 1, 
     3                              i+iap, NumTrc-j+jm, k+kap)     
               choose = length_usort/2
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                       
            enddo

c-----------------------------------------------------------------------
c     Compute medians for im+1 <= i <= isamp-iap

            do i = im+1, isamp-iap
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, j-jap, 1,
     3                              ii, NumTrc-j+jm, k+kap)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif          
            enddo

c-----------------------------------------------------------------------
c     Compute partial sums for i >= isamp-im+2

            do i = isamp-im+2, isamp
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, j-jap, 1, 
     3                              isamp-i+im, NumTrc-j+jm, k+kap)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                   
            enddo
         enddo   

c-----------------------------------------------------------------------
c-----------------------------------------------------------------------     
c-----------------------------------------------------------------------
c     Compute medians for km+1 <= k <= NumRec-kap


      else if (irec-km .ge. km .and. irec .le. NumRec) then 
       
        
c-----------------------------------------------------------------------     
c-----------------------------------------------------------------------
c     Compute partial medians for j < jm, and a full median for j == jm

         do j = 1,jm

c-----------------------------------------------------------------------
c     Compute partial medians for i < im, and a full median for i == im

            do i = 1,im
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              1, 1, 1,
     3                              i+iap, j+jap, kk)     
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                       
            enddo

c-----------------------------------------------------------------------
c     Compute medians for im+1 <= i <= isamp-iap

            do i = im+1, isamp-iap
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, 1, 1,
     3                              ii, j+jap, kk)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif          
            enddo

c-----------------------------------------------------------------------
c     Compute partial sums for i >= isamp-im+2

            do i = isamp-im+2, isamp
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, 1, 1,
     3                              isamp-i+im, j+jap, kk)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                   
            enddo         
         enddo    

c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c     Compute medians for jm+1 <= j <= NumTrc-jap
      
         do j = jm+1, NumTrc-jap
         
c-----------------------------------------------------------------------
c     Compute partial medians for i < im, and a full median for i == im

            do i = 1,im
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              1, j-jap, 1,
     3                              i+iap, jj, kk)     
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                       
            enddo

c-----------------------------------------------------------------------
c     Compute medians for im+1 <= i <= isamp-iap

            do i = im+1, isamp-iap
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, j-jap, 1,
     3                              ii, jj, kk)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif          
            enddo

c-----------------------------------------------------------------------
c     Compute partial sums for i >= isamp-im+2

            do i = isamp-im+2, isamp
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, j-jap, 1,
     3                              isamp-i+im, jj, kk)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                   
            enddo
         enddo   
 
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c     Compute partial medians for j >= NumTrc-jm+2
      
         do j = NumTrc-jm+2, NumTrc
         
c-----------------------------------------------------------------------
c     Compute partial medians for i < im, and a full median for i == im

            do i = 1,im
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              1, j-jap, 1, 
     3                              i+iap, NumTrc-j+jm, kk)     
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                       
            enddo

c-----------------------------------------------------------------------
c     Compute medians for im+1 <= i <= isamp-iap

            do i = im+1, isamp-iap
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, j-jap, 1,
     3                              ii, NumTrc-j+jm, kk)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif          
            enddo

c-----------------------------------------------------------------------
c     Compute partial sums for i >= isamp-im+2

            do i = isamp-im+2, isamp
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, j-jap, 1, 
     3                              isamp-i+im, NumTrc-j+jm, kk)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                   
            enddo
         enddo   
   
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------     
c-----------------------------------------------------------------------
c     Compute partial medians for k >= NumRec-km+2


      else if (irec .gt. NumRec) then
       
         kend = kk-1
         k = current+1
         
c-----------------------------------------------------------------------     
c-----------------------------------------------------------------------
c     Compute partial medians for j < jm, and a full median for j == jm

         do j = 1,jm

c-----------------------------------------------------------------------
c     Compute partial medians for i < im, and a full median for i == im

            do i = 1,im
               call sort_for_median(usort, tsum, live, ii, jj, kk, 
     1                              isamp, NumTrc, length_usort,
     2                              1, 1, k,
     3                              i+iap, j+jap, kend)     
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                       
            enddo

c-----------------------------------------------------------------------
c     Compute medians for im+1 <= i <= isamp-iap

            do i = im+1, isamp-iap
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, 1, k,
     3                              ii, j+jap, kend)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif          
            enddo

c-----------------------------------------------------------------------
c     Compute partial sums for i >= isamp-im+2

            do i = isamp-im+2, isamp
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, 1, k,
     3                              isamp-i+im, j+jap, kend)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                   
            enddo         
         enddo    

c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c     Compute medians for jm+1 <= j <= NumTrc-jap
      
         do j = jm+1, NumTrc-jap
         
c-----------------------------------------------------------------------
c     Compute partial medians for i < im, and a full median for i == im

            do i = 1,im
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              1, j-jap, k,
     3                              i+iap, jj, kend)     
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                       
            enddo

c-----------------------------------------------------------------------
c     Compute medians for im+1 <= i <= isamp-iap

            do i = im+1, isamp-iap
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, j-jap, k,
     3                              ii, jj, kend)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif          
            enddo

c-----------------------------------------------------------------------
c     Compute partial sums for i >= isamp-im+2

            do i = isamp-im+2, isamp
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, j-jap, k,
     3                              isamp-i+im, jj, kend)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                   
            enddo
         enddo   
 
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c     Compute partial medians for j >= NumTrc-jm+2
      
         do j = NumTrc-jm+2, NumTrc
         
c-----------------------------------------------------------------------
c     Compute partial medians for i < im, and a full median for i == im

            do i = 1,im
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              1, j-jap, k, 
     3                              i+iap, NumTrc-j+jm, kend)     
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                       
            enddo

c-----------------------------------------------------------------------
c     Compute medians for im+1 <= i <= isamp-iap

            do i = im+1, isamp-iap
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, j-jap, k,
     3                              ii, NumTrc-j+jm, kend)
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif          
            enddo

c-----------------------------------------------------------------------
c     Compute partial sums for i >= isamp-im+2

            do i = isamp-im+2, isamp
               call sort_for_median(usort, tsum, live, ii, jj, kk,
     1                              isamp, NumTrc, length_usort,
     2                              i-iap, j-jap, k, 
     3                              isamp-i+im, NumTrc-j+jm, kend)  
               choose = length_usort/2   
               if (mod(length_usort,2) .eq. 0) then	
                  uout(i,j) = 0.5D+00*(usort(choose) + usort(choose+1))
               else
                  uout(i,j) = usort(choose+1)
               endif                   
            enddo
         enddo 
         kend = kend - 1  

       endif   
   
       end
         

 
      
      
 
