C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine write_avg_record(u, uhdr, live, uout, livesum, 
     1                            isamp, NumTrc, Nx_Pad, luout, lerr, 
     2                            lbyout,lenhed, im, kk, jj, fdead)
      implicit none

c-----------------------------------------------------------------------
c Bertram Kaufhold	05/01/98
c
C Each entry in uout corresponds to the median of each point in a record
c obtained using a window size as defined by the arguments in the command
c line of median3d. The result is the median over the window (full window
c or partial window at the edges of the dataset, respectively).
c-----------------------------------------------------------------------

      integer  isamp, NumTrc, Nx_Pad 
      integer luout, lerr, lbyout, lenhed, im, kk, jj
      real uout(isamp, NumTrc)
      real u(-lenhed+1:isamp), uhdr(lenhed, NumTrc)
      integer live(NumTrc), livesum(NumTrc)
      logical fdead

      integer j

c Do not output the medians of the padded traces

      do j = Nx_Pad+1, NumTrc-Nx_Pad

c Copy the trace header

         call vmov(uhdr(1,j), 1, u(-lenhed+1), 1, lenhed)

c Copy the trace data

         call vmov(uout(1,j), 1, u(1), 1, isamp)

c-----------------------------------------------------------------------
c If the fill dead traces flag (fdead) is not set, i.e. it is
c fdead = .false. fill the dead traces with zeros. Otherwise fill the 
c dead traces with the median values we calculated for them if the number
c of live traces is greater than 0.5*jj*kk.
c This might be useful if you want to interpolate between data points.
c Note: The consequence of this is that the dead traces along the 
c       outside border of the x-y-plane will have a higher likelihood
c       to be assigned to zero than the ones in the middle.

         if (.not.fdead) then
            if (live(j) .eq. 0) call vclr(u(1), 1, isamp)
         else
            if (live(j).eq.1 .or. livesum(j).gt.0.5*(jj*kk)) then 
            else
               call vclr(u(1), 1, isamp)
            endif 
         endif

c Write the trace

         call wrtape(luout, u(-lenhed+1), lbyout)

      enddo

      end
