C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ************************* Main Routine ******************************
c |   Program Description:                                            |
c |                                                                   |
c |  Read data and compute wavelet phase estimate from maximum        |
c |  kurtosis criteria defined by Roy White (Geophysical Journal, 95, |
c |  371-389).                                                        |
c *********************************************************************

c get machine dependent parameters 

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables

      integer     itr( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes
      integer     ns, ne, irs, ire 
      integer     argis
      integer     iend, ist, JJ, KK
      integer     itrhd(1),TH,lsum
      integer     ilp,ipo,ntin

      real  work(1),hold(1),taper(17),Ritr(1)
      real  x(1),y(1),sums(1)
      real  phest,degrad,ang,rang2,rang4,bwdth,bbw
      real  fac,zlag,dc,tvar,scaw,fs
      real  aaa,var,curt,cb,cc,cd,thc,thd,theta
      real  xkb,xkc,xkd

      pointer (pw,work),(ph,hold),(pitrh,itrhd)
      pointer (px,x),(py,y),(psums,sums)
      character  name * 7,  ntap* 255, ofile * 255

      logical  verbos,dead

c declare variables used by this routine

      integer pipe
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_StaCor, l_StaCor, ln_StaCor, StaCor

      equivalence (itr(1),Ritr(1))

c initialize variables

      data name /'MKPHASE'/
      data verbos/.false./
      data pipe/3/,lsum/5/

c get online help if requested

      TH = TRACEHEADER
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
          call help(LER)
          stop
      endif

c open printout file

#include <f77/open.h>

c parse command line parameters
      pi = 4.0*atan(1.0)
      ist = 0
      iend = 0
      ofile = ' '
      call cmdln ( ntap, ofile, irs,ire,ns,ne,ist,iend)

c open dataset

      call getln( luin, ntap, 'r', 0)
      if (luin .lt. 0) then
         write(LERR,*)'Cannot open N dataset', ntap
         write(LERR,*)'Check spelling / existence and rerun'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'MKPHASE: Cannot open dataset', ntap
         write(LER,*)'       Check spelling / existence and rerun'
         write(LER,*)'FATAL'
         stop
      endif


      xw = 90./16.
      xxw = 90.
      do i=1,17
       axw = xxw*pi/180.
       taper(i)=sin(axw)*sin(axw)
       xxw=xxw-xw
      end do
c open output dataset

      ilp   = LERR
      if(ofile.ne.' ')then
       call alloclun (luout)
       open(luout, file=ofile, status='unknown', err=880 )
       go to 881
880    continue
       write(LERR,*)'Unable to open output disk file for ',otap
       write(LERR,*)'Check disk permissions'
       write(LER ,*)'Unable to open output disk file for ',otap
       write(LER ,*)'Check disk permissions'
       call lbclos(luin)
       call ccexit (666)
881    continue
      else
       luout = LOT
      endif

      ipo = luout


c read the line header from dataset

      lbytes = 0
      call rtape ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)'MKPHASE: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         write(LER,*)'MKPHASE: no header read on unit ',ntap
         write(LER,*)'FATAL'
         write(LER,*)' '
         close (luout)
         stop
      endif

c  get global parameters from lineheader

      call saver( itr, 'NumSmp', nsamp , LINHED )
      call saver( itr, 'SmpInt', nsi   , LINHED )
      call saver( itr, 'NumTrc', ntrc  , LINHED )
      call saver( itr, 'NumRec', nrec  , LINHED )
      call saver( itr, 'Format', iform , LINHED )
      call saver( itr, 'UnitSc', units , LINHED )
 
      if(ist.eq.0)ist=nsi
      if(iend.eq.0)iend=(nsamp-1)*nsi
      lentr = iend - ist + nsi
      lentr = lentr/nsi
      if(units.eq.0)units=0.001
      fs=float(nsi)*units
      if(ire.eq.0)ire=nrec
      if(irs.eq.0)irs=1
      if(ne.eq.0)ne=ntrc
      if(ns.eq.0)ns=1
      numrecs = ire-irs+1
      ntr     = ne - ns + 1
      numtrcs = numrecs*ntr
      ntin = numtrcs
      call sizefloat(isz)
      iget=isz*nsamp
      iab=0
      ier=0
      ner = 0
      nget = 0
      nget = nget+iget
      call galloc(pw   ,iget,ier,iab)
      if(ier.ne.0)ner=ner+1
      nget = nget+iget
      call galloc(ph   ,iget,ier,iab)
      if(ier.ne.0)ner=ner+1
      call galloc(px   ,iget,ier,iab)
      if(ier.ne.0)ner=ner+1
      nget = nget+iget
      call galloc(py   ,iget,ier,iab)
      if(ier.ne.0)ner=ner+1
      iget=lsum*isz
      nget=nget+iget
      call galloc(psums,iget,ier,iab)
      iget = ITRWRD*isz
      nget = nget+iget
      call galloc(pitrh,iget,ier,iab)
      if(ier.ne.0)ner=ner+1
      if(ner.ne.0)then
       write(LERR,*)'Unable to allocate ',nget,' bytes of memory'
       write(LERR,*)'FATAL! '
       write(LER ,*)'Unable to allocate ',nget,' bytes of memory'
       write(LER ,*)'FATAL! '
       call lbclos(luin)
        close (luout)
       stop
      endif

c set up pointers to trace header values to be used in this routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TH)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TH)

c print historical line header from dataset to printout file

      lname =  7
      call hlhprt (itr, lbytes, name, lname, LERR)

      if( nsamp .gt. SZLNHD ) then
         write(LERR,*)'Too many samples in traces -- FATAL'
         write(LERR,*)'window the input data & rerun'
         write(LER,*)'MKPHASE: '
         write(LER,*)'Too many samples in traces '
         write(LER,*)'window the input data & rerun'
         write(LER,*)'FATAL'
         stop
      endif


      call vclr(sums,1,lsum)
      tvar = 0.
      xws = float(ist )/1000.+ fs/2
      xwe = float(iend)/1000.+ fs/2
      iws = xws/fs + 1
      iwe = xwe/fs + 1
       if(iwe.gt.nsamp)iwe=nsamp
      lw = iwe-iws+1
      if(lw.gt.nsamp)lw=nsamp
       lentr = lw
c skip to start record in each dataset if required
      if(irs.gt.1)then
       call recskp ( 1, irs-1, luin, ntrc, itr )
      endif

      jtr=0
      frs = 1./fs
      write(ilp, *)' '
      write(ilp, *)' Start rec = ',irs,' End rec = ',ire
      write(ilp, *)' Start trc = ',ns, ' End trc = ',ne
      write(ilp, *)' Start win = ',(iws*fs-fs)*1000,' ms',
     :               ' End win = ',(iwe*fs-fs)*1000,' ms'
      write(ilp, *)' '
      write(ilp,10)
10    format (1x,'ensemble',1x,'trace',2x,'statbw (hz)',2x,
     : 'autocor(0)',4x,'dc amp',
     : 4x,'av abs amp',3x,'variance',3x,'kurtosis (3=gaussian)')

      DO JJ = irs, ire
c skip to start trace if necessary
       if ( ns .gt. 1 ) then
        call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )
       endif
       nk=0
       id1=0
       id2=0

       DO KK = ns, ne

        nbytes = 0
        call rtape ( luin , itr, nbytes )
        if(nbytes .eq. 0) then
         write(LERR,*)'End of file on input :'
         write(LERR,*)'  rec= ',JJ,'  trace= ',KK
         write(LER ,*)'End of file on input :'
         write(LER ,*)'  rec= ',JJ,'  trace= ',KK
c        call lbclos(luin)
c        close (luout)
c        stop
         go to 111
        endif

        nk=nk+1
        call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,StaCor,TH)
        call vmov(itr(ITRWRD+1),1,work,1,nsamp)
        dead=.false.
        ncount=0

        do j=1,nsamp
         if(work(j).ne.0.0)ncount=ncount+1
        end do

        if(ncount.eq.0)dead=.true.

        if ( StaCor .lt. 30000.and..not.dead ) then
         jtr=jtr+1
*        call vmov(itr(ITRWRD+iws),1,x,1,lw)
         m = 0
         km=17
         lm=0
         do j=iws,iwe
          lm=lm+1
          x(lm)=Ritr(ITRWRD+j)
          if(lm.lt.18)then
           x(lm)=x(lm)*taper(km)
           km=km-1
          endif
          if(lm.ge.lw-16)then
           m=m+1
           x(lm)=x(lm)*taper(m)
          endif
         end do
         zlag=0.
         do j=1,lentr
          zlag=zlag+x(j)*x(j)
         end do
c    normalise to unit autocorrelation
         fac=sqrt(zlag)
         if(fac.eq.0)fac=1.
         do j=1,lentr
          x(j)=x(j)/fac
         end do
         call statbw(x, lentr, frs, bwdth, bbw)
         call remdc(lentr,x, dc)
         call kurvar(lentr, x, aaa, var, curt)
c    update variance of composite trace
         tvar=tvar+var
         write(ilp,12) JJ,KK, bwdth, zlag, dc, aaa, var, curt
   12 format(1x,i5,1x,i5,3x,f6.1,5x,e10.4,2x,e10.4,2x,e10.4,3x,e10.
     :4,3x,e12.4)
c
c      compute quadrature trace, remove dc and form running sums
c
         ierr = 0
         lw = lentr
         call hilbertx(x,lw,y,ierr)
*        lhil = 129
*        lout = lw + lhil - 1
*        call quad(lw, x, lout, y, iflag)
         call remdc(lentr, y, dc)
         call mksums(lentr, x, y, sums)

        endif

       END DO

c skip from current trace to end of record

       if ( ne .lt. ntrc) then
        call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )
       endif

      END DO

c +==============================================================+
c |   all traces in - now scale sums (hope this is ok: sub scale |
c |  missing tvar is variance of supertrace - replaces fac2 in   |
c |  R.E.W. code                                                 |
c +==============================================================+

111   continue

      scaw = float(jtr)*float(lentr)
      do k=1, lsum
       sums(k)=sums(k)/scaw
      end do
c +=========================+
c |  max kurtosis phase est |
c +=========================+
      call mkpest(sums, cb, cc, cd, thc, thd, theta, phest,
     *xkb,xkc,xkd)
 
      write(ipo,13)-phest
13    format(1x,'"Phase estimate = ',f7.1,' deg')
c +=============================================================+
c |  calculate kurtosis v angle at 1 deg increments: 0-180 deg  |
c +=============================================================+
      degrad=180./pi
      ang=0.
      nang = 181
      cb=xkb
      cc=xkc
      cd=xkd
      do j=1,nang
       rang=ang/degrad
       rang=-rang
       rang2=2*rang
       rang4=4*rang
       curt=cb+cc*cos(rang2)+cd*cos(rang4)-sums(4)*sin(rang2)-
     :   0.5*sums(5)*sin(rang4)
       write(ipo,14)ang,curt
       ang=ang+1.
      end do
14    format(1x,f6.1,2x,e12.4)


c normal termination

c234567
      call lbclos(luin)
      close (luout)

      write(LERR,*)' processed ',jtr,' traces'
      write(LERR,*)' Normal Termination'
      write(LER,*)'MKPHASE: Normal Termination'
      stop

      end


      subroutine help(LER)

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for MKPHASE: Maximum'
        write(LER,*)' Kurtosis Phase Estimation'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]     -- input data set   (stdin)'
        write(LER,*)'-S[ofile]    -- mkphase output'
        write(LER,*)'-rs[rs]      -- start rec        (1)'
        write(LER,*)'-re[re]      -- end rec          (last)'
        write(LER,*)'-ns[rs]      -- start rec        (1)'
        write(LER,*)'-ne[re]      -- end rec          (last)'
        write(LER,*)'-s           -- start time       (0)'
        write(LER,*)'-e           -- end time         (end trace)'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'  mkphase -N[] -O[] -rs[] -re[] -ns[] -ne[]'
        write(LER,*)'  -s[] -e[]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap - C*255  input file name
c     ofile  - C*255  output file name
c    irs   - I      start record
c    ire   - I      stop end record
c    constant -R    a constant to be ingnored in compting average.
c-----
      subroutine cmdln ( ntap, ofile,irs,ire,ns,ne,ist,iend)

c declare variable passed from calling routine

      character    ntap*(*),  ofile*(*)
      integer irs,ns,ne,ist,iend



      call argstr('-N',ntap,' ',' ')
      call argstr('-S',ofile,' ',' ')
      call argi4('-rs',irs,0,0)
      call argi4('-re',ire,0,0)
      call argi4('-ns',ns,0,0)
      call argi4('-ne',ne,0,0)
      call argi4('-s',ist,0,0)
      call argi4('-e',iend,0,0)

      return
      end
      
      subroutine verbal ( ntap, ofile)

#include <f77/iounit.h>

c declare variables passed from calling routine

      character ntap*(*), ofile*(*)


      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '
      write(LERR,*)' N1 Dataset '
      write(LERR,*)' '
      write(LERR,*) ' Filename           =  ',ntap
      write(LERR,*)' '
      write(LERR,*)' N2 Dataset '
      write(LERR,*)' '
      write(LERR,*)' O Dataset '
      write(LERR,*)' '
      write(LERR,*) ' Filename           =  ', ofile
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '
      
      return
      end
      subroutine remdc(lentr,x,dc)
c    remove dc from trace x
      implicit none
      integer lentr,j
      real x(*),dc
      real*8 sum,xlentr
      sum=0.
      xlentr = lentr
      do j=1,lentr
       sum=sum+x(j)
      end do
      dc=sum/xlentr
      do j=1,lentr
       x(j)= x(j)- dc
      end do
      return
      end
      subroutine statbw(x,nx, fs, ubbw, bbw)
c
c    calculates statistical bandwidth from autocovariance according to
c    walden and white (1989, ext55061)
c    input trace x, length lx, sampling frequency fs
c    ubbw is the unbiassed bandwidth, bbw the standard unsmoothed estima
c    te
c    note: assumes that trace has been scaled so there are no over/under
c    flows
c
c234567
      integer nx, i
      real x(*), xx(1)
      real fs, g2, sum, fac, del, div, ubbw, bbw

      pointer (pxx,xx)

      call sizeinteger(isz)
      iget = nx*isz
      iab=0
      ier=0
      ner = 0
      nget = 0
      nget = nget+iget
      call galloc(pxx   ,iget,ier,iab)
c
c    calculate one-sided autocovariance
c
      call cross(nx,x,nx,x,nx,xx)
c
c    bandwidth
c
      g2=xx(1)*xx(1)
      sum=0.5*g2
      fac=1.0
      del=1./float(nx)
      div=sum
      do i=1,nx
        fac=fac-del
        div=div+xx(i)*xx(i)
        sum=sum+xx(i)*xx(i)*fac
      enddo
      sum=2.*sum
      div=2.*div
      bbw=0.5*g2*fs/sum
      ubbw=5.0*bbw/3.0-del*fs
c
c    zero autocovariance
c
      call zero(nx,xx)
      call gfree(pxx)
      return
      end
      subroutine cross(lx,x,ly,y,lg,g)
      integer lx,ly,lg
      real x(*), y(*), g(*)
      do j=1,lg
        call dot(min0(ly,lx-j+1),x(j),y,g(j))
      enddo
      return
      end

      subroutine dot(l,x,y,p)
      integer l, i
      real x(*), y(*),p
      p=0.0
      if(l.le.0)return
      do i=1,l
        p=p+x(i)*y(i)
      enddo
      return
      end
