C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln(ntap,otap,ns,ne,irs,ire,tm,vm,nramp,mindis,disco,
     1     verbos,restore,offset,mfile,lucrd,keywrd,ONword,OFFword,off,
     2     dstabs,tmul,dmul,flat,refl,strwrd,flt,
     3     liword, diword, limin,limax,dimin,dimax,maxdis)

#include <f77/iounit.h>

      integer    argis, ns,ne,irs,ire,nramp,mindis, maxdis

      real       tm,vm,tmul,dmul

      character  ntap*(*), otap*(*), mfile*(*)
      character  keywrd * 6, ONword*(*), OFFword*(*)
      character  strwrd * 6, liword * 6, diword * 6
      integer    limin,limax,dimin,dimax

      logical    verbos, restore, offset, disco, off, dstabs
      logical    flat, refl, flt

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c   mindis  - I      minimum distance to mute
c     tm    - R      mute start time
c     vm    - R      mute velocity
c    restore- L      restore previous mute/bdmute
c    verbos - L      verbose output or not
c-----

      call argi4  ('-dimin',dimin,0,0)
      call argi4  ('-dimax',dimax,9999999,9999999)
      call argr4('-dmul',dmul,1.0,1.0)

      call argstr ('-hw1',ONword,'VPick1','VPick1')
      call argstr ('-hw2',OFFword,'VPick2','VPick2')
      call argstr ('-hws',strwrd,' ',' ')
      call argstr ('-hwl',liword,' ',' ')
      call argstr ('-hwd',diword,' ',' ')

      call argstr ('-K', keywrd, 'RecNum', 'RecNum')

      call argi4  ('-limin',limin,0,0)
      call argi4  ('-limax',limax,9999999,9999999)

      call argi4  ('-maxd',maxdis,0,0)
      call argi4  ('-mind',mindis,0,0)

c I am depricating the old -md in favour of -mind to go along with 
c -maxd.  If there is an old script being run then -md may still get 
c used.  This should pick it up if it is there The next 
c logical update here will be to add signed trace distance capability
c rather than iabs[dstsgn] which is the case now.[Garossino]. 

      if ( mindis .eq. 0 ) call argi4  ('-md',mindis,0,0)

      call argi4 ('-nramp',nramp,10,10)
      call argi4  ('-ns',ns,0,0)
      call argi4  ('-ne',ne,0,0)
      call argstr ('-N', ntap, ' ', ' ' )

      call argstr ('-O', otap, ' ', ' ' )

      call argi4  ('-rs',irs,0,0)
      call argi4  ('-re',ire,0,0)
      restore = (argis('-R') .gt. 0)

      call argr4('-tmul',tmul,1.0,1.0)
      call argr4 ('-tm', tm,0.0,0.0)

      call argr4 ('-vm',vm,100000.0,100000.0)

      offset  = .false.

      dstabs  = (argis('-A') .gt. 0)
      disco   = (argis('-D') .gt. 0)
      flat    = (argis('-F') .gt. 0)
      refl    = (argis('-H') .gt. 0)
      off     = (argis('-off') .gt. 0)
      flt     = (argis('-float') .gt. 0)

      if ( flt ) then
         if (ONword(1:6) .eq. 'VPick1' .AND.
     1       OFFword(1:6) .eq. 'VPick2') then
             write(LERR,*)' '
             write(LERR,*)'COMMAND LINE ERROR IN mute:'
             write(LERR,*)'For floating headers cannot choose two'
             write(LERR,*)'adjacent ones ',ONword(1:6),' ',OFFword(1:6)
             write(LER ,*)' '
             write(LER ,*)'COMMAND LINE ERROR IN mute:'
             write(LER ,*)'For floating headers cannot choose two'
             write(LER ,*)'adjacent ones ',ONword(1:6),' ',OFFword(1:6)
             stop
         endif
      endif
         
         call argstr ('-M', mfile, ' ', ' ')
         if (mfile(1:1) .ne. ' ') then
            offset  = .true.
            lucrd = lucard
            open(unit=lucrd, file = mfile, status='old', iostat=ierr)
         
            if(ierr .ne. 0) then
               write(LERR,*)'Could not open time-offset mute file'
               write(LERR,*)'Check existence'
               call ccexit (667)
            endif
         endif

      verbos  = (argis('-V') .gt. 0)

      return
      end
