C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE MUTEAA ( NSAMP,  tm,   vm, DIST,  SAMP, NRAMP, Y ,
     1                    TMUTE, off,refl,strwrd,tmst, freq_flag )
#include <f77/lhdrsz.h>

      REAL        Y(SZLNHD) ,  tm,    vm,     SAMP, TMUTE, tmst
      INTEGER     NRAMP, ITM, INDEX
      CHARACTER   strwrd * 6, freq_flag*2
      LOGICAL     off, refl
C**********************************************************************C
C
C  SUBROUTINE ARGUMENTS
C
C  NSAMP = NUMBER OF SAMPLES IN TRACE
C  TO    = MUTE TIME IN SEC AT ZERO OFFSET
C  vm    = MUTE VELOCITY
C  DIST  = OFFSET FROM SOURCE TO TRACE
C  SAMP  = SAMPLE INTERVAL IN SECONDS
C  NRAMP = LENGTH OF RAMP IN SAMPLES
C  Y     = TRACE VECTOR
C
C**********************************************************************C
C
C  ZERO OUT FIRST PART OF TRACE
C
C**********************************************************************C
      if ( refl ) then

         v2 = vm * vm
         x2 = dist * dist
         t2 = (tmst + tm) * (tmst + tm)
         TMUTE = sqrt ( t2 + x2 / v2)
         ITM   =  ( TMUTE / SAMP ) + 0.5
      else

         TMUTE =  ( tmst + tm + ( DIST / vm ) )
         ITM   =  ( TMUTE / SAMP ) + 0.5

      endif

      IF (off) THEN

         if ( freq_flag .eq. 'fk' ) then

            if ( (itm + nramp) .lt. (nsamp/2) ) then
               do  i = itm+nramp, nsamp/2
                  y (i) = 0.
               enddo
  
               do  i = 1, nramp
                  wt = float(nramp-i) / float(nramp)
                  y(itm+i) = y(itm+i) * wt
               enddo    
            endif

         else

            if ( ( itm + nramp) .lt. nsamp .and.
     :           (itm + nramp ) .gt. 0 ) then
               do  i = itm+nramp, nsamp
                  y (i) = 0.
               enddo
            endif

            do  i = 1, nramp
               wt = float(nramp-i) / float(nramp)
               if  ( ( itm + i) .gt. 0 .and.
     :              (itm + i ) .lt. nsamp ) then
                  y(itm+i) = y(itm+i) * wt
               endif
            enddo    
         endif

      ELSE

         IF( ITM .GT. NSAMP .AND. ( ITM - NRAMP ) .LT. NSAMP ) THEN
            INDEX  = ITM - NRAMP
            ISTART = 1
            ISTOP  = NSAMP - INDEX + 1
            call vclr ( y, 1, index )
            CALL RAMP ( INDEX, ISTART, ISTOP, NRAMP, Y )
         ELSEIF ( ( ITM - NRAMP ) .GE.          NSAMP ) THEN
            call vclr ( y, 1, nsamp )
         ELSEIF ( ITM .LE. NSAMP .AND. ITM .GE. NRAMP ) THEN
            ISTART= 1
            ISTOP = NRAMP
            INDEX = ITM - NRAMP
            call vclr ( y, 1, index )
            CALL RAMP ( INDEX, ISTART, ISTOP, NRAMP, Y )
         ELSEIF ( ITM .LT. NRAMP .AND. ITM .GT. 0     ) THEN
            ISTART= NRAMP - ITM + 1
            ISTOP = NRAMP
            INDEX = ITM - NRAMP
            CALL RAMP ( INDEX, ISTART, ISTOP, NRAMP, Y )
         ENDIF

      ENDIF

      return
      END
