C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C----------------------------------------------------------------------C00168200
C                                                                       00168300
      SUBROUTINE BFILS(IFTYPE,ITYPE,ISI,INI,IFRQ,MAXL,M,IDB,            00168400
     *                 INVERT,EXP,LISTF,FILT,WRK,IPR,IOUT,IERR)         00168500
C                                                                       00168600
C----------------------------------------------------------------------C00168700
C                                                                       00168800
C     IFTYPE  I*4     FILTER TYPE                                       00168900
C                     0 = ORMSBY        (BPASS OR FLNOR)                00169000
C                     1 = ROSS          (ROSSF)                         00169100
C                     2 = BESSEL        (BESSLK)                        00169200
C     ITYPE   I*4     ORMSBY FILTER TYPE USED IF IFTYPE=0               00169300
C                     0 = OPTIMUM LENGTH         (BPASS)                00169400
C                     1 = MAXIMUM LENGTH         (BPASS)                00169500
C                     2 = OLD LENGTH             (BPASS)                00169600
C                     .GT. 2 LENGTH OF FIXED LENGTH FILTER.   (FLNOR)   00169700
C     ISI     I*4     SAMPLE INTERVAL IN MSEC.                          00169800
C     INI     I*4     NUMBER OF SAMPLES/TRACE                           00169900
C     IFRQ    I*4     8-ELEMENT ARRAY OF FILTER FREQUENCY POINTS        00170000
C     MAXL    I*4     MAXIMUM LENGTH OF FILTER 1001 OR LESS             00170100
C     M       I*4     NUMBER OF FILTER POINTS (RETURNED TO CALLER)      00170200
C     IDB     I*4     DB REJECT LEVEL (21-120) FOR ROSS OR BESSEL       00170300
C                     IF 0 ON INPUT WILL BE SET TO 65                   00170400
C     INVERT  I*4     INVERT FILTER 0=NO 1=YES                          00170500
C     EXP     I*4     ROSS WEIGHTING EXPONENT (DEFAULT = 3)             00170600
C     LISTF   I*4     TYPE OF PLOT                                      00170700
C                     -1= DO NOT PRINT VALUES OR PLOT FILTER            00170800
C                     0 = PRINT FILT VALUES AND PLOT AMP. ONLY          00170900
C                     1 = 0 ABOVE + PLOT FREQ. RESPONSE ALSO            00171000
C                     2 = PLOT FREQ.RESPONSE ONLY                       00171100
C     FILT    R*4     OPERATOR ARRAY                                    00171200
C     WRK     R*4     WORK ARRAY                                        00171300
C     IPR     I*4     LOGICAL UNIT OF PRINT FILE                        00171400
C     IOUT    I*4     BYPASS FILTERING FLAG                             00171500
C                     0 = FILTER AS NORMAL                              00171600
C                     -1= BYPASS FILTERING, NO FILTER GENERATED         00171700
C     IERR    I*4     ERROR CODE RETURNED.                              00171800
C                      0 - NO ERRORS.                                   00171900
C                      1 - FREQUENCIES ARE NOT IN ASCENDING ORDER.      00172000
C                      2 - A FREQUENCY EXCEEDS THE NYQUIST FREQUENCY.   00172100
C                      3 - FILTER LENGTH COMPUTATION OPTION IS INVALID. 00172200
C                      4 - SAMPLE INTERVAL IS LESS THAN 1.              00172300
C                      5 - INVALID WEIGHT CENTERING OPTION.             00172400
C                      6 - EXPONENT IS LESS THAN 0.                     00172500
C                      7 - FILTER LENGTH IS NOT ODD NUMBER OF SAMPLES.  00172600
C                      8 - OUT/OUT FILTER IS SPECIFIED.                 00172700
C                      9 - REJECT LEVEL IS LESS THAN 21 DB OR IS        00172800
C                          GREATER THAN 120 DB. (ROSSF AND BESSLK)      00172900
C                     10 - MAXIMUM FILTER LENGTH CANNOT BE 0.           00173000
C                     12 - FILTER TYPE MUST BE 0, 1 OR 2.               00173100
C                     18 - LENGTH TO CENTER IS 0 FOR IOPT=2. (ROSSW)    00173200
C----------------------------------------------------------------------C00173300
C                                                                       00173400
      DIMENSION IFRQ(8),WRK(1001),FILT(1001)                            00173500
      CHARACTER*8 PGN(4),ANAM                                           00173600
      DATA PGN/'BPASS   ','ROSSF   ','BESSLK  ','FLNOR   '/             00173700
C                                                                       00173800
C----------------------------------------------------------------------C00173900
C                                                                       00174000
      IOUT = 0                                                          00174100
      IERR = 0                                                          00174200
      IF(IFTYPE.GT.-1.AND.IFTYPE.LT.3)GO TO 10                          00174300
      WRITE(IPR,400)                                                    00174400
400   FORMAT('0',T10,'***M0100*** ERROR DETECTED IN SUBROUTINE BFILS',/,00174500
     *       10X,'THE FILTER TYPE REQUESTED IS NOT AVAILABLE',/,        00174600
     *       10X,'FILTER TYPE MUST BE 0, 1 OR 2',//)                    00174700
      IERR=12                                                           00174800
      GO TO 1000                                                        00174900
10    IF(IFTYPE.GT.0.AND.IDB.EQ.0)IDB = 65                              00175000
      IF(IFTYPE.EQ.0.AND.ITYPE.GT.2)                                    00175100
     *CALL FLNOR (ITYPE,IFRQ(1),IFRQ(2),IFRQ(3),                        00175200
     *            IFRQ(4),IFRQ(5),IFRQ(6),IFRQ(7),IFRQ(8),INVERT,       00175300
     *            ISI,M,FILT(1),WRK(1),EXP,IERR)                        00175400
C                                                                       00175500
      IF(IFTYPE.EQ.0.AND.ITYPE.LE.2)                                    00175600
     *CALL BPASS (ITYPE,IFRQ(1),IFRQ(2),IFRQ(3),                        00175700
     *            IFRQ(4),IFRQ(5),IFRQ(6),IFRQ(7),IFRQ(8),INVERT,       00175800
     *            ISI,M,FILT(1),WRK(1),EXP,IERR)                        00175900
C                                                                       00176000
      IF(IFTYPE.EQ.1)                                                   00176100
     *CALL ROSSF (ISI,INI,MAXL,IFRQ(1),IDB,INVERT,M,FILT(1),IERR)       00176200
C                                                                       00176300
      IF(IFTYPE.EQ.2)                                                   00176400
     *CALL BESSLK(ISI,INI,MAXL,IFRQ(1),IDB,INVERT,M,FILT(1),IERR)       00176500
C                                                                       00176600
C-----CHECK FOR ERROR, LOG AND RETURN ERROR CODE TO CALLING PROGRAM.    00176700
C                                                                       00176800
      IF(IERR.EQ.0)GO TO 500                                            00176900
C                                                                       00177000
      ANAM = PGN(IFTYPE+1)                                              00177100
C                                                                       00177200
      IF(IFTYPE.NE.0)GO TO 80                                           00177300
      IF(ITYPE.LE.2) GO TO 70                                           00177400
C                                                                       00177500
C --- FLNOR                                                             00177600
C                                                                       00177700
      IF(ITYPE.GT.2)ANAM = PGN(4)                                       00177800
      CALL FLPKER(IPR,ANAM,IERR,IFERR)                                  00177900
      IF(IERR.EQ.6) GO TO 500                                           00178000
      IOUT=-1                                                           00178100
      GO TO 1000                                                        00178200
C                                                                       00178300
C --- BANDPASS                                                          00178400
C                                                                       00178500
70    CALL FLPKER(IPR,ANAM,IERR,IFERR)                                  00178600
      IF(IERR.EQ.6) GO TO 500                                           00178700
      IOUT=-1                                                           00178800
      GO TO 1000                                                        00178900
80    IF(IFTYPE.NE.1)GO TO 90                                           00179000
C                                                                       00179100
C --- ROSS FILTER                                                       00179200
C                                                                       00179300
      CALL FLPKER(IPR,ANAM,IERR,IFERR)                                  00179400
      IF(IERR.EQ.9) GO TO 500                                           00179500
      IOUT=-1                                                           00179600
      GO TO 1000                                                        00179700
C                                                                       00179800
C --- BESSEL FILTER                                                     00179900
C                                                                       00180000
90    CALL FLPKER(IPR,ANAM,IERR,IFERR)                                  00180100
      IF(IERR.EQ.9) GO TO 500                                           00180200
      IOUT=-1                                                           00180300
      GO TO 1000                                                        00180400
C                                                                       00180500
  500   IF(LISTF.NE.-1)
     *   CALL GRAPF(FILT(1),WRK(1),M,ISI,IPR,LISTF,INVERT,IFERR)        00180700
CC500 continue
1000  CONTINUE                                                          00180800
      RETURN                                                            00180900
      END                                                               00181000
