C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C---------------------------------------------------------------------C 00100800
      SUBROUTINE FILSET (FILT, N, MODE, ITECH, ITYPE, IFORCE, ISI, NIT, 00100900
     *              INI, F, L, RCARD, CPGM, IERCNT, MTFLAG, MTBPI)      00101000
C---------------------------------------------------------------------C 00101100
#include <f77/iounit.h>
C                                                                       00101200
      REAL*4    N21, F(20), FILT(1001,21), WRK(1001)                    00101300
C                                                                       00101400
      INTEGER*4 L(21),IFRQ(8),MTBP(4),CFREQ                             00101500
C                                                                       00101600
      CHARACTER*4  CPGM,DFILT,CKD                                       00101700
      CHARACTER*35 HLHAR2                                               00101800
      CHARACTER*80 RCARD                                                00101900
C                                                                       00102000
      COMMON IHDR1(1500)                                                00102100
      COMMON /JUNK/   ISIA,ISVFLG,IPRR,INVERT                           00102200
      COMMON /DAFDXX/ ICR,IPR,IAP,LUI,LUO,XFLSH,IPANLF,LUI2,LURSTR      00102300
      COMMON /FREQ/   IPDR,CFREQ(4,39)                                  00102400
C                                                                       00102500
      EQUIVALENCE (IFRQ(1),IF1),                                        00102600
     A            (IFRQ(2),IF2),                                        00102700
     B            (IFRQ(3),IF3),                                        00102800
     C            (IFRQ(4),IF4),                                        00102900
     D            (IFRQ(5),IF5),                                        00103000
     E            (IFRQ(6),IF6),                                        00103100
     F            (IFRQ(7),IF7),                                        00103200
     G            (IFRQ(8),IF8)                                         00103300
C                                                                       00103400
      DATA HLHAR2/'    (XX FILTERS  XXX,XXX,XXX,XXX)  '/                00103500
      DATA DFILT/'FLTR'/                                                00103600
C                                                                       00103700
C --- FILSET WILL READ IN THE 1FLTR CARDS AND SET UP THE FILTERS        00103800
C                                                                       00103900
      INVERT  = 0                                                       00104000
      IPLOT   = 0                                                       00104100
      ROSSW   = 3.0                                                     00104200
      IDB     = 65                                                      00104300
      MAXL    = 1001                                                    00104400
      MTBP(1) = 9999                                                    00104500
      MTBP(2) = 9999                                                    00104600
      MTBP(3) = -9999                                                   00104700
      MTBP(4) = -9999                                                   00104800
C                                                                       00104900
C --- SET NYQ TO THE NYQUIST FREQUENCY                                  00105000
C --- A CHECK WILL BE MADE OF THE HIGH PASS OF EACH FILTER AGAINST NYQ. 00105100
C                                                                       00105200
      NYQ = 500 / ISI                                                   00105300
C                                                                       00105400
C --- READ FIRST '1FLTR' CARD                                           00105500
C                                                                       00105600
      READ (RCARD, 190, END=200)  M, CKD                                00105700
C                                                                       00105800
C --- CHECK CARD TYPE                                                   00105900
      IF (CKD .EQ. DFILT .AND. M .EQ. 1) GO TO 250                      00106000
  190 FORMAT (I1, A4)                                                   00106100
C                                                                       00106200
  200 WRITE (IPR, 540) CPGM                                             00106300
  540 FORMAT(/, 1X, '** M0147 ** ERROR DETECTED BY SUBROUTINE FILSET',/,00106400
     *         13X, 'THE CARD IDENTIFIER (CC 1-5) OF THE CARD ',        00106500
     *              'FOLLOWING THE 1',A4,' CARD IS NOT SPECIFIED AS ',  00106600
     *              '1FLTR.', /,                                        00106700
     *         13X, 'VERIFY THAT YOU HAVE THE PROPER INPUT CARDS ',     00106800
     *              'BEFORE RESUBMITTING YOUR JOB.', /)                 00106900
      IERCNT = IERCNT + 1                                               00107000
C                                                                       00107100
C-----PROCESS 1FLTR CARDS                                               00107200
C                                                                       00107300
250   CALL RFILCD(IPR,RCARD,M,CKD,IFRQ,IDB,IFMODE,LISTF,IERCNT)         00107400
      IFLAG = LISTF                                                     00107500
      IF (IFLAG .EQ. 0) IFLAG = -1                                      00107600
      IFLAG1 = LISTF                                                    00107700
      IF1S = IF1                                                        00107800
      IF2S = IF2                                                        00107900
      NN = N                                                            00108000
      IF (MODE .NE. 0) GO TO 300                                        00108100
      N = 1                                                             00108200
      GO TO 270                                                         00108300
C                                                                       00108400
C --- READ '1FLTR' CARDS                                                00108500
  260 READ (ICR, 265, END=390) RCARD, M, CKD                            00108600
  265 FORMAT (A80, T1, I1, A4)                                          00108700
      CALL WRCARD (RCARD, 1, IPR)                                       00108800
C                                                                       00108900
C --- CHECK CARD TYPE                                                   00109000
      IF (CKD .EQ. DFILT .AND. M .EQ. 1) GO TO 268                      00109100
      WRITE (IPR, 540) CPGM                                             00109200
      IERCNT = IERCNT + 1                                               00109300
C                                                                       00109400
C-----PROCESS 1FLTR CARDS                                               00109500
C                                                                       00109600
268   CALL RFILCD(IPR,RCARD,M,CKD,IFRQ,IDB,IFMODE,LISTF,IERCNT)         00109700
      N = N + 1                                                         00109800
C                                                                       00109900
C --- CHECK NUMBER OF '1FLTR' CARDS                                     00110000
      IF (N .LE. 20) GO TO 270                                          00110100
C                                                                       00110200
      WRITE (IPR, 460) CPGM                                             00110300
  460 FORMAT(/, 1X, '** M0144 ** ERROR DETECTED BY SUBROUTINE FILSET',/,00110400
     *         13X, 'THE NUMBER OF FILTERS SPECIFIED (CC 17-18 ON ',    00110500
     *              'THE 1',A4,' CARD) IS GREATER THAN THE PROGRAM ',   00110600
     *              'MAXIMUM OF 20.', /,                                00110700
     *         13X, 'REDUCE THE NUMBER OF FILTERS SPECIFIED TO NOT ',   00110800
     *              'MORE THAN 20 BEFORE RESUBMITTING YOUR JOB.', /)    00110900
      IERCNT = IERCNT + 1                                               00111000
C                                                                       00111100
C --- VARIABLE FILTERS DESIGNED HERE                                    00111200
C                                                                       00111300
  270 WRITE (IPR, 280) IF1, IF2, IF3, IF4, IF5, IF6, IF7, IF8, IFLAG1   00111400
  280 FORMAT (//, 9X, '       IF1 IF2 IF3 IF4 IF5 IF6 IF7 IF8   ',      00111500
     *        'PRINTOUT FLAG', /16X, 8(I3, 1X), I10)                    00111600
C                                                                       00111700
C --- NEED TO SAVE THE CORNER FREQUENCIES                               00111800
C                                                                       00111900
      CFREQ(1,N) = IF1                                                  00112000
      CFREQ(2,N) = IF2                                                  00112100
      CFREQ(3,N) = IF3                                                  00112200
      CFREQ(4,N) = IF4                                                  00112300
C                                                                       00112400
C --- IF MODEL TRACE IS BAND-PASS FILTERED INPUT TRACE THEN FIND MINIMUM00112500
C --- IF1 AND IF2 AND MAXIMUM IF3 AND IF4                               00112600
C                                                                       00112700
      IF ( MTFLAG .NE. 1 ) GO TO 282                                    00112800
         IF ( IF1 .LT. MTBP(1) ) MTBP(1) = IF1                          00112900
         IF ( IF2 .LT. MTBP(2) ) MTBP(2) = IF2                          00113000
         IF ( IF3 .GT. MTBP(3) ) MTBP(3) = IF3                          00113100
         IF ( IF4 .GT. MTBP(4) ) MTBP(4) = IF4                          00113200
C                                                                       00113300
C     * * * *  COMPUTE FILTERS HERE  * * * *                            00113400
C                                                                       00113500
  282 CALL BFILS(IFMODE,ITYPE,ISI,INI,IFRQ,MAXL,M,IDB,                  00113600
     *           INVERT,ROSSW,IFLAG,FILT(1,N),WRK,IPR,IOUT,IERR)        00113700
      IF(IERR.NE.0 .AND. IERR.NE.6)                                     00113800
     *   IERCNT = IERCNT + 1                                            00113900
      IF(IERR.EQ.8) WRITE(IPR,10080)                                    00114000
10080 FORMAT(/,1X,'** M0169 ** ERROR FROM SUBROUTINE FILSET.',/,        00114100
     *        13X,'ALL PASS FILTER IS NOT ALLOWED IN PROGRAM DAFD.')    00114200
C                                                                       00114300
      IF3S = IF3                                                        00114400
      IF4S = IF4                                                        00114500
C                                                                       00114600
C --- CHECK FILTER FREQUENCY AGAINST NYQUIST                            00114700
C                                                                       00114800
      IF (IF4 .LE. NYQ) GO TO 285                                       00114900
C                                                                       00115000
      WRITE (IPR, 710) IF4, NYQ                                         00115100
  710 FORMAT(/, 1X, '** M0165 ** ERROR DETECTED BY SUBROUTINE FILSET',/,00115200
     *         13X, 'THE HIGH PASS OF THE FILTER SPECIFIED, ',I6,', ',  00115300
     *              'EXCEEDS THE NYQUIST FREQUENCY,',I6,'.', / ,        00115400
     *         13X, 'ENSURE THAT THE FILTER FREQUENCIES ARE PROPERLY ', 00115500
     *              'CODED BEFORE RESUBMITTING YOUR JOB.', / )          00115600
      IERCNT = IERCNT + 1                                               00115700
C                                                                       00115800
  285 L(N) = M                                                          00115900
      IF (N .EQ. 1) GO TO 290                                           00116000
      IF (ITECH .EQ. 0) F(N) = ((IF4-IF1+IF3-IF2)*.5)/FSCALE            00116100
      IF (ITECH .EQ. 1)                                                 00116200
     *    F(N) = SQRT((.3*(IF2-IF1+IF4-IF3)+IF3-IF2)/FSCALE)            00116300
      GO TO 260                                                         00116400
  290 IF (ITECH .EQ. 0) FSCALE = (IF4-IF1+IF3-IF2)*.5                   00116500
      IF (ITECH .EQ. 1) FSCALE = .3*(IF2-IF1+IF4-IF3)+IF3-IF2           00116600
      F(1) = 1.                                                         00116700
      GO TO 260                                                         00116800
C                                                                       00116900
C --- CONSTANT FILTERS DESIGNED HERE                                    00117000
C                                                                       00117100
  300 INC34 = IF4 - IF3                                                 00117200
      INC21 = IF2 - IF1                                                 00117300
C                                                                       00117400
C --- IF THE BANDPASS OF THE SECOND FILTER IS NOT EQUAL TO THE          00117500
C --- BANDPASS OF THE FIRST FILTER, SET IFORCE TO FORCE THE             00117600
C --- SLOW MODE OF PROCESSING                                           00117700
C                                                                       00117800
      IF ((INC21 .NE. INC34) .AND. (IFORCE .EQ. 0)) GO TO 310           00117900
      GO TO 330                                                         00118000
  310 IFORCE = 1                                                        00118100
      WRITE (IPR, 320) CPGM                                             00118200
  320 FORMAT(/, 1X, '** M0164 ** WARNING FROM SUBROUTINE FILSET', /,    00118300
     *         13X, 'FILTER DESIGN FLAG (CC 43 ON THE 1',A4,' CARD) ',  00118400
     *              'HAS BEEN RESET TO (1) TO FORCE THE SLOW MODE ',    00118500
     *              'OF PROCESSING', /,                                 00118600
     *         13X, 'BECAUSE THE BANDPASS OF THE SECOND FILTER DOES ',  00118700
     *              'NOT EQUAL THE BANDPASS OF THE FIRST FILTER.', /)   00118800
  330 CONTINUE                                                          00118900
      ISIA = ISI                                                        00119000
      IPRR = IPR                                                        00119100
      ICF = N / 2 + 1                                                   00119200
      LEN = IF3 - IF2                                                   00119300
      XFLSH = IF3 - IF1                                                 00119400
      INC21 = 8192                                                      00119500
C                                                                       00119600
C --- CALL ACURCY TO DETERMINE IF THE FAST MODE CAN BE USED FOR THE     00119700
C --- SPECIFIED FILTERS.  IF IT CAN'T, SWITCH TO THE SLOW MODE.         00119800
C                                                                       00119900
      IF (IFORCE .EQ. 0) CALL ACURCY (FD, INC21, ISI, XFLSH, N, *335)   00120000
      GO TO 350                                                         00120100
  335 IFORCE = 1                                                        00120200
C                                                                       00120300
      WRITE (IPR, 340) CPGM                                             00120400
  340 FORMAT(/, 1X, '** M0143 ** WARNING FROM SUBROUTINE FILSET', /,    00120500
     *         13X, 'THE FILTER DESIGN FLAG (CC 43 ON THE 1', A4,       00120600
     *              ' CARD) HAS BEEN RESET TO (1) TO FORCE ', /,        00120700
     *         13X, 'THE SLOW MODE OF PROCESSING.  THE SPECIFIED ',     00120800
     *              'FILTERS CANNOT BE ACCURATELY SHIFTED', /,          00120900
     *         13X, 'IN THE FREQUENCY DOMAIN.', /,                      00121000
     *         13X, 'PROCESSING CONTINUES USING THE SLOW MODE.', /)     00121100
  350 IF (ITECH .EQ. 0) FACT = (IF4-IF1+IF3-IF2)*.5                     00121200
      IF (ITECH .EQ. 1) FACT = .3*(IF2-IF1+IF4-IF3)+IF3-IF2             00121300
      DO 380 JII = 1, N                                                 00121400
         WRITE (IPR, 280) IF1,IF2,IF3,IF4,IF5,IF6,IF7,IF8,IFLAG1        00121500
C                                                                       00121600
C --- NEED TO SAVE THE CORNER FREQUENCIES                               00121700
C                                                                       00121800
      CFREQ(1,JII) = IF1                                                00121900
      CFREQ(2,JII) = IF2                                                00122000
      CFREQ(3,JII) = IF3                                                00122100
      CFREQ(4,JII) = IF4                                                00122200
C                                                                       00122300
C --- IF THE MODEL TRACE IS A BAND-PASS FILTERED INPUT TRACE FIND       00122400
C --- THE MINIMUM F1 AND F2 AND MAXIMUM F3 AND F4                       00122500
C                                                                       00122600
         IF ( MTFLAG .NE. 1 ) GO TO 355                                 00122700
            IF ( IF1 .LT. MTBP(1) ) MTBP(1) = IF1                       00122800
            IF ( IF2 .LT. MTBP(2) ) MTBP(2) = IF2                       00122900
            IF ( IF3 .GT. MTBP(3) ) MTBP(3) = IF3                       00123000
            IF ( IF4 .GT. MTBP(4) ) MTBP(4) = IF4                       00123100
C                                                                       00123200
  355    IF (JII .GT. 1 .AND. IFORCE .EQ. 0) GO TO 360                  00123300
         ISVFLG = IFLAG1                                                00123400
  360    CALL MOVE (0, FILT(1,JII), 0, 4004)                            00123500
         IF (IFORCE .EQ. 0 .AND. JII .NE. ICF) GO TO 370                00123600
C                                                                       00123700
C     * * * *  COMPUTE FILTERS HERE  * * * *                            00123800
C                                                                       00123900
      CALL BFILS(IFMODE,ITYPE,ISI,INI,IFRQ,MAXL,M,IDB,                  00124000
     *           INVERT,ROSSW,IFLAG,FILT(1,JII),WRK,IPR,IOUT,IERR)      00124100
      IF(IERR.NE.0 .AND. IERR.NE.6)                                     00124200
     *   IERCNT = IERCNT + 1                                            00124300
      IF(IERR.EQ.8) WRITE(IPR,10080)                                    00124400
C                                                                       00124500
  370    L(JII) = M                                                     00124600
         IF (ITECH .EQ. 0) F(JII) = (IF4-IF1+IF3-IF2)*.5/FACT           00124700
         IF (ITECH .EQ. 1)                                              00124800
     *       F(JII) = SQRT((.3*(IF2-IF1+IF4-IF3)+IF3-IF2)/FACT)         00124900
         IF1 = IF3                                                      00125000
         IF2 = IF4                                                      00125100
         IF3S = IF3                                                     00125200
         IF4S = IF4                                                     00125300
C                                                                       00125400
C --- CHECK FILTER FREQUENCY AGAINST NYQUIST                            00125500
C                                                                       00125600
         IF (IF4 .LE. NYQ) GO TO 375                                    00125700
         WRITE (IPR, 710) IF4, NYQ                                      00125800
C                                                                       00125900
         IERCNT = IERCNT + 1                                            00126000
  375    LEN = LEN * MODE                                               00126100
         IF3 = IF2 + LEN                                                00126200
  380 IF4 = IF3 + INC34                                                 00126300
C                                                                       00126400
C  SUPPLY L(1) FOR THE FAST MODE OF PROCESSING                          00126500
C                                                                       00126600
      IF (IFORCE .EQ. 0) L(1) = L(ICF)                                  00126700
C                                                                       00126800
C --- UPDATE LINE HISTORY                                               00126900
C                                                                       00127000
  390 IF (MODE .NE. 0 .OR. N .EQ. NN) GO TO 400                         00127100
C                                                                       00127200
      WRITE (IPR, 520) CPGM                                             00127300
  520 FORMAT(/, 1X, '** M0146 ** ERROR DETECTED BY SUBROUTINE FILSET',/,00127400
     *         13X, 'THE NUMBER OF FILTERS SPECIFIED (CC 17-18 ON ',    00127500
     *              'THE 1',A4,' CARD) DOES NOT EQUAL THE NUMBER OF ',  00127600
     *        /13X, '1FLTR CARDS SUPPLIED.', /,                         00127700
     *         13X, 'CODE THE PROPER VALUE FOR THE NUMBER OF FILTERS ', 00127800
     *              'BEFORE RESUBMITTING YOUR JOB.', /)                 00127900
      IERCNT = IERCNT + 1                                               00128000
  400 N21 = 2 * N + 1                                                   00128100
      IPLOT = 1                                                         00128200
      WRITE (HLHAR2(6:7),410) N                                         00128300
  410 FORMAT (I2)                                                       00128400
      WRITE (HLHAR2(18:20),420) IF1S                                    00128500
  420 FORMAT (I3)                                                       00128600
      WRITE (HLHAR2(22:24),430) IF2S                                    00128700
  430 FORMAT (I3)                                                       00128800
      WRITE (HLHAR2(26:28),440) IF3S                                    00128900
  440 FORMAT (I3)                                                       00129000
      WRITE (HLHAR2(30:32),450) IF4S                                    00129100
  450 FORMAT (I3)                                                       00129200
      CALL HLHprt (IHDR1, NIT, HLHAR2, 35, LERR)
C                                                                       00129400
C --- BUILD THE FILTER FOR MODEL TRACE TO BE BAND-PASS FILTERED INPUT   00129500
C --- TRACE                                                             00129600
C                                                                       00129700
      IF ( MTFLAG .NE. 1 ) GO TO 600                                    00129800
         MTBPI = N + 1                                                  00129900
         IFLAG = -1                                                     00130000
         CALL BFILS (IFMODE, ITYPE, ISI, INI, MTBP, MAXL, M, IDB,       00130100
     *               INVERT, ROSSW, IFLAG, FILT(1,MTBPI), WRK, IPR,     00130200
     *               IOUT, IERR)                                        00130300
         L(MTBPI) = M                                                   00130400
C                                                                       00130500
  600 RETURN                                                            00130600
      END                                                               00130700
