C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ******************************************************************** C00181300
C *                                                                  * C00181400
C *   PROGRAM - FLNOR                    ENTRY POINTS - FLNOR        * C00181500
C *   LANGUAGE - FORTRAN                                             * C00181600
C *   AUTHOR -                                                       * C00181700
C *   DATE WRITTEN - 04/26/84                                        * C00181800
C *   DATE LAST MODIFIED -                                           * C00181900
C *                                                                  * C00182000
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00182100
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00182200
C *                                                                  * C00182300
C *   ABSTRACT                                                       * C00182400
C *                                                                  * C00182500
C *    SUBROUTINE TO GENERATE A FIXED LENGTH BANDPASS, LOWPASS       * C00182600
C *    HIGHPASS, OR STACKED FILTER.  THE TYPE DESIGNED IS            * C00182700
C *    DETERMINED BY THE FREQUENCY VALUES ENTERED.                   * C00182800
C *                                                                  * C00182900
C *   SUBROUTINES CALLED                                             * C00183000
C *       ORMSBY ROSSW                                               * C00183100
C *                                                                  * C00183200
C *   USAGE                                                          * C00183300
C *                                                                  * C00183400
C *       CALL FLNOR (LTYPE,IF1,IF2,IF3,IF4,IF5,IF6,IF7,IF8,         * C00183500
C *                  INVERT,ISI,LF,FILTR,WORK,EXP,IERR)              * C00183600
C *                                                                  * C00183700
C *           LTYPE - USER DEFINED FILTER LENGTH.                    * C00183800
C *             IF1 - LOW CUT FREQUENCY FIRST FILTER STAGE.          * C00183900
C *             IF2 - LOW PASS FREQUENCY FIRST FILTER STAGE.         * C00184000
C *                   IF IF1 AND IF2 ARE ZERO THE FILTER WILL        * C00184100
C *                   BE A LOWPASS FILTER.                           * C00184200
C *             IF3 - HIGH PASS FREQUENCY FIRST FILTER STAGE.        * C00184300
C *             IF4 - HIGH CUT FREQUENCY FIRST FILTER STAGE.         * C00184400
C *                   IF IF3 AND IF4 ARE ZERO THE FILTER WILL        * C00184500
C *                   BE A HIGHPASS FILTER.                          * C00184600
C *             IF5 - LOW CUT FREQUENCY SECOND FILTER STAGE.         * C00184700
C *             IF6 - LOW PASS FREQUENCY SECOND FILTER STAGE.        * C00184800
C *             IF7 - HIGH PASS FREQUENCY SECOND FILTER STAGE.       * C00184900
C *             IF8 - HIGH CUT FREQUENCY SECOND FILTER STAGE.        * C00185000
C *                   IF IF5 THRU IF8 ARE 0 THE FILTER WILL BE       * C00185100
C *                   SINGLE STAGE.                                  * C00185200
C *          INVERT - INVERT FILTER:                                 * C00185300
C *                   0 = NO                                         * C00185400
C *                   1 = YES                                        * C00185500
C *             ISI - SAMPLE INTERVAL IN MSEC.                       * C00185600
C *              LF - LENGTH OF OPERATOR RETURNED.                   * C00185700
C *           FILTR - OPERATOR ARRAY.                                * C00185800
C *            WORK - WORK ARRAY.                                    * C00185900
C *             EXP - ROSS WEIGHTING EXPONENT (DEFAULT = 3).         * C00186000
C *            IERR - ERROR RETURNED                                 * C00186100
C *                   0 = NO ERROR.                                  * C00186200
C *                   1 = DEFINING FREQUENCIES ARE NOT IN            * C00186300
C *                       ASCENDING ORDER.                           * C00186400
C *                   2 = DEFINING FREQUENCIES EXEED THE NYQUIST     * C00186500
C *                       FREQUENCY FOR THE DATA.                    * C00186600
C *                                                                  * C00186700
C ******************************************************************** C00186800
C                                                                       00186900
      SUBROUTINE FLNOR (LTYPE,IF1,IF2,IF3,IF4,IF5,IF6,IF7,IF8,          00187000
     1                  INVERT,ISI,LF,FILTR,WORK,EXP,IERR)              00187100
      REAL FILTR(1001), WORK(1001)                                      00187200
C                                                                       00187300
      LF= LTYPE                                                         00187400
      SI = FLOAT(ISI)                                                   00187500
      FMAX = 1000.0 / (2.0 * SI)                                        00187600
      ITYPE = 0                                                         00187700
      F1 = FLOAT(IF1)                                                   00187800
      F2 = FLOAT(IF2)                                                   00187900
      F3 = FLOAT(IF3)                                                   00188000
      F4 = FLOAT(IF4)                                                   00188100
      F5 = FLOAT(IF5)                                                   00188200
      F6 = FLOAT(IF6)                                                   00188300
      F7 = FLOAT(IF7)                                                   00188400
      F8 = FLOAT(IF8)                                                   00188500
      IF (EXP.EQ.0.0) EXP = 3.0                                         00188600
      IF (IF5.EQ.0) GO TO 200                                           00188700
      ITYPE = 3                                                         00188800
  200 IF (IF1.EQ.0.AND.IF2.EQ.0) GO TO 300                              00188900
      IF (IF1.GE.IF2) GO TO 4800                                        00189000
  300 IF (ITYPE.NE.3) GO TO 700                                         00189100
      IF (IF2.GT.IF3) GO TO 4800                                        00189200
      IF (IF3.GE.IF4) GO TO 4800                                        00189300
      IF (IF4.GT.IF5) GO TO 4800                                        00189400
      IF (IF5.GE.IF6) GO TO 4800                                        00189500
      IF (IF8.NE.0) GO TO 500                                           00189600
      IF (IF7.NE.0) GO TO 400                                           00189700
      F7 = FMAX                                                         00189800
  400 F8 = FMAX                                                         00189900
  500 IF (F6.GT.F7) GO TO 4800                                          00190000
      IF (F7.LT.F8) GO TO 600                                           00190100
      IF (F7.EQ.FMAX.AND.F8.EQ.FMAX) GO TO 1100                         00190200
      GO TO 4900                                                        00190300
C                                                                       00190400
  600 IF (F8.GT.FMAX) GO TO 4900                                        00190500
      GO TO 1100                                                        00190600
C                                                                       00190700
  700 IF (IF4.NE.0) GO TO 900                                           00190800
      IF (IF3.NE.0) GO TO 800                                           00190900
      F3 = FMAX                                                         00191000
  800 F4 = FMAX                                                         00191100
  900 IF (F2.GT.F3) GO TO 4800                                          00191200
      IF (F3.LT.F4) GO TO 1000                                          00191300
      IF (F3.EQ.FMAX.AND.F4.EQ.FMAX) GO TO 2000                         00191400
      GO TO 4900                                                        00191500
C                                                                       00191600
 1000 IF (F4.GT.FMAX) GO TO 4900                                        00191700
      GO TO 2000                                                        00191800
C                                                                       00191900
 1100 CONTINUE                                                          00192000
      IF (F8.NE.F7) GO TO 1200                                          00192100
      IF (F8.EQ.FMAX) GO TO 1300                                        00192200
 1200 L1=LF                                                             00192300
      GO TO 1400                                                        00192400
C                                                                       00192500
 1300 L1 = 0                                                            00192600
 1400 L2=LF                                                             00192700
      L3=LF                                                             00192800
      IF (IF1.NE.0) GO TO 1500                                          00192900
      L4 = 0                                                            00193000
      GO TO 1600                                                        00193100
C                                                                       00193200
 1500 L4=LF                                                             00193300
 1600 IF (L2.GE.L1) GO TO 1700                                          00193400
      L2 = L1                                                           00193500
 1700 IF (L3.GE.L2) GO TO 1800                                          00193600
      L3 = L2                                                           00193700
 1800 IF (L4.GE.L3) GO TO 1900                                          00193800
      L4 = L3                                                           00193900
 1900 N = L4                                                            00194000
      GO TO 2800                                                        00194100
C                                                                       00194200
 2000 CONTINUE                                                          00194300
      IF (F4.NE.F3) GO TO 2100                                          00194400
      IF (F4.EQ.FMAX) GO TO 2200                                        00194500
 2100 L1=LF                                                             00194600
      GO TO 2300                                                        00194700
C                                                                       00194800
 2200 L1 = 0                                                            00194900
      ITYPE = 1                                                         00195000
 2300 IF (IF1.NE.IF2) GO TO 2400                                        00195100
      IF (IF1.EQ.0) GO TO 2500                                          00195200
 2400 L2=LF                                                             00195300
      GO TO 2600                                                        00195400
C                                                                       00195500
 2500 L2 = 0                                                            00195600
      ITYPE = 2                                                         00195700
 2600 IF (L2.LT.L1) GO TO 2700                                          00195800
      N = L2                                                            00195900
      GO TO 2800                                                        00196000
C                                                                       00196100
 2700 N = L1                                                            00196200
 2800 N1 = N                                                            00196300
      IF (ITYPE.NE.0) GO TO 3100                                        00196400
C                                                                       00196500
C         COMPUTE BANDPASS FILTER                                       00196600
C                                                                       00196700
      CALL ORMSBY (N,F3,F4,ISI,FILTR,IERR)                              00196800
C                                                                       00196900
      DO 2900 I=1,N1                                                    00197000
         WORK(I) = FILTR(I)                                             00197100
 2900 CONTINUE                                                          00197200
C                                                                       00197300
      CALL ORMSBY (N,F1,F2,ISI,FILTR,IERR)                              00197400
C                                                                       00197500
      DO 3000 I=1,N1                                                    00197600
         FILTR(I) = WORK(I)-FILTR(I)                                    00197700
 3000 CONTINUE                                                          00197800
C                                                                       00197900
      GO TO 4500                                                        00198000
C                                                                       00198100
C     COMPUTE LOWCUT FILTER                                             00198200
C                                                                       00198300
 3100 IF (ITYPE.NE.1) GO TO 3300                                        00198400
      ICEN = N / 2 + 1                                                  00198500
      CALL ORMSBY (N,F1,F2,ISI,FILTR,IERR)                              00198600
C                                                                       00198700
      DO 3200 I=1,N1                                                    00198800
         FILTR(I) = -FILTR(I)                                           00198900
 3200 CONTINUE                                                          00199000
C                                                                       00199100
      FILTR(ICEN) = FILTR(ICEN) + 1.                                    00199200
      GO TO 4500                                                        00199300
C                                                                       00199400
C         COMPUTE HIGHCUT FILTER                                        00199500
C                                                                       00199600
 3300 IF (ITYPE.NE.2) GO TO 3400                                        00199700
      CALL ORMSBY (N,F3,F4,ISI,FILTR,IERR)                              00199800
C                                                                       00199900
      GO TO 4500                                                        00200000
C                                                                       00200100
C         COMPUTE STACKED FILTER                                        00200200
C                                                                       00200300
 3400 LC = N                                                            00200400
      LCEN = N / 2 + 1                                                  00200500
      IF (IF1.EQ.0.AND.IF2.EQ.0) GO TO 3600                             00200600
      CALL ORMSBY (N,F1,F2,ISI,FILTR,IERR)                              00200700
C                                                                       00200800
      DO 3500 I=1,N1                                                    00200900
         WORK(I) = FILTR(I)                                             00201000
 3500 CONTINUE                                                          00201100
C                                                                       00201200
      GO TO 3800                                                        00201300
C                                                                       00201400
 3600 DO 3700 I=1,N1                                                    00201500
         WORK(I) = 0.0                                                  00201600
 3700 CONTINUE                                                          00201700
C                                                                       00201800
 3800 CALL ORMSBY (N,F3,F4,ISI,FILTR,IERR)                              00201900
C                                                                       00202000
      DO 3900 I=1,N1                                                    00202100
         WORK(I) = FILTR(I) - WORK(I)                                   00202200
 3900 CONTINUE                                                          00202300
C                                                                       00202400
      CALL ORMSBY (N,F5,F6,ISI,FILTR,IERR)                              00202500
C                                                                       00202600
      DO 4000 I=1,N1                                                    00202700
         WORK(I) = WORK(I) - FILTR(I)                                   00202800
 4000 CONTINUE                                                          00202900
C                                                                       00203000
      IF (F8.EQ.FMAX.AND.F7.EQ.FMAX) GO TO 4100                         00203100
      CALL ORMSBY (N,F7,F8,ISI,FILTR,IERR)                              00203200
      GO TO 4300                                                        00203300
C                                                                       00203400
 4100 DO 4200 I=1,N1                                                    00203500
         FILTR(I) = 0.0                                                 00203600
 4200 CONTINUE                                                          00203700
C                                                                       00203800
      FILTR(LCEN) = 1.                                                  00203900
C                                                                       00204000
 4300 DO 4400 I=1,N1                                                    00204100
         FILTR(I) = FILTR(I) + WORK(I)                                  00204200
 4400 CONTINUE                                                          00204300
C                                                                       00204400
C         SMOOTH THE OPERATOR WITH ROSS SMOOTHING                       00204500
C                                                                       00204600
 4500 LCENTR = 0                                                        00204700
      IOPT = 5                                                          00204800
      CALL ROSSW (FILTR,N,EXP,IOPT,LCENTR,IERR)                         00204900
      LF = N                                                            00205000
      IF (INVERT.EQ.0) GO TO 4700                                       00205100
C                                                                       00205200
      DO 4600 I=1,N                                                     00205300
         FILTR(I) = -FILTR(I)                                           00205400
 4600 CONTINUE                                                          00205500
C                                                                       00205600
 4700 RETURN                                                            00205700
C                                                                       00205800
 4800 CONTINUE                                                          00205900
      IERR = 1                                                          00206000
      GO TO 5000                                                        00206100
C                                                                       00206200
 4900 IERR = 2                                                          00206300
 5000 CONTINUE                                                          00206400
      RETURN                                                            00206500
      END                                                               00206600
