C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE PANLWR (INI, NTR, INTR, N, lua, LOUT, IDWR, ITOTAL,    00145300
     *                   IFOR3, IPR, MYDFLG, IDSUM)                     00145400
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <save_defs.h>
C                                                                       00145500
      REAL      OUTPUT(6065),SCL(40)                                    00145600
      REAL      DISKAC(65), OUTBUF(6000)
      REAL      N1
      INTEGER*4 CFREQ                                                   00145900
      INTEGER*2 I2OUT(6128)                                             00146000
	integer*2 icfreq,iri,itr,istat
	integer savelu,index,status,format,length,kindex
	parameter (kindex=SZTRHD/SZHFWD + 1)
      COMMON    /OUT/  OUTPUT                                           00146100
      COMMON    /FREQ/ IPDR,CFREQ(4,39)                                 00146200
c/c   EQUIVALENCE (DISKAC(51), OUTBUF(1)), (OUTPUT(51), OUTBUF(1)),     00146300
c/c  *             (OUTPUT(1), I2OUT(1))                                00146400
	equivalence (output(1),i2out(1),diskac(1))
	equivalence (i2out(kindex),outbuf(1))
      DATA IFS/0/                                                       00146500
C                                                                       00146600
	status = savelu('TVPT03',format,index,length,TRACEHEADER)
        status = savelu('RecNum',format,l_RecNum,length,TRACEHEADER)
        status = savelu('TrcNum',format,l_TrcNum,length,TRACEHEADER)
        status = savelu('LRcCDP',format,l_LRcCDP,length,TRACEHEADER)
        status = savelu('TVPT01',format,l_TVPT01,length,TRACEHEADER)
        status = savelu('TVPV01',format,l_TVPV01,length,TRACEHEADER)
        status = savelu('TVPT02',format,l_TVPT02,length,TRACEHEADER)
        status = savelu('TVPV02',format,l_TVPV02,length,TRACEHEADER)
        status = savelu('StaCor',format,l_StaCor,length,TRACEHEADER)

c/c   I256 = INI * (IFOR3 + 1) + 256                                    00146700
	i256 = ini*SZSMPD + SZTRHD
      IRI = 0                                                           00146800
      ITR = 0                                                           00146900
      N2 = 2 * N                                                        00147000
      N1 = N +1                                                         00147100
C                                                                       00147200
C --- FILL FREQUENCY ARRAY WITH CORNER FREQUENCIES FOR SUMMED TRACES    00147300
C                                                                       00147400
      IPOS = 1                                                          00147500
      INC  = 1                                                          00147600
      IF ( IDSUM .EQ. 1 ) THEN                                          00147700
         IPOS = N                                                       00147800
         INC  = -1                                                      00147900
      END IF                                                            00148000
C                                                                       00148100
      CFREQ(1,N+1) = MIN0 ( CFREQ(1,IPOS), CFREQ(1,IPOS+INC) )          00148200
      CFREQ(2,N+1) = MIN0 ( CFREQ(2,IPOS), CFREQ(2,IPOS+INC) )          00148300
      CFREQ(3,N+1) = MAX0 ( CFREQ(3,IPOS), CFREQ(3,IPOS+INC) )          00148400
      CFREQ(4,N+1) = MAX0 ( CFREQ(4,IPOS), CFREQ(4,IPOS+INC) )          00148500
      IPOS = IPOS + INC                                                 00148600
C                                                                       00148700
      ILAST = N - 1                                                     00148800
      DO 5 IX = 2, ILAST                                                00148900
         IPOS = IPOS + INC                                              00149000
         CFREQ(1,N+IX) = MIN0 ( CFREQ(1,N+IX-1), CFREQ(1,IPOS) )        00149100
         CFREQ(2,N+IX) = MIN0 ( CFREQ(2,N+IX-1), CFREQ(2,IPOS) )        00149200
         CFREQ(3,N+IX) = MAX0 ( CFREQ(3,N+IX-1), CFREQ(3,IPOS) )        00149300
         CFREQ(4,N+IX) = MAX0 ( CFREQ(4,N+IX-1), CFREQ(4,IPOS) )        00149400
    5 CONTINUE                                                          00149500
C                                                                       00149600
C-----COMPUTE SCALARS                                                   00149700
C                                                                       00149800
      IF(IFS.EQ.1) GO TO 50                                             00149900
C                                                                       00150000
C --- COMPUTE FOR DAFD                                                  00150100
      DO 10 I=1,N2,2                                                    00150200
10    SCL(I) = FLOAT(N)                                                 00150300
      FN = SCL(1)                                                       00150400
      J = 2                                                             00150500
      DO 20 I=1,N                                                       00150600
      SCL(J) = FN/FLOAT(I)                                              00150700
20    J = J + 2                                                         00150800
      IF(MYDFLG.EQ.0)GO TO 40                                           00150900
C                                                                       00151000
C --- COMPUTE FOR MYDS                                                  00151100
      DO 30 I=1,N2                                                      00151200
30       SCL(I) = SCL(I)/FN                                             00151300
40    IFS=1                                                             00151400
50    CONTINUE                                                          00151500
C                                                                       00151600
      SCL(1)=1.0                                                        00151700
      DO 640 J = 1, N2                                                  00151800
C                                                                       00151900
         ITOTAL = J - N2                                                00152000
         IF (J .GT. 3) ITOTAL = ITOTAL + J - 3                          00152100
         IF (J .GT. N + 1) ITOTAL = (J - N) * 2 - N2                    00152200
         IRI = IRI + 1                                                  00152300
C                                                                       00152400
C ---    GET INDEX OF SCALE FACTOR.                                     00152500
         AAA = SCL(ITOTAL + N2)                                         00152600
C                                                                       00152700
         DO 640 I = 1, INTR                                             00152800
            ITOTAL = ITOTAL + N2                                        00152900
C                                                                       00153000
C --- NUMBER THE OUTPUT TRACES SEQUENTIALLY SUCH THAT EACH RECORD       00153100
C --- IN THE PANEL OUTPUT CONTAINS INTR TRACES.                         00153200
C --- ENDREC IS NO LONGER NECESSARY AS RECORDS WILL NOT NEED TO BE      00153300
C --- PADDED.                                                           00153400
C                                                                       00153500
            ITR = I                                                     00153600
C                                                                       00153700
C --- CALL FILEAC IN PLACE OF DAREAD                                    00153800
C --- FILEAC ALLOWS A RECORD TO TAKE UP MORE THAN 1 TRACK               00153900
C --- IFLG = 2 SIGNIFIES A READ FROM DISK                               00154000
C                                                                       00154100
c/620       IFLG = 2                                                    00154200
c/c         CALL FILEAC (lua, DISKAC, ITOTAL, IFLG)                     00154300
c/c         I2OUT(106) = IRI                                            00154400
c/c         I2OUT(107) = ITR                                            00154500
  620	read(lua) diskac
ccc	call savew(i2out,'RecNum',iri,1)
ccc	call savew(i2out,'TrcNum',itr,1)
	i2out(l_RecNum) = iri
	i2out(l_TrcNum) = itr
C                                                                       00154600
C --- SET TRACE HEADER HALFWORD 95 TO 0 FOR ALL TRACES                  00154700
C                                                                       00154800
c/c         I2OUT(95) = 0                                               00154900
ccc	call savew(i2out,'LRcCDP',0,1)
	i2out(l_LRcCDP) = 0
C                                                                       00155000
C --- PLACE THE CORNER FREQUENCIES INTO TRACE HEADER HALFWORDS 51, 52,  00155100
C --- 53, AND 54 AND SET TRACE HEADER HALFWORD 95 TO THE CURRENT RI     00155200
C --- NUMBER, WHEN WE HAVE TRACE 1 OF ALL RECORDS AFTER RECORD 1.       00155300
C                                                                       00155400
            IF ( J .GT. 1 .AND. I .EQ. 1 ) THEN                         00155500
               IF ( IDSUM .EQ. 1 .AND. J .LE. N+1 ) THEN                00155600
c/c               I2OUT(51) = CFREQ(1,N-J+2)                            00155700
c/c               I2OUT(52) = CFREQ(3,N-J+2)                            00155800
c/c               I2OUT(53) = CFREQ(2,N-J+2)                            00155900
c/c               I2OUT(54) = CFREQ(4,N-J+2)                            00156000
		icfreq = cfreq(1,n-j+2)
ccc		call savew(i2out,'TVPT01',icfreq,1)
		i2out(l_TVPT01) = icfreq
		icfreq = cfreq(2,n-j+2)
ccc		call savew(i2out,'TVPV01',icfreq,1)
		i2out(l_TVPV01) = icfreq
		icfreq = cfreq(3,n-j+2)
ccc		call savew(i2out,'TVPT02',icfreq,1)
		i2out(l_TVPT02) = icfreq
		icfreq = cfreq(4,n-j+2)
ccc		call savew(i2out,'TVPV02',icfreq,1)
		i2out(l_TVPV02) = icfreq
               ELSE                                                     00156100
c/c               I2OUT(51) = CFREQ(1,J-1)                              00156200
c/c               I2OUT(52) = CFREQ(3,J-1)                              00156300
c/c               I2OUT(53) = CFREQ(2,J-1)                              00156400
c/c               I2OUT(54) = CFREQ(4,J-1)                              00156500
		icfreq = cfreq(1,j-1)
ccc		call savew(i2out,'TVPT01',icfreq,1)
		i2out(l_TVPT01) = icfreq
		icfreq = cfreq(2,j-1)
ccc		call savew(i2out,'TVPV01',icfreq,1)
		i2out(l_TVPV01) = icfreq
		icfreq = cfreq(3,j-1)
ccc		call savew(i2out,'TVPT02',icfreq,1)
		i2out(l_TVPT02) = icfreq
		icfreq = cfreq(4,j-1)
ccc		call savew(i2out,'TVPV02',icfreq,1)
		i2out(l_TVPV02) = icfreq
               END IF                                                   00156600
		call move (0,i2out(index),0,38*SZHFWD)
c/c            CALL MOVE (0, I2OUT(55), 0, 76)                          00156700
c/c            I2OUT(95) = I2OUT(106)                                   00156800
ccc	call savew(i2out,'LRcCDP',iri,1)
		i2out(l_LRcCDP) = iri
            END IF                                                      00156900
C                                                                       00157000
C --- SET TRACE HEADER HALFWORD 95 TO 32767 WHEN WE HAVE TRACE 2 OF ALL 00157100
C --- RECORDS AFTER RECORD 1.  THIS WILL KEEP THE PLOTTING SOFTWARE FROM00157200
C --- LABELLING MULTIPLE TRACES WITHIN A RECORD.                        00157300
C                                                                       00157400
            IF ( J .GT. 1 .AND. I .EQ. 2 ) 
     *		i2out(l_LRcCDP) = 32767
ccc  *		call savew(i2out,'LRcCDP',32767,1)
c/c         IF ( J .GT. 1 .AND. I .EQ. 2 ) I2OUT(95) = 32767            00157500
C                                                                       00157600
            I1 = INI + 14                                               00157700
ccc	call saver(i2out,'StaCor',istat,1)
		istat = i2out(l_StaCor)
            IF (istat .EQ. 30000) GO TO 635
c/c         IF (I2OUT(125) .EQ. 30000) GO TO 635                        00157800
            IF(AAA.EQ.1.)GO TO 635                                      00157900
c/c         DO 630 K = 15, I1                                           00158000
c/630       OUTBUF(K) = OUTBUF(K) * AAA                                 00158100
	call vsmul(outbuf,1,aaa,outbuf,1,ini)
  635       CONTINUE                                                    00158200
            ITT = 0                                                     00158300
c/c         IF (IFOR3 .EQ. 1) CALL FPTOI (I2OUT(129),OUTBUF(15),INI,ITT)00158400
            IF (ITT .GT. 0)                                             00158500
     *          WRITE (IPR, 565) ITT                                    00158600
  565       FORMAT(/, 1X, '** M0252 ** WARNING FROM SUBROUTINE PANLWR', 00158700
     *               13X, I6, ' TRACE DATA VALUES WERE CLIPPED WHILE ', 00158800
     *                    'CONVERTING TO I*2 DATA.', / )                00158900
  640 CALL WRTAPE (LOUT, OUTPUT, I256)
c/640 CALL WREC (LOUT, OUTPUT, I256)                                    00159000
C                                                                       00159100
C --- CALL FILEAC IN PLACE OF DACLOS                                    00159200
C --- IFLG = 3 SIGNIFIES CLOSING THE DISK DATA SET                      00159300
C                                                                       00159400
c/c   IFLG = 3                                                          00159500
c/c   CALL FILEAC (lua, DISKAC, ITOTAL, IFLG)                           00159600
	close(lua)
      CALL LBCLOS(LOUT)                                                 00159700
      IDWR = 1                                                          00159800
      ITOTAL = 0                                                        00159900
      RETURN                                                            00160000
      END                                                               00160100
