C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln(ntap,otap,vtap,ns,ne,irs,ire,vrs,vre,stat,
     1     remove,reverse,top,bot,nn,verbos)
      
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     vtap  - C*100  velocity file name
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c     vrs   - I      start velocity record
c     vre   - I      end velocity record
c    stat   - L      normalize stacked trace by # live traces
c  remove   - L      remove normal moveout
c  reverse  - L      read velocity/dips in reverse order
c     top   - L      use top nmo map
c     bot   - L      use bot nmo map
c      nn   - I      output xgraph data for trace nn
c    verbos - L      verbose output or not

      integer     ns,ne,irs,ire,vrs,vre,argis,nn
      character   ntap*(*),otap*(*),vtap*(*)
      logical     stat,remove,reverse,verbos,top,bot
      
      call argstr ('-N', ntap, ' ', ' ' )

      call argstr ('-O', otap, ' ', ' ' )
      call argstr ('-v',vtap, ' ', ' ')
      
      call argi4  ('-ns',ns,0,0)
      call argi4  ('-ne',ne,0,0)
      call argi4  ('-rs',irs,0,0)
      call argi4  ('-re',ire,0,0)
      call argi4  ('-sv',vrs,1,1)
      call argi4  ('-ev',vre,0,0)

      top = ( argis ('-T') .gt. 0 )
      bot    = ( argis ('-E') .gt. 0 )
      stat = ( argis ('-S') .gt. 0 )
      remove = ( argis ('-R') .gt. 0 )
      reverse = ( argis ('-B') .gt. 0 )
      call argi4  ('-XY',nn,0,0)

      verbos = ( argis ('-V') .gt. 0 )

c
c ----- if remove then use bot as default -----
c

      if(remove)then

         if(.not.top.and..not.bot) bot = .true. 

      endif
      
      return
      end
