C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c subroutine spline
c
c from Numerical Recipes - Press etal - pp 88
c
      subroutine spline(x,y,n,yp1,ypn,y2)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer n
      real x(*),y(*),y2(*)
      real u(SZSMPM),yp1,ypn
      if(yp1.gt.0.99e+30)then
        y2(1) = 0.
        u(1) = 0.
      else
        y2(1)=-0.5
        u(1)=(3./(x(2)-x(1)))*((y(2)-y(1))/(x(2)-X(1))-yp1)
      endif

      do 11 k= 2,n-1
	sig=(x(k)-x(k-1))/(x(k+1)-x(k-1))
	p=sig*y2(k-1)+2.
	y2(k)=(sig-1.)/p
c ----- debug -----
c       rdenom1 = (x(k+1)-x(k))-(y(k)-y(k-1))
c       rdenom2 = (x(k)-x(k-1))
c       rdenom3 = (x(k+1)-x(k-1))-sig*u(k-1)
c       u(k)=(6.*((y(k+1)-y(k))/rdenom1/rdenom2)/rdenom3)/p
c ----- ----- -----
 	u(k)=(6.*((y(k+1)-y(k))/(x(k+1)-x(k))-(y(k)-y(k-1))
     1	     /(x(k)-x(k-1)))/(x(k+1)-x(k-1))-sig*u(k-1))/p
11    continue
      if(ypn.gt.0.99e+30)then
	qn=0.
	un=0.
      else
	qn=0.5
	un=(3./(x(n)-x(n-1)))*(ypn-(y(n)-y(n-1))/(x(n)-x(n-1)))
      endif

      y2(n)=(un-qn*u(n-1))/(qn*y2(n-1)+1.)
      do 12 k=n-1,1,-1
	y2(k)=y2(k)*y2(k+1)+u(k)
12    continue
      return
      end
