C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     Program module notch.
C     May 5, 1992     d. bjerstedt
C     Copied from analvar/phaseit/faze.cf May 5/91 d. bjerstedt
c
c     Changes:
c
c     Aug / 98 - added limiting by trace distance - Garossino
c     Aug / 98 - added verbal subroutine - Garossino
C
C**********************************************************************C
C
C From USP manual by Don Wagoner, 10-31-90, pages 1 and 2.
C SZDTHD bytes in trace header on disk   (256)
C SZTRHD bytes in trace header in pipes  (256)
C LNTRHD samples in trace header         (128)
C SZSAMP bytes in floating pt sample     ( SUN 4 )
C SZSMPM max number of trace samples     (8000)
C SZLNHD line file size = (SZTRHD + SZSAMP*MAXSMP)/2   (8320)
C SZSMPD bytes per sample in pipe             ( SUN 4 )
C HSTOFF count of byte at which hlh starts    (1004)
C SZHFWD bytes in 1/2 word                    ( SUN 2 )
C
C Program notch filters traces at specified frequency ( and n harmonics
C  if desired ) with notch of specified width.
C
C**********************************************************************C
C
C     Declare variables
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      INTEGER     itr ( SZLNHD )
      INTEGER     luin, luout
      INTEGER     argis

      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn
 
      REAL        tri ( 2*SZSMPM )
      REAL        trs ( 2*SZSMPM )
      real        fn, wn, min_dist, max_dist, fnyq
 
      CHARACTER   NAME * 5,  ntap * 256,  otap * 256
      LOGICAL     verbos
 
      DATA NAME / 'NOTCH' /
 
#include <f77/open.h>
 
 
C**********************************************************************C
C     Get online help if necessary
C**********************************************************************C
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
         call help()
         stop
      endif
 
C**********************************************************************C
C     Read command line parameters
C**********************************************************************C
      call cmdln( ntap,otap,fn,wn,iharm,ifts,ifte,
     :     ifrs,ifre,min_dist, max_dist, ipow,verbos ) 
  
      fipow = abs(float(ipow))
      freq  = abs(fn)
      width = abs(wn)
      if(width.eq.0.0) width=3.0

C**********************************************************************C
C     Read and update line header,
C     Write line header, save key parameters.
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)
 
      lbytes = 0
      CALL RTAPE ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'notch: zero bytes found in header on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt( itr , lbytes, NAME, 5, LERR)
 
c Start of file usually included in f77/saveh.h
      call saver(itr, 'NumSmp', nsamp , LINHED)
      call saver(itr, 'SmpInt', nsi   , LINHED)
      call saver(itr, 'NumTrc', ntrc  , LINHED)
      call saver(itr, 'NumRec', nrec  , LINHED)
      call saver(itr, 'GrpInt', dx    , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
 
 
      if(nsi.le.0) then
         write(LERR,*) ' Sample interval zero. Changed to 1.'
         write(LERR,*) 'WARNING'
         write(LERR,*) ' '
         write(LER,*) ' '
         write(LER,*) 'NOTCH:'
         write(LER,*) '  Sample interval zero. Changed to 1.'
         write(LER,*) 'WARNING'
         write(LER,*) ' '
         nsi=1
      endif

      dt = real (nsi) * unitsc
 
      fnyq = 0.5/dt
      if(freq.ge.(fnyq+width)) then
         write(LERR,*) 'fnyq = ',fnyq
         write(LERR,*) 'dt = ',dt
         write(LERR,*) 'freq = ',freq
         
         write(LERR,*) 'WARNING: Specified parameters have no effect'
         write(LERR,*) '         on live frequencies. Job aborted.'
         write(LERR,*) 'WARNING: Specified parameters have no effect'
         write(LERR,*) '         on live frequencies. Job aborted.'
         goto 999
      endif
 
      mrec = nrec
C Check for sensible input.
      if(ifrs.le.0) ifrs=1
      if(ifts.le.0) ifts=1
      if(ifre.le.0) ifre=nrec
      if(ifte.le.0) ifte=ntrc
      if(ifrs.gt.ifre) ifrs=ifre
      if(ifts.gt.ifts) ifts=ifte
 
C This (mrec) is number of record to process and output.
      call savew( itr, 'NumRec', mrec , LINHED)
      call savew( itr, 'NumTrc', ntrc , LINHED)
      call savew( itr, 'NumSmp', nsamp, LINHED)
      
C Save in line header.
C savhlh concatenates command line input into line header and returns
C  new size of line header as last argument.
      call savhlh( itr, lbytes, lbytnew )
      CALL WRTAPE ( luout, itr, lbytnew )
      nsample = nsamp
      ntrace  = ntrc
 
C Make sure number of samples (i4samp) for FFT is an even power of 2.
C FFT routines in MATH ADVANTAGE require even power of 2 for number of
C  samples. Check, change and report.
 
      ipow2 = ifix(log(float(nsample))/log(2.0))
 
C ipow2 is largest integer power of 2 such that 2**ipow2 .le. nsample.
 
      i2samp = 2**ipow2
      i4samp = i2samp
 
C i2samp is .le. nsample, so i4samp is also.
 
      if(nsamp.gt.i2samp) i4samp = 2*i2samp
 
C Makes sure whole trace is used.
 
      if(i4samp.gt.16384) i4samp = 16384

C Prevents dimensions being exceeded.
C i4samp is the integer used for number of sample for FFT routines.
C Note that it (i4samp) may be larger (or smaller) than nsample.
C  and these cases must be taken care of by zeroing some samples
C  before and after filter. See routine fnotfilt.

C Calculate number of bytes in output trace record.

      lbytout = SZTRHD + nsamp*SZSMPD

      call verbal ( ntap, otap, nrec, nsamp, ntrc, nsi, fn, wn, 
     :     ipow, iharm, fnyq, ifrs, ifre, ifts, ifte, min_dist, 
     :     max_dist, verbos )
C
C**********************************************************************C
C
C     Read trace, do filter and write to output file.
C
C**********************************************************************C
 
      DO 200 JJ = 1, nrec, 1
         if ( verbos ) write(LERR,*)' Working record: ', jj
 
         DO 198 KK = 1, ntrc, 1

            nbytes = 0
            CALL RTAPE  ( luin, itr, nbytes )
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )
 
C Apply notch filter if record,traces and distances are  ok.
 
            IF((jj.ge.ifrs).and.(jj.le.ifre)) then

               if((kk.ge.ifts).and.(kk.le.ifte)) then

                  if ( ( DstSgn .ge. nint(min_dist) ) .and. 
     :                 ( DstSgn .le. nint(max_dist) ) ) then

                     call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
                     call fnotfilt(tri,trs,freq,width,iharm,
     1                    i4samp,nsamp,fnyq,fipow)
                     call vmov ( trs, 1, itr(ITHWP1), 1, nsamp)

                  endif
               endif
            ENDIF
 
C Do trace output:
            call wrtape (luout, itr, lbytout)
 
 198     CONTINUE
         
 200  CONTINUE

      call lbclos ( luin )
      call lbclos ( luout)
      
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Normal Termination'
      write(LER,*)'notch: Normal Termination'
      
      stop
      
 999  continue
 
      call lbclos ( luin )
      call lbclos ( luout)
      
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Abnormal Termination'
      write(LER,*)'notch: Abnormal Termination'
      
      stop
      end
c-------------------------------------------
c  Online help section
c-------------------------------------------
      subroutine help
#include <f77/iounit.h>
C
         write(LER,*)
     :'***************************************************************'
         write(LER,*)' '
         write(LER,*)
     :'Program notch: Does a notch filter of a single frequency and'
         write(LER,*)
     :'               (optionally) also removes n harmonics.'
         write(LER,*)' '
         write(LER,*)
     :'***************************************************************'
         write(LER,*)' '
         write(LER,*)
     :'Run this program by typing: notch and following arguments'
         write(LER,*)' '
         write(LER,*)
     :' -N [ntap]     (no default)       : Input data file name'
         write(LER,*)
     :' -O [otap]     (default stdout)   : Output data file name'
         write(LER,*) ' '
         write(LER,*)
     :' -fn [ifn]     (default 60) : Notch frequency Hz.'
         write(LER,*)
     :' -wn [iwn]     (default  3) : Notch half-width Hz.'
         write(LER,*)
     :' -P [ipow]     (default  1) : Notch powering factor.'
         write(LER,*)
     :' -harm [iharm] (default  0) : Number of harmonics to remove.'
         write(LER,*)
     :' -rfs [ifrs] (default  1)   : First record to apply filter to.'
         write(LER,*)
     :' -rfe [ifre] (default last) : Last record to apply filter to.'
         write(LER,*)
     :' -tfs [ifts] (default  1)   : First trace to apply filter to.'
         write(LER,*)
     :' -tfe [ifte] (default last) : Last trace to apply filter to.'
         write(LER,*)
     :' -xmin [dst] (default -9999999.0) : minimum distance to apply fil
     :ter to.'
         write(LER,*)
     :' -xmax [dst] (default 9999999.0) : maximum distance to apply fil
     :ter to.'
         write(LER,*)
         write(LER,*)
     :'Usage: notch -N[ntap] -O[otap] -fn[frequency] -wn[half-width]'
         write(LER,*)
     :'            -harm[number-harmonics-to-remove] -P[power] -V'
         write(LER,*)
     :'            -rfs[start-filter-record] -rfe[end-filter-record]'
         write(LER,*)
     :'            -tfs[start-filter-trace]  -tfe[end-filter-trace]'
         write(LER,*)
         write(LER,*)
     :'NOTE: Units for frequency and notch half-width are Hz.'
         write(LER,*)
     :'      Records and traces not filtered are passed unaltered.'
         write(LER,*)
         write(LER,*)
     :'***************************************************************'
C
      return
      end
c-----
c     Get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ifrs  - I      first record to apply notch filter to
c     ifrl  - I      last  record to apply notch filter to
c     ifts  - I      first trace to apply notch filter to
c     iftl  - I      last  trace to apply notch filter to
c     ifn   - I      notch frequency in Hz
c     iwn   - I      notch width (single side) in Hz
c     iharm - I      number of harmonics to remove
c     ipow  - I      notch power factor
c    verbos - L      verbose output or not
c-----
      subroutine cmdln( ntap,otap,fn,wn,iharm,ifts,ifte,
     :     ifrs,ifre,min_dist, max_dist, ipow, verbos )
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     argis, iharm
      real        fn, wn, min_dist, max_dist
      integer     ifrs, ifre, ifts, ifte, ipow
      logical     verbos
C
         call argr4  ( '-fn', fn,     60., 60. )
         call argi4  ( '-harm', iharm,  0,  0 )
         call argstr ( '-N', ntap, ' ', ' ' )
         call argstr ( '-O', otap, ' ', ' ' )
         call argi4  ( '-pw',   ipow,    1, 1 )
         call argi4  ( '-rfs', ifrs,    1, 1 )
         call argi4  ( '-rfe', ifre,    0, 0 )
C Note default ifre = 0 must be changed in program to last record
         call argi4  ( '-tfs', ifts,    1, 1 )
         call argi4  ( '-tfe', ifte,    0, 0 )
C Note default ifte = 0 must be changed in program to last trace
         call argr4  ( '-wn', wn,      3.,  3. )
         call argr4  ( '-xmin', min_dist,  -9999999.0, -9999999.0 )
         call argr4  ( '-xmax', max_dist,  9999999.0, 9999999.0 )
         verbos = ( argis ( '-V' ) .gt. 0 )
C
      return
      end

C Subroutine fnotfilt
C *******************************************************************
C ***** Routine notch filters trace.                            *****
C ***** d. bjerstedt may 6 1992.                                *****
C *******************************************************************
      subroutine fnotfilt(trin,trout,freq,width,iharm,np2samp
     :,isaact, fnyq, fipow )
 
#include <f77/lhdrsz.h>
 
      REAL      trin(*),trout(*)
      dimension ca(2*SZSMPM)
 
C np2samp is number of samples (exact integer power of 2 ).
C isaact is actual number of samples in original trace.
C
C Initial values of samples beyond existing input data must be zeroed.
 
      if(np2samp.gt.isaact) then
         do 641 js=isaact+1,np2samp,1
         trin(js)=0.0
  641    continue
      endif
C
c Call fft routine, scale and unpack and extract real and imag parts.
c ***** WARNING ***** mpow must be an integer power of 2 for fft.
C
      mpow=np2samp
c Do forward fft input trace.
      call rfftb(trin,ca,mpow,1)
C
c Scale and unpack.
      call rfftsc(ca,mpow,3,1)
      kmax=1+mpow/2
C
      do 100 ind=1,kmax,1
         find=fnyq*float(ind-1)/float(kmax-1)
C Note -1 needed as freq runs from 0 to fnyq but index from 1 to kmax
C
         indc=ind*2
C
         factor=1.0
         itharm=iharm+1
C
C Calculate total notch factor from freq and all harmonics.
         do 125 kharm=1,itharm,1
            thisf=freq*float(kharm)
            diff=abs(find-thisf)
            if(diff.lt.width) then
                factor=factor*(diff/width)**fipow
            endif
C Note that notches may overlap and produce more than linear reduction.
  125    continue
C
C Change amplitude without changing phase.
         ca(indc-1)=ca(indc-1)*factor
         ca(indc)=ca(indc)*factor
  100 continue
C
c Create time domain filtered trace.
      call rfftb(ca,trout,mpow,-1)
C
C Restore zero pads if necessary.
C
      if(np2samp.gt.isaact) then
         do 741 js=isaact+1,np2samp,1
            trout(js)=0.0
  741    continue
      endif
C
      if(np2samp.lt.isaact) then
         do 841 js=np2samp+1,isaact,1
            trout(js)=0.0
  841    continue
      endif
C
      return
      end

      subroutine verbal ( ntap, otap, nrec, nsamp, ntrc, nsi, fn, wn, 
     :     ipow, iharm, fnyq, ifrs, ifre, ifts, ifte, min_dist, 
     :     max_dist, verbos )

#include <f77/iounit.h>

c printout subroutine

c declare variables passed from calling routine

      integer nrec, nsamp, ntrc, nsi, iharm
      integer ifrs, ifre, ifts, ifte

      real fn, wn, fnyq, min_dist, max_dist

      character ntap*(*), otap*(*)
      
      logical verbos

c declare local variables

      integer length

      write(LERR,*)' '
      write(LERR,*)' Command Line Input'
      write(LERR,*)' ------------------'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*)' Input Dataset: ',ntap(1:length)
      else
        write(LERR,*)' Input Dataset: stdin'
      endif
      write(LERR,*)' '
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*)' Output Dataset: ',otap(1:length)
      else
        write(LERR,*)' Output Dataset: stdout'
      endif
      write(LERR,*)' '
      write(LERR,*)' Notch Frequency: ', fn
      write(LERR,*)' Notch Width: ', wn
      write(LERR,*)' Notch Power: ', ipow
      write(LERR,*)' Number of Harmonics requested: ', iharm
      write(LERR,*)' '
      write(LERR,*)' Start processing at record: ',ifrs
      write(LERR,*)' End processing at record: ',ifre
      write(LERR,*)' '
      write(LERR,*)' Start processing at trace: ',ifts
      write(LERR,*)' End processing at trace: ',ifte
      write(LERR,*)' '
      write(LERR,*)' Minimum offset to process: ',min_dist
      write(LERR,*)' Maximum offset to process: ',max_dist
      write(LERR,*)' '
      if (verbos)
     :     write(LERR,*)' Verbose Printout Requested'
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Input Dataset Parameters '
      write(LERR,*)' ------------------------'
      write(LERR,*)' '
      write(LERR,*)' Number of Records: ', nrec
      write(LERR,*)' Number of Traces/Record: ', ntrc
      write(LERR,*)' Number of Samples/Trace: ', nsamp
      write(LERR,*)' Sample Interval: ', nsi
      write(LERR,*)' Nyquist Frequency: ', fnyq

      return
      end
