C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c performs some arcane geophysical process
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr   ( 2*SZLNHD )
      integer     itr0   ( 2*SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     nreco
      integer     argis
 
c     real        tri ( SZLNHD )

      character   ntap * 255, otap * 255, name*6, rfile * 255

      logical     verbos, query, dead, nhon, begin

c program specific variables
      integer     RecNum, ifmt_RecNum, l_RecNum, ln_RecNum 
      integer     TrcNum, ifmt_TrcNum, l_TrcNum, ln_TrcNum 
      integer     SrcLoc, ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc 
      integer     RecInd, ifmt_RecInd, l_RecInd, ln_RecInd 
      integer     DphInd, ifmt_DphInd, l_DphInd, ln_DphInd 
      integer     DstSgn, ifmt_DstSgn, l_DstSgn, ln_DstSgn 
      integer     StaCor, ifmt_StaCor, l_StaCor, ln_StaCor 
      integer     npadrec, currec, cumrec, delta_rec, start_rec, end_rec
      integer     recs (2*SZLNHD), npads (2*SZLNHD), RecNum_Check
      integer     lurfile
 
      data lbytes / 0 /
      data nbytes / 0 /
      data name/'PADREC'/
c     data itr0/SZLNHD*0/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0)
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln( ntap, otap, rfile, dead, nhon, delta_rec, 
     :     start_rec, end_rec, lurfile, begin, verbos )
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'padrec: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c set up header mnemonic pointers

      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('TVPT20',ifmt_TVPT20,l_TVPT20,ln_TVPT20,TRACEHEADER)
      call savelu('TVPT21',ifmt_TVPT21,l_TVPT21,ln_TVPT21,TRACEHEADER)

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
 
      call hlhprt (itr, lbytes, name, 6, LERR)

      IF ( rfile .ne. ' ' ) then

c-----
c     read file of rec #'s and 3 pads
c-----

         npadrec = 0
         do  j = 1, 2*SZLNHD
            read (lurfile, *, end=1) recs (j), npads (j)
            if (npads (j) .eq. 0) npads (j) = 1
            nlines  = j
            npadrec = npadrec + npads (j)
         enddo
 1       continue
c-----
c     modify line header to reflect actual number of traces output
c-----
         nreco = nrec + npadrec
         call savew(itr, 'NumRec', nreco, LINHED)

      ELSE

c assign output line header values from input command line.  In
c this case the user wants automatic record padding and has put
c enough information on the command line to fill out the line header
         
         nreco =  (iabs( end_rec - start_rec ) + 1) / iabs(delta_rec)
         call savew(itr, 'NumRec', nreco, LINHED)
        
      ENDIF
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into historical LH:
 
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout  )
 
      call verbal( nsamp, nsi, ntrc, nrec, iform, rfile, dead, ntap, 
     :     otap , nreco, start_rec, end_rec, delta_rec)
 
c-----
c     PROCESSING USING RFILE
c-----

      IF ( rfile .ne. ' ' ) then

         line = 1
         cumrec = 0
         DO 1000 jj = 1, nrec
  
            cumrec = cumrec + 1
            do 1001  kk = 1, ntrc
 
               nbytes = 0
               call rtape( luin, itr, nbytes)
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
 
c------
c     use previously derived pointers to trace header values
c------

               call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1              RecNum , TRACEHEADER)
               call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1              TrcNum , TRACEHEADER)
               call saver2(itr,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1              SrcLoc , TRACEHEADER)
               call saver2(itr,ifmt_RecInd,l_RecInd, ln_RecInd,
     1              RecInd , TRACEHEADER)
               call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1              DphInd , TRACEHEADER)
               call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1              DstSgn , TRACEHEADER)
               call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1              StaCor , TRACEHEADER)

               if ( nhon .AND. StaCor .ne. 30000) then
                  currec = RecNum
               elseif ( .not. nhon ) then
                  currec = RecNum
               endif

               IF (begin .AND. currec .eq. recs (line) .AND.
     1             kk .eq. 1) THEN

                  npad = npads (line)
                  write(LERR,*)'Padding ',npad,
     1                 ' records before record ',currec
 
                  if (npad .ne. 0) then
                     DO  j = 1, npad
 
                        do  k = 1, ntrc
                           call savew2(itr0,ifmt_TrcNum,l_TrcNum,
     1                          ln_TrcNum,   k    , TRACEHEADER)
                           call savew2(itr0,ifmt_RecNum,l_RecNum,
     1                          ln_RecNum, cumrec , TRACEHEADER)
                           if (dead)
     1                          call savew2(itr0,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000  , TRACEHEADER)
                           call wrtape (luout, itr0, obytes)
                        enddo
                        cumrec = cumrec + 1
                     ENDDO
                  endif
 
                  line = line + 1
                  begin = .false.

               ENDIF
               
               call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1              cumrec , TRACEHEADER)
               call wrtape (luout, itr, obytes)

               
               IF (currec .eq. recs (line) .AND.
     1              kk .eq. ntrc .AND. .not.begin) THEN
                  
                  npad = npads (line)
                  write(LERR,*)'Padding ',npad,
     1                 ' records after record ',currec
                  
                  if (npad .ne. 0) then
                     DO  j = 1, npad
                        
                        cumrec = cumrec + 1            
                        do  k = 1, ntrc
                           call savew2(itr0,ifmt_TrcNum,l_TrcNum,
     1                          ln_TrcNum,   k    , TRACEHEADER)
                           call savew2(itr0,ifmt_RecNum,l_RecNum,
     1                          ln_RecNum, cumrec , TRACEHEADER)
                           if (dead)
     1                          call savew2(itr0,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000  , TRACEHEADER)
                           call wrtape (luout, itr0, obytes)
                        enddo
                     ENDDO
                  endif

                  line = line + 1
               ENDIF
c------
 
 1001       continue
 1000    CONTINUE

      ELSE

c pad missing records automatically, missing traces NOT allowed.  These can
c and should have already been taken care of using the bridge

         RecNum_Check = start_rec

         DO JJ = 1, nreco

            DO KK = 1, ntrc

               nbytes = 0
               call rtape( luin, itr, nbytes)
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  write(LERR,*)'  Now padding to end'
                  go to 900
               endif
               
               call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     :              RecNum , TRACEHEADER)

               if ( RecNum .ne. RecNum_Check ) then
                  
c pad records to fill in the gap using itr0

                  DO  j = RecNum_Check, RecNum - delta_rec, delta_rec

                     do  k = 1, ntrc
                        call savew2(itr0,ifmt_TrcNum,l_TrcNum,
     :                       ln_TrcNum,   k    , TRACEHEADER)
                        call savew2(itr0,ifmt_RecNum,l_RecNum,
     :                       ln_RecNum, j , TRACEHEADER)
                        if (dead)
     :                       call savew2(itr0,ifmt_StaCor,l_StaCor,
     :                       ln_StaCor, 30000  , TRACEHEADER)
                        call wrtape (luout, itr0, obytes)
                     enddo
                  ENDDO

               endif
               
c reset the record number check

               RecNum_Check = RecNum

c write out the current record in it's correct location
               
               call wrtape (luout, itr, obytes)
              
            ENDDO
            
            RecNum_Check = RecNum + delta_rec

         ENDDO

      ENDIF

c normal termination

      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'processed',nreco,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'padrec: Normal Termination'
      stop 

 900  continue

c pad the remaining records out to total number requested by the user

      DO j = RecNum_Check, end_rec, delta_rec
         DO k = 1, ntrc
             
            call savew2(itr0,ifmt_TrcNum,l_TrcNum,
     :           ln_TrcNum,   k    , TRACEHEADER)
            call savew2(itr0,ifmt_RecNum,l_RecNum,
     :           ln_RecNum, j , TRACEHEADER)
            if (dead)
     :           call savew2(itr0,ifmt_StaCor,l_StaCor,
     :           ln_StaCor, 30000  , TRACEHEADER)
            call wrtape (luout, itr0, obytes)
            
         ENDDO
      ENDDO

c normal termination

      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'processed',nreco,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'padrec: Normal Termination'
      stop 
 
  999 continue
 
c Abnormal Termination

      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'end of padrec, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'padrec: Abnormal Termination'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'padrec pads in zero recs from a file'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute padrec by typing padrec and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)  : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)  : output data file name'
        write(LER,*) ' '
        write(LER,*)
     :' -F [file]    (no default)  : file of rec # & # repeats'
        write(LER,*) ' '
        write(LER,*)
     :' -D  include on command line mark padded records as dead'
        write(LER,*)
     :' -I  include on command line to ignore input recs already dead'
        write(LER,*) ' '
        write(LER,*)
     :' -B  include on command line if first RecNum in file is first'
        write(LER,*)
     :'     in data set and you wish to pad before first record'
        write(LER,*)
     :' -rs  (0)                   : RecNum of first output record'
        write(LER,*)
     :' -re  (0)                   : RecNum of last output record'
        write(LER,*)
     :' -ri  (0)                   : RecNum increment'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   padrec -N[ntap] -O[otap] -F[file] [ -D -I -B -V]'
        write(LER,*)
     :'                 [ -rs[] -re[] -ri[] ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln( ntap, otap, rfile, dead, nhon, 
     :     delta_rec, start_rec, end_rec, lurfile, begin, verbos )
c-----
c     get command arguments
c

#include <f77/iounit.h>

      integer     delta_rec, start_rec, end_rec, argis, lurfile
      character   ntap*(*), otap*(*), rfile*(*)
      logical     verbos, dead, nhon, begin
 
      dead   =   (argis('-D') .gt. 0)
      begin  =   (argis('-B') .gt. 0)
      call argstr( '-F', rfile, ' ', ' ' )
      nhon   =   (argis('-I') .gt. 0)
      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-O', otap, ' ', ' ' )
      call argi4 ( '-re',end_rec, 0,0 )
      call argi4 ( '-ri',delta_rec, 1,1 )
      call argi4 ( '-rs',start_rec, 0,0 )
      verbos =   (argis('-V') .gt. 0)
      
      if (rfile(1:1) .ne. ' ') then
         call alloclun ( lurfile )
         open(unit=lurfile, file=rfile, status='old', iostat=ierr)
         if(ierr .ne. 0) then
            write(LERR,*)'Could not open record numbers file'
            write(LERR,*)'Check existence'
            stop
         endif
      else
         if ( start_rec .eq. 0 .or.
     :        end_rec .eq. 0 ) then
            write(LERR,*)'PADREC: When using this routine in'
            write(LERR,*)'        automatic mode you must supply'
            write(LERR,*)'        the number of records you want'
            write(LERR,*)'        out of this routine as well as'
            write(LERR,*)'        the starting and ending record'
            write(LERR,*)'        numbers and the record increment'
            write(LERR,*)'        [ -ntrc -rs -re -ri ] '
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'PADREC: When using this routine in'
            write(LER,*)'        automatic mode you must supply'
            write(LER,*)'        the number of records you want'
            write(LER,*)'        out of this routine as well as'
            write(LER,*)'        the starting and ending record'
            write(LER,*)'        numbers and the record increment'
            write(LER,*)'        [ -ntrc -rs -re -ri ] '
            write(LER,*)'FATAL'
            stop
         endif
      endif
      
      return
      end
 
C***********************************************************************
      subroutine verbal( nsamp, nsi, ntrc, nrec, iform, rfile, dead, 
     :     ntap, otap , nreco, start_rec, end_rec, delta_rec)

#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, nreco, iform, start_rec
      integer     end_rec, delta_rec
      character   ntap*(*), otap*(*), rfile*(*)
      logical     dead
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            if ( rfile .ne. ' ' ) then
               write(LERR,*) ' record file name   =  ',rfile
            else
               write(LERR,*)' number of records to output = ', nreco
               write(LERR,*)' start record to output      = ', start_rec
               write(LERR,*)' end record to output        = ', end_rec
               write(LERR,*)' record increment            = ', delta_rec
            endif
            
            write(LERR,*) ' mark padded recs as dead? ',dead
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
 
