C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine breakup( u, lenu2, nsamp, hbegin, lenhed, 
     :     nbytes_out, luin, luout, lerr, ifmt_StaCor, l_Stacor, 
     2     ln_StaCor, npad, ntr, ntrout, nrec_inline, ntrpline,
     3     nline)

      implicit none

c declare variables passed from calling routine

      integer   lenu2, nsamp, hbegin, lenhed, nbytes_out, luin, luout
      integer   ifmt_StaCor, l_Stacor, ln_StaCor, npad, ntr, ntrout
      integer   nrec_inline, ntrpline, nline, lerr

      real      u(hbegin:nsamp,ntrout)

c declare local variables 

      integer jrec, iline, jtrpline, itrace_sort, nbytes, irec, jtr
      integer ifirst, ilast, last_index

      logical eod, eor

c initialize variables

      eod = .false.
      eor = .false.
      jrec=0

c start processing

c the 80000 loop could go over the total number of records in the prestack case

      DO 80000 iline= 1, nline

         jtrpline=0
         itrace_sort=0
         eod=.false.
         eor = .false.

c read first trace of this record

         nbytes = 0
         call rtape(luin,u(hbegin,1),nbytes)

         if(nbytes .eq. 0) then

c There is no more data [or no data at all] so return and end

            write(LERR,*)'End of file on input:'
            write(LERR,*)'  rec= ',irec,'  trace= ',jtr
            eod=.true.
            return
         endif

c duplicate first trace to fill leftmost pad

         do jtr=2,npad 
            call vmov (u(hbegin,1),1,u(hbegin,jtr), 1, lenhed+nsamp)
         enddo

c set output data pointers

         ifirst = npad+1
         ilast = ntrout

c the 70000 loop could work for the number of traces in a record in the
c prestack case.  Here nrec_inline is the number of records to be 
c created inside each input record.  ntrout is the number of traces in 
c each segment of the new output record including both pads

         DO 70000 irec = 1, nrec_inline

            jrec = jrec + 1

c---------------------------------------------------------------------------
c       fill up the rest of the buffer with traces.
c---------------------------------------------------------------------------

            DO 20000 jtr = ifirst, ilast

               jtrpline = jtrpline + 1

               if ( jtrpline .eq. 1 ) then

c here ntrpline is the number of traces in a record coming in
c      jtrpline is the number of traces read from this input record
c if we are at the start of a record and have just added the leftmost
c pad then we still have the first trace in memory and need to add it
c as the first trace in the body of the padded output record segment
                  
                  call vmov (u(hbegin,jtr-1),1,u(hbegin,jtr), 1, 
     :                 lenhed+nsamp )

                 

               elseif ( jtrpline .gt. ntrpline ) then

                  if ( .not. eor ) last_index = jtr - 1
                  eor = .true.

c now we need to complete the last record segment by padding out with the 
c last trace of the input record

                  call vmov (u(hbegin,last_index),1,u(hbegin,jtr), 1, 
     :                 lenhed+nsamp )

               elseif ( eod ) then

c have hit the end of the input dataset prematurely which means we have to 
c pad out the rest of this record with the last trace read, whatever that was

                  call vmov (u(hbegin,last_index),1,u(hbegin,jtr), 1, 
     :                 lenhed+nsamp )

               else

c load next trace to the output record segment which off course will
c simply put in traces until the end of the segment AND the rightmost
c pad have been filled

                  nbytes = 0
                  call rtape(luin,u(hbegin,jtr),nbytes)

                  if(nbytes .eq. 0) then

c we have hit the end of the input dataset and still need to make sure
c that we have a complete padded last record coming out.  Load the 
c last trace to the rightmost pad all the way to the end.  This logic
c handles the trace when we hit  the end of data.  The if test above that
c keys on eod will fill out to the end of the record with the last trace
c from the input dataset.

                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',irec,'  trace= ',jtr
                     if ( .not. eod) last_index = jtr-1
                     call vmov (u(hbegin,last_index),1,u(hbegin,jtr), 1, 
     :                    lenhed+nsamp )
                     if ( .not. eod) last_index = jtr-1
                     eod=.true.
                  endif

               endif

20000       CONTINUE

            ifirst = 2 * npad + 1 
 
c---------------------------------------------------------------------------
c       write out padded record segment
c---------------------------------------------------------------------------

            do jtr = 1, ntrout
               call wrtape ( luout, u(hbegin,jtr), nbytes_out )
            enddo

c---------------------------------------------------------------------------
c       Now need to move the rightmost pad into the leftmost pad position
c       in preparation for the next record segment.
c---------------------------------------------------------------------------

            do jtr = ntr+1, ntrout
               call vmov(u(hbegin,jtr),1,
     1              u(hbegin,jtr-ntr),1,lenhed+nsamp)
            enddo

70000    CONTINUE

80000 CONTINUE

      return
      end

