C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************partition**************************************c
c reads input seismic multi trace records and allows the user to output.
c the data in subsets with a trace pad extracted from the input data 
c itself.  No change is made to any indexing in the original data.  
c This code is based on the rwindow routine [K. Marfurt] that allowed
c a similar activity on stacked data.  Hence the familiar mapmem stuff
c below.
c
c Garossino Sept 15, 2000
c**********************************************************************c
c
c Changes:
c
c July 17, 2001 - modified the line header reference to Nx_Trc, an I2 union
c                 set up for Kurt by Joe to DtInFl, an I4 variable.  I had to 
c                 do this as we are coming across datasets that have records
c                 with greater than 32768 traces.  This is not backwards compatible
c                 but it is very unlikely that anyone has a partitioned dataset
c                 kicking around waiting to be unpartitioned.  This gets used 
c                 in a pipeflow in pairs 99.9 percent of the time.
c Garossino
c
c     declare variables
c

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
 

      integer maxs
      parameter (maxs=0 000 002)
      real      s(maxs)
      pointer   (pntrs,s)

      integer     hbegin
      integer     sheader(SZLNHD)
      integer     argis, jerr, ntr, npad, nline, luin, luout, lbytes
      integer     nsamp, nsi, lenhed, nrec_inline, ntrpline, ntrcumpads
      integer     ntrbuf, nrecin, ntrin, ntrtotal, nrecout, lbyout
      integer     lenu2, nbytes_out, i, l_free, l_u, l_uout
      integer     lens, ierrcd
      integer     ifmt_StaCor, l_StaCor, ln_StaCor

      character  ntap*256, otap*256, name*9

      logical     verbos, restor, single_trace_rec

c initialize variables
 
      data        name/'PARTITION'/
c-----------------------------------------------------------------------
c     read program parameters from command line card image file
c----------------------------------------------------------------------- 

      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 ) then
            call help()
            stop
      endif
c-----------------------------------------------------------------------
c     open printout files
c-----------------------------------------------------------------------
#include <f77/open.h>
c-----------------------------------------------------------------------
c     parse command line
c-----------------------------------------------------------------------

      call argstr('-N',ntap, ' ', ' ')
      call argstr('-O',otap, ' ', ' ')
      call argi4('-ntr',ntr,200,200)     
      call argi4('-npad',npad,20,20)   
  
      verbos=(argis('-V') .gt. 0)
      restor=(argis('-R') .gt. 0)
c-----------------------------------------------------------------------
c     get logical unit numbers for input and output
c-----------------------------------------------------------------------
      call getln(luin ,ntap,'r',0)
      call getln(luout,otap,'w',1)
c-----------------------------------------------------------------------
c     read line header of input
c     save certain parameters
c-----------------------------------------------------------------------
      lbytes=0
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(lerr,*)'PARTITION: no header read from unit ',luin
         call exit(0)
      endif
C-----------------------------------------------------------------------
c     pull relevent values from line header.
C-----------------------------------------------------------------------
      call saver(sheader,'NumSmp',nsamp,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)

      lenhed=ITRWRD
      hbegin=1-lenhed
c
      call hlhprt(sheader,lbytes,name,9,lerr)
      if(restor) then
         call saver(sheader,'Nx_Pad',npad,LINEHEADER)
         call saver(sheader,'NxLine',nline,LINEHEADER)
         call saver(sheader,'Nx_Rec',nrec_inline,LINEHEADER)
c         call saver(sheader,'Nx_Trc',ntrpline,LINEHEADER)
         call saver(sheader,'DtInFl',ntrpline,LINEHEADER)
         call saver(sheader,'Nx_Win',ntrcumpads,LINEHEADER)
         ntr=ntrcumpads-2*npad  
         ntrbuf=ntrcumpads  
         call savew(sheader,'NumTrc',ntrpline,LINEHEADER)
         call savew(sheader,'NumRec',nline,LINEHEADER)
      else
         call saver(sheader,'NumRec',nrecin,LINEHEADER)
         call saver(sheader,'NumTrc',ntrin,LINEHEADER)
         if(npad .gt. 0) then
            npad=2*(npad/2)+1
         endif
         ntrcumpads=ntr+2*npad
         ntrbuf=ntrcumpads
         ntrtotal=nrecin*ntrin   
         if(ntrin .eq. 1) then
c-----------------------------------------------------------------------
c           single trace records (typically, 2D stacked data)
c-----------------------------------------------------------------------
            ntrpline=nrecin
            if(nline .eq. 0) nline=1   
            single_trace_rec=.true.
         else
c-----------------------------------------------------------------------
c           multi trace records (typically, 3D stacked data)
c-----------------------------------------------------------------------
            ntrpline=ntrin
            if(nline .eq. 0) nline=nrecin
            single_trace_rec=.false.
         endif
         nrec_inline=(ntrpline-1)/ntr+1
         nrecout=nrec_inline*nline
         call savew(sheader,'Nx_Pad',npad,LINEHEADER)
         call savew(sheader,'NxLine',nline,LINEHEADER)
         call savew(sheader,'Nx_Rec',nrec_inline,LINEHEADER)
c         call savew(sheader,'Nx_Trc',ntrpline,LINEHEADER)
         call savew(sheader,'DtInFl',ntrpline,LINEHEADER)
         call savew(sheader,'Nx_Win',ntrcumpads,LINEHEADER)
         call savew(sheader,'NumRec',nrecout,LINEHEADER)
         call savew(sheader,'NumTrc',ntrcumpads,LINEHEADER)
      endif
      call savhlh(sheader,lbytes,lbyout)
      call wrtape(luout,sheader,lbyout)
c
      write(lerr,*) 'restore to original number of records/traces? ',
     1               restor 
      write(lerr,'(a20,i10)') 'ntr',ntr,'npad',npad,
     1                 'nrecin',nrecin,'ntrin',ntrin,
     2                 'ntrpline',ntrpline,'nline',nline,
     3                 'nrec_inline',nrec_inline,
     4                 'ntrcumpads',ntrcumpads,
     5                 'nrecout',nrecout,'ntrbuf',ntrbuf
c-----------------------------------------------------------------------
c     calculate number of bytes in output trace
c     calculate trace header position of key variables.
c-----------------------------------------------------------------------

      lenu2=lenhed+nsamp
      nbytes_out=(nsamp+lenhed)*szsmpd

      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----------------------------------------------------------------------
c     calculate memory requirements
c-----------------------------------------------------------------------
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(a)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
c-----------------------------------------------------------------------
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('u',l_u,l_free,ntrbuf*(nsamp+lenhed),lerr)
      call mapmem('uout',l_uout,l_free,ntrbuf*(nsamp+lenhed),lerr)
C-----------------------------------------------------------------------
C     allocate dynamic memory.
C-----------------------------------------------------------------------
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)
         write(lerr,*)'program PARTITION aborted'
         write(ler,*)'galloc memory allocation error from main'
         write(ler,*)'ierrcd = ',ierrcd
         write(ler,*)
         write(ler,*)'probable cause: too much memory requested!'
         write(ler,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(ler,*)
         write(ler,*)'program PARTITION aborted'
         call exit(101)
      endif
c
      if(restor) then
c-----------------------------------------------------------------------
c        restore the records by blending and editting off the pads.
c-----------------------------------------------------------------------

         call restore(s(l_u),s(l_uout),
     2               hbegin,lenhed,nsamp,nbytes_out,
     3               luin,luout,lerr,npad,ntr,nrec_inline,
     4               lenu2,ntrpline,nline)
      else
c-----------------------------------------------------------------------
c        generate padded records.                                  
c-----------------------------------------------------------------------

         call breakup(s(l_u),lenu2,nsamp,
     1        hbegin,lenhed,nbytes_out,luin,luout,lerr,
     :        ifmt_StaCor, l_StaCor, ln_StaCor,
     2        npad,ntr,ntrcumpads,nrec_inline,ntrpline,
     3        nline)

      endif

c-----------------------------------------------------------------------
c     close data files
c-----------------------------------------------------------------------

      call lbclos ( luin )
      call lbclos ( luout )

      write(ler,*)'partition: Normal Termination'
      write(lerr,*)'Normal Termination'
      close(lerr)
      stop
      end
 
c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>


      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for partition: partition and'
      write(LER,*)'   pad [record wise] an input dataset '
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman or see the USP'
      write(LER,*)' intranet site '
      write(LER,*)' '
      write(LER,*)'Input......................................... (def)'

      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                     (stdin)'
      write(LER,*)'-O[]   -- output data set                   (stdout)'
      write(LER,*)'-ntr[] -- number of nonpadded traces in        (200)'
      write(LER,*)'          analysis partition '
      write(LER,*)'-npad[]-- number of traces to be padded         (20 '
      write(LER,*)'          to each side of the analysis  '
      write(LER,*)'          partition '
      write(LER,*)'-R     -- if present, remove pad and restore to ' 
      write(LER,*)'          unpadded state '
      write(LER,*)'-V     -- verbos printout' 
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       partition -N[] -O[] -ntr[] -npad[] [-R -V]'
      write(ler,*)
     1'***************************************************************'

      return
      end
 

