C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
C
C     PROGRAM MODULE  rotate the phase of seismic data by constant amt
C
C**********************************************************************C
C
C phzrot READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C rotates the phase of the data by a constant amount,
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( 2*SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis, ordfft
      real        degrad, radeg, thresh, rot
      REAL        xtr ( 8*SZLNHD ), work (8*SZLNHD )
      REAL        amp ( 8*SZLNHD ), phz  (8*SZLNHD )
      COMPLEX     ctr ( 4*SZLNHD )
      CHARACTER   NAME * 7,  ntap * 256, otap * 256
#include <f77/pid.h>
      logical     verbos,query,mute,first
 
      DATA     NAME /'PHZROT'/
      DATA     LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA     obytes / 0 /
      DATA     verbos /.false./, first/.true./
      DATA     radeg/57.29578/
      DATA     degrad/.017453293/


c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if( query ) then
          call help ()
          stop
      endif

c---------------------------------
c  open printout files
c---------------------------------
#include <f77/open.h>

c---------------------------------------------------------------
c  read program parameters from command line
c---------------------------------------------------------------
      call cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,verbos,
     1           rot,mute)

C**********************************************************************C
C     open logical units
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C

      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'PHZROT: no header read on unit ',luin
         write(LERR,*)'for data set name ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'check existence of this file'
         stop
      endif

#include <f77/saveh.h>
      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('VPick1',ifmt_VPick1,l_VPick1,ln_VPick1,TRACEHEADER)

      CALL HLHprt ( ITR , LBYTES, NAME, 7, LERR        )

c---------------------------------------
c  check key values for reasonableness
c---------------------------------------
      call cmdchk(nst,ned,nrst,nred,ntrc,nrec)
      if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD
      ntr=ned-nst+1
      nrecc=nred-nrst+1

C**********************************************************************C
C     CHECK CARD DEFAULTS, SET PARAMETERS, and print out values
C**********************************************************************C
      dt = float (nsi) * unitsc

      iend=iend/nsi + .5
      ist0 = ist
      ist=ist/nsi
      if(ist .le. 1) ist=1
      if(iend .eq. 0) iend=nsamp
      if(iend .gt. nsamp) iend=nsamp
      nsampo=iend-ist+1
c------------------------------
c  find power of 2, nsampo

      nu = ordfft (nsampo)
      n2 = 2 ** nu
      n22 = n2 / 2
      fnyq = .5 / dt

      df = fnyq / float(n2/2 - 1)
      ndf = 1000*df

      obytes = SZTRHD + SZSMPD * nsamp
c------------------------------

c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' Input Samples/Trace =  ', nsamp
        write(LERR,*) ' # of Samples/Trace  =  ', nsampo
        write(LERR,*) ' power of 2 samples  =  ', n2
        write(LERR,*) ' Sample Interval     =  ', nsi  
        write(LERR,*) ' Input traces/rec    =  ', ntrc
        write(LERR,*) ' Input Records/Line  =  ', nrec
        write(LERR,*) ' Records per Line    =  ', nrecc
        write(LERR,*) ' Format of Data      =  ', iform
        write(LERR,*) ' Phase rotation angle=  ', rot
        write(LERR,*) ' Output number bytes =  ', obytes
        if (mute)
     1  write(LERR,*)' Restore early mute'
c     endif

       call savhlh( itr, lbytes, lbyout)

      CALL WRTAPE ( LUOUT, ITR, LBYout )

C**********************************************************************C
C     get seismoc traces, fft, output complex data
C**********************************************************************C
c------------------------------------------
c  skip to just before desired record
c------------------------------------------
      call recskp(1,nrst-1,luin,ntrc,itr)

      DO 100 JJ = NRST, NRED

c-------------------------------
c  skip to desired trace
c-------------------------------
             call trcskp(jj,1,nst-1,luin,ntrc,itr)

             DO 99 KK = NST, NED
 
                   nbytes = 0
                   CALL RTAPE  ( LUIN , ITR, NBYTES         )
                   if(nbytes .eq. 0) then
                      write(LERR,*)'End of file on input:'
                      write(LERR,*)'  rec= ',jj,'  trace= ',kk
                      go to 999
                   endif
                   call vmov (itr(ITHWP1), 1, xtr, 1, nsamp)
                   call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                         istatic, TRACEHEADER)

                   IF (istatic .ne. 30000) THEN

                        if (mute) then
                           call detmut (xtr, imute, nsamp)
                        else
                           imute = 0
                        endif

                        call vmov   (xtr(ist),1,work,1,nsampo)
                        call vclr   (ctr, 1, n2)
                        call rfftb  (work,ctr,n2,1)
                        call rfftsc (ctr,n2,2,1)

                           call cvabs  (ctr, 2, amp,  1, n2)

                           do  i = 1, n22
                               xr = real  ( ctr (i) )
                               xi = aimag ( ctr (i) )
                               if (xr .eq. 0.) then
                                  phz (i) = 0.
                               else
                                  phzi = radeg * atan2 ( xi , xr )
                                  phzi = phzi + rot
                                  phz (i) = degrad * phzi
                               endif
                           enddo
                           call cvmexp (phz , 1, amp, 1, ctr, 2, nsamp)
                           call rfftsc (ctr, n2, -2, 0)
                           call rffti  (ctr, xtr, n2)
                           call resmut (xtr, imute, nsamp)
                           call vmov (xtr, 1, itr(ITHWP1), 1, nsamp)

                           call wrtape(luout,itr,obytes)

                   ELSE

                           call wrtape(luout,itr,obytes)

                   ENDIF


   99        CONTINUE

c--------------------------------------------------
c  skip to the end of current record: trace # ntrc
c--------------------------------------------------
             call trcskp(jj,kk+1,ntrc,luin,ntrc,itr)

  100 CONTINUE
                        if(verbos) then
                           write(LERR,*)'Output Record ',itr(106)
                        endif

  999 continue
        call lbclos(luin)
        call lbclos(luout)
      END

c--------------------------------
c  online help routine
c--------------------------------
      subroutine help
#include <f77/iounit.h>
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for PHZROT: '
        write(LER,*)'rotate the phase of seismic data by constant amt'
        write(LER,*)' '
        write(LER,*)'Input...................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-r[rot]    -- rotate phase (degrees)          (0)'
        write(LER,*)'-M         -- restore early mute'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      phzrot -N[] -O[] [-r[] -M -V]'
        write(LER,*)' '
      return
      end

      subroutine cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,
     1                  verbos,rot,mute)
c-----
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c      ist  - I         start time 
c     iend  - I         end time 
c      nst  - I         start trace
c      ned  - I         end trace
c     nrst  - I         start record
c     nred  - I         end record
c     rot   - R         phase rotation (in degrees)
c     verbos- L         verbose output or not
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*)
      real      rot
      integer   argis,ist,iend,nst,ned,nrst,nred
      logical   verbos, mute

           call argstr('-N',ntap,' ',' ')
           call argstr('-O',otap,' ',' ')
           call argi4('-s',ist,1,1) 
           call argi4('-e',iend,0,0) 
           call argi4('-ns',nst,0,0)
           call argi4('-ne',ned,0,0)
           call argi4('-rs',nrst,1,1)
           call argi4('-re',nred,0,0)
           call argr4 ('-r',rot, .0, .0)
           mute  = ( argis( '-M' ) .gt. 0 )
           verbos = ( argis( '-V' ) .gt. 0 )
c-----
      return
      end
