C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine center (recs, times, nt, nsi, currec, icenter)

#include <f77/iounit.h>

c-----
c    2D interpolation:
c    given the current record number (RecNum, LI, DI, etc)
c    compute an interpolated time based on a vector of
c    control records and times
c    assumption: the input record index increments by 1
c-----

      integer  recs(*)
      real     times(*)
      integer  currec, icenter, nsi

      IF     (currec .le. recs (1)) THEN
             icenter = times (1) / nsi
      ELSEIF (currec .gt. recs(nt)) THEN
             icenter = times (nt) / nsi
      ELSE
             do  j = 1, nt-1

                 if (currec .gt. recs(j)         .AND. 
     1               currec .le. recs(j+1)) then

                     j1 = j
                     j2 = j + 1
                     s =       ( (times(j2) - times(j1)) ) /
     1                   float ( (recs (j2) - recs (j1)) )
                     t =        times(j1)  + 
     1                   s * float (currec - recs(j1))
                 endif
             enddo
             icenter = t / float (nsi)
      ENDIF

      return
      end
