C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PickSort(index, traces, samples, count, nseg ,nrec, 
     :     ntrc )

c routine to sort picks into increasing record/trace order to ease
c interpolations required during mute application.  This also allows 
c the user to have picked the mutes in any order.

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer index(2*SZSMPM,2), count, nseg, ntrc
      integer RecNumBuffer(SZLNHD), npickBuffer(SZLNHD), nrec, trndx

      real traces(*), samples(*) 
      real TraceBuffer(SZLNHD), Samplebuffer(SZLNHD)

c initialize data

      call vclr(TraceBuffer,1,SZLNHD)
      call vclr(Samplebuffer,1,SZLNHD)
      do i = 1,SZLNHD
         RecNumBuffer(i) = 0
         npickBuffer(i) = 0
      enddo

c sort based on traces and return

      trndx = 1

      do i = 1, nseg
         call hsort2 ( index(i,1), traces(trndx), samples(trndx) )
         trndx = trndx + index(i,1)
      enddo

      return
      end
        

     
         



            
