C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- picklay ----- ----- ----- ----- ----- ----- -----

c routine to place a user defined sample amplitude at a time dictated by an
c attached xsd pick file or header value at picks file.

c ----- get machine dependent parameters -----

#include <save_defs.h> 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c dimension standard USP variables 


      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne, nreco, ntrco, argis

      real        tri ( SZSMPM )

      character   ntap*256, otap*256, name*7

      logical     verbos, query

c set up printout files 

#include <f77/pid.h>

c dimension program specific variables 

      integer     index(2*SZSMPM,2), count, nseg
      integer     RecNum, l_RecNum, ln_RecNum, ifmt_RecNum
      integer     TrcNum, l_TrcNum, ln_TrcNum, ifmt_TrcNum
      integer     static, l_StaCor, ln_StaCor, ifmt_StaCor
      integer     mul, spinit, spincr, le1, PickSize, lupick

c variables used in dynamic memory allocation

      integer     abort, errcd1, errcd2, errcd3

      real	  records, traces, times, Amplitude

      pointer     ( wkadr1, traces ( 200000 ) )
      pointer     ( wkadr2, times ( 200000 ) )
      pointer     ( wkadr3, records ( 200000 ) )

      character   pfile*100, PickType*7, mnemonic*6

c Variable Definitions 
c
c ----- Integer -----
c
c     static : static for this trace 
c     index() : contains segment information (seq.rec,npicks) 
c     count : counter for traces() and times() arrays
c     nseg : number of segments in the pick file
c     mul : pick file time units override
c     spinit : initial shot point override
c     spincr : shot point increment override
c     le1 : length of pfile character string
c
c ----- Real -----
c
c     traces() : pick file entries
c     times() : pick file entries 
c
c ----- Character -----
c
c     pfile : pick file name
c     PickType : type of mute requested
c

c Initialize variables

      data lbytes/0/,nbytes/0/,name/'PICKLAY'/,abort/0/

c give command line help if requested 

      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0 )

      if ( query )then
         call help()
         stop
      endif

c open printout file 

#include <f77/open.h>

c get command line input parameters 

      call cmdln ( ntap, otap, pfile, le1, ns, ne, irs, ire, PickType, 
     :     mul, spinit, spincr, mnemonic, Amplitude, verbos )

c get logical unit numbers for input and output of seismic data 

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c read line header of input save certain parameters

      call rtape(luin,itr,lbytes)

      if(lbytes.eq.0)then
         write(LOT,*)'PICKLAY: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

c For trace header values we take mnemonics and build a
c set of pointers to an I*2 array equivalenced to the
c RTAPE  Integer array (headers + data)
c TRACEHEADER is a value in the include file <sisdef.h> that 
c refers to the trace header

      call savelu(mnemonic,ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)  
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)  
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      call hlhprt (itr, lbytes, name, 7, LERR)

c ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records)

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c modify line header to reflect actual number of traces output 

      nreco = ire - irs + 1
      call savew(itr, 'NumRec', nreco, LINHED)
      ntrco = ne - ns + 1
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes 

      obytes = SZTRHD + nsamp * SZSMPD

c save out hlh and line header 

      call savhlh ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal ( nsamp, nsi, ntrc, nrec, iform, ntap, otap, pfile,
     :     le1, PickType, mul, spinit, spincr, mnemonic, Amplitude )

c open pick file 

      call alloclun ( lupick )
      open ( lupick, file = pfile(1:le1), status = 'old', err = 990 )

c Determine Size Requirements and allocate memory 

      call PickCount(lupick,NumPicks,PickType)

      PickSize = NumPicks * SZSMPD

      call galloc(wkadr1,PickSize,errcd1,abort)
      call galloc(wkadr2,PickSize,errcd2,abort)
      call galloc(wkadr3,PickSize,errcd3,abort)

      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 3*PickSize,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 3*PickSize,'  bytes'
         write(LERR,*)' '
      endif
         
c read and qc pick file 

      call ReadPick ( lupick, index, records, traces, times, count, 
     :     nseg, mul, spinit, spincr, PickType, mnemonic, ntrc, nsi, 
     :     verbos )

c sort the picks based on increasing record [or trace if appropriate] index

      call PickSort ( index, traces, times, count, nseg, nrec, ntrc )

c BEGIN PROCESSING SEISMIC DATA 

c skip unwanted records 

      call recskp(1,irs-1,luin,ntrc,itr)

c process desired trace records 

      do 1000 JJ = irs, ire
 
c skip to start trace 

         call trcskp(JJ,1,ns-1,luin,ntrc,itr)
         ic = 0

         do 1001  KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out 

            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call vmov(itr(ITHWP1),1,tri(1),1,nsamp)

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           static, TRACEHEADER )

c kill trace if dead 

            if (static .eq. 30000) then
               call vclr (tri,1,nsamp)
            endif

c get user defined index and trace distance

            call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :           RecNum, TRACEHEADER )
            call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           TrcNum, TRACEHEADER )

c determine tick(s) location and mark trace

            if ( PickType .ne. 'header' ) then

               call Tick ( JJ, KK, index, traces, times, tri, 
     :              Amplitude, nsamp, nseg, nrec, ntrc, count )

            else

               call Tick ( RecNum, TrcNum, index, traces, times, tri, 
     :              Amplitude, nsamp, nseg, nrec, ntrc, count )

            endif

c output trace

            call vmov (tri, 1, itr(ITHWP1), 1, nsamp )
            call wrtape ( luout, itr, obytes )
 
 1001    continue
 
c skip to end of record 

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

 1000 continue

c close data files 

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      close ( lupick )

      write(LERR,*)'end of prgm, processed',nreco,' record(s)',
     :             ' with ',ntrc, ' traces'

      stop

c error messages 

 990  write(LERR,*) ' error openning pick file: check spelling'
      write(LER,*) 'PICKLAY:  error openning pick file: check spelling'

      stop
      end
