C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE DISTIT ( IPICK, IPRNTR, NUMITR )
C***********************************************************************
C
C     SUBROUTINE   - DISTIT
C     LANGUAGE     - FORTRAN
C     AUTHOR       - ED ANDES
C     DATE WRITTEN - 12/??/85
C     REVISION     - DECEMBER, 1985  - ED ANDES
C                    INITIAL RELEASE.
C
C      AMOCO PRODUCTION CO. PROPRIETARY
C                   TO BE MAINTAINED IN CONFIDENCE.....
C
C     ABSTRACT -
C        THIS ROUTINE WILL DISPLAY A DISTRIBUTION OF ITERATIONS
C        HISTOGRAM
C
C     PARAMETERS PASSED -
C       IPICK   - I*4 - ARRAY CONTAINING ITERATION COUNTS
C       IPRNTR  - I*4 - LOGICAL UNIT NUMBER FOR PRINTER
C       NUMITR  - I*4 - NUMBER OF MAXIMUM ITERATIONS
C
C***********************************************************************
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

C
      REAL        NORMAL(25)
C
      INTEGER     IPICK(*)
      CHARACTER*28 HISTGM
C
      CHARACTER*1 ASTER, BLANK, LINE(50)
C
      DATA HISTGM/'DISTRIBUTION OF ITERATIONS  '/
      DATA ASTER/'*'/,  BLANK/' '/
C
      ISUM = 0
      PMAX = 0.0
C
C---- GET TOTAL COUNT FOR NORMALIZATION FACTOR...
      DO 100 I = 1,NUMITR
         ISUM = ISUM + IPICK(I)
  100 CONTINUE
C
      SCALE = 1.0 / FLOAT(ISUM)
C
C---- FIND MAX VALUE AFTER NORMALIZATION...
      DO 200 J = 1,NUMITR
         NORMAL(J) = SCALE * IPICK(J)
         IF ( NORMAL(J) .GT. PMAX ) PMAX = NORMAL(J)
  200 CONTINUE
C
C---- PRINT HEADING...
      N28 = 28
C
      WRITE(IPRNTR,250) HISTGM
  250 FORMAT(//,20X,A28)
      WRITE(IPRNTR,300)
  300 FORMAT(//,28X,'ITERATIONS',3X,'COUNT',/28X,18('-'),/)
C
C---- FILL PRINT LINE WITH CORRECT NUMBER OF ASTERISKS...
      DO 800 I = 1,NUMITR
C
C---- FILL PRINT LINE WITH BLANKS FIRST...
         DO 400 J = 1,50
            LINE(J) = BLANK
  400    CONTINUE
C
C---- ANY CDP'S FOR THIS ITERATION ???
         IF ( IPICK(I) .EQ. 0 ) GO TO 600
C
C---- IF SO, GIVE 'EM AT LEAST ONE ASTERISK...
         MANY = 50. * NORMAL(I) / PMAX
         IF ( MANY .LE. 0 ) MANY = 1
              DO 500 K = 1,MANY
                 LINE(K) = ASTER
  500         CONTINUE
C
C---- PRINT LINE BUFFER...
  600    WRITE(IPRNTR,700) I, IPICK(I), ( LINE(L),L=1,50 )
  700    FORMAT(32X,I2,7X,I5,2X,'I',50A1)
C
  800 CONTINUE
C
      RETURN
      END
C
