C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE INTERP ( IFRI, ILRI, IFWS, ILWS, IRISAV, WSTART,
     *                    NTR, JFOLD )
C***********************************************************************
C
C     SUBROUTINE   - INTERP
C     LANGUAGE     - FORTRAN
C     AUTHOR       - JACQUIE VINSON
C     DATE WRITTEN - 08/03/83
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                  TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: INTERPOLATES A WINDOW START TIME
C
C     PARAMETERS PASSED:
C       IFRI   - I*4 - RECORD LESS THAN CURRENT
C       ILRI   - I*4 - RECORD GREATER THAN CURRENT
C       IFWS   - I*4 - WINDOW START TIME FOR JRI
C       ILWS   - I*4 - WINDOW START TIME FOR KRI
C       IRISAV - I*4 - CURRENT RECORD
C       WSTART - I*4 - NEW WINDOW START TIME
C       NTR    - I*4 - NUMBER OF TRACES PER RECORD
C       JFOLD  - I*4 - FOLD FROM LINE HEADER
C
C***********************************************************************
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

C
      INTEGER     WSTART
C
C---- SEE HOW MANY CDP'S PER RECORD...
      FNTR   = NTR
      FJFOLD = JFOLD
      FRACT  = FNTR / FJFOLD
C
C---- DO IT TO IT...
      SLOPE  = FLOAT( ILWS - IFWS ) / ( FLOAT( ILRI - IFRI ) * FRACT )
      FWS    = FLOAT( IFWS ) + SLOPE * FLOAT( IRISAV - IFRI ) * FRACT
      WSTART = FWS + SIGN( 0.5, FWS )
      RETURN
      END
C
