C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       OPNPRM                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  READS FILENAME FROM COMMAND LINE AND OPENS PARAMETER      *
C            DATA FILE.                                                *
C  ENTRY POINTS:                                                       *
C      OPNPRM  (ARG,FILNAM,LU,PRNTLU,IRETCD)                           *
C  ARGUMENTS:                                                          *
C      ARG     CHAR*6    I - COMMAND LINE ARGUMENT FOR PARAMETER FILE.
C      FILNAM  CHAR*120  O - FILENAME READ FROM COMMAND LINE.          *
C                            BLANK ENTRY OR NO ENTRY IS NOT PERMITTED.
C      LU      INTEGER   I - LOGICAL UNIT OF PARAMETER FILE.
C      PRNTLU  INTEGER   I - LOGICAL UNIT OF SYSOUT FILE.              *
C      IRETCD  INTEGER   O - RETURN CODE. 0 = O.K., 1 = ERROR          *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ARGUS DOWDY                        ORIGIN DATE: 88/03/21  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/03/21  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGSTR - SEARCHES COMMAND LINE FOR ARGUMENT AND READS CHARACTER *
C               STRING FOLLOWING THE ARGUMENT.
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      PRNTLU  ( OUTPUT SEQUENTIAL ) - LOGICAL UNIT OF SYSOUT FILE     *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE OPNPRM(ARG,FILNAM,LU,PRNTLU,IRETCD,cmdln)
C
C     A. DOWDY   2-24-88
C
C     GET FILENAME FROM COMMAND LINE AND OPEN PARAMETER CARD FILE.
C
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

      INTEGER PRNTLU,LU,IRETCD
      CHARACTER*(*) ARG, FILNAM 
      LOGICAL       cmdln
C
      IRETCD=0
C
      CALL ARGSTR(ARG,FILNAM,'pick.crd',' ')
C
      IF (FILNAM(1:1) .EQ. ' ') THEN
C         ASSUME STARTJOB STYLE INPUT
          IF (ICOPEN('-pick.crd',LU) .EQ. 0) THEN   
              WRITE (PRNTLU,'(A)') 'CAN''T OPEN INPUT CARD STREAM'
              WRITE (PRNTLU,'(A)') 'command line input assumed'
              cmdln = .true.
              IRETCD=0
          ENDIF
      ELSE     
C         FILE WAS SPECFIED, TRY TO OPEN IT
          OPEN (LU,FILE=FILNAM,IOSTAT=IRETCD)
          IF (IRETCD .NE. 0) THEN
              WRITE (PRNTLU,'(A)') 'CAN''T OPEN INPUT CARD FILE'
          ENDIF
      ENDIF
C
      RETURN
      END
C
