C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE RTAPHD ( IHEAD, IBUF, NSAMPS, MSI, FORMAT, NTR,
     *                    NRPJOB, JFOLD, MINLI, MAXLI, MINDI, MAXDI,
     *                    LENGTH, NTAP, IPRNTR )
C***********************************************************************
C
C     SUBROUTINE   - RTAPHD
C     ENTRY        - WTAPHD
C     LANGUAGE     - FORTRAN
C     AUTHOR       - JACQUIE VINSON
C     DATE WRITTEN - 12/06/83
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                  TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: OPENS INPUT TAPE THEN READS LINE HEADER CHECKING IT
C               FOR ERRORS AND SETTING VARIABLES THAT WILL BE USED
C               IN FURTHER PROCESSING.
C               ENTRY OPENS THE OUTPUT TAPE AND WRITES OUT THE LINE
C               HEADER.
C
C     PARAMETERS PASSED:
C       IHEAD  - I*4 - LINE HEADER BUFFER
C       IBUF   - I*2 - LINE HEADER BUFFER
C       NSAMPS - I*4 - NUMBER OF SAMPLES
C       MSI    - I*4 - SAMPLE INTERVAL
C       FORMAT - I*4 - FORMAT
C       NTR    - I*4 - NUMBER OF TRACES PER RECORD
C       NRPJOB - I*4 - NUMBER OF RECORDS IN LINE
C       JFOLD  - I*4 - FOLD
C       MINLI  - I*4 - MINIMUM LINE INDEX
C       MAXLI  - I*4 - MAXIMUM LINE INDEX
C       MINDI  - I*4 - MINIMUM DEPTH INDEX
C       MAXDI  - I*4 - MAXIMUM DEPTH INDEX
C       NBYTES - I*4 - NUMBER OF BYTES IN LINE HEADER
C       NTAP   - I*4 - INPUT DATA SET LOGICAL UNIT
C       IPRNTR - I*4 - PRINTER LOGICAL UNIT
C       OTAP   - I*4 - OUTPUT DATA SET LOGICAL UNIT
C
C***********************************************************************

#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C
      INTEGER     IHEAD(*), FORMAT, OTAP
C
      INTEGER     IBUF(*)
c     INTEGER * 2 IBUF(12128), IBLANK
c     INTEGER     IBUF(*)
C
      CHARACTER*2 IBLANK
      CHARACTER*4 HLHARR
      DATA  HLHARR/'PICK'/
C
      DATA IBLANK/'  '/, IFOUR/4/
C
C---- READ LINE HEADER...
      LENGTH = 0
      CALL RTAPE ( NTAP, IBUF, LENGTH )
      IF ( LENGTH  .NE. 0 ) GO TO 200
      WRITE(IPRNTR,100)
  100 FORMAT(/13X,'** M2000 ** ERROR DETECTED BY SUBROUTINE RTAPHD:',
     *       /25X,'END-OF-FILE ENCOUNTERED ATTEMPTING TO READ INPUT',
     *       /25X,'DATA SET LINE HEADER.  VERIFY DATA SET NAME AND,',
     *       /25X,'IN THE CASE OF MULTI-VOLUME DATA SETS, VERIFY',
     *       /25X,'ORDER IN WHICH VOLUMES WERE CATALOGED.',/)
      CALL CCEXIT ( 100 )
C
C---- GET LINE HEADER INFO...
C
Cray FOLLOWING CHANGED FOR Cray LINE HEADER BY A. DOWDY 2-25-88
C
C 200 NSAMPS = IHEAD(16)
C
C---- GET INFOR FOR 3-D...
C
200   continue

      call saver(IBUF,'NumSmp', nsamps , LINHED)
      call saver(IBUF,'SmpInt',   msi  , LINHED)
      call saver(IBUF,'Format', format , LINHED)
      call saver(IBUF,'NumTrc',   ntr  , LINHED)
      call saver(IBUF,'NumRec', nrpjob , LINHED)
      call saver(IBUF,'CDPFld',  jfold , LINHED)

c     MSI    = IHEAD(13)
c     FORMAT = IHEAD(15)
c     NTR    = IHEAD(11)
c     NRPJOB = IHEAD(12)
c     JFOLD  = IHEAD(20)
C
C---- GET INFOR FOR 3-D...

      call saver(IBUF,'MnLnIn',  minli , LINHED)
      call saver(IBUF,'MxLnIn',  maxli , LINHED)
      call saver(IBUF,'MnDpIn',  mindi , LINHED)
      call saver(IBUF,'MxDpIn',  maxdi , LINHED)

c     MINLI  = IHEAD(59)
c     MAXLI  = IHEAD(60)
c     MINDI  = IHEAD(61)
c     MAXDI  = IHEAD(62)
C     IF ( IBUF(87) .EQ. IBLANK ) MINLI = 0
C
      IF ( FORMAT .EQ. 3 ) GO TO 400
Cray          END Cray CHANGES
      WRITE(IPRNTR,300)
  300 FORMAT(/13X,'** M2100 ** ERROR DETECTED BY SUBROUTINE RTAPHD:',
     *       /25X,'FORMAT CODE READ FROM THE INPUT DATA SET LINE ',
C    *       /25X,'HEADER IS NOT A 1 OR A 3.  VERIFY THE INPUT DATA',
     *       /25X,'HEADER IS NOT A 3.  VERIFY THE INPUT DATA',
     *       /25X,'SET LINE HEADER FORMAT CODE.'/)
      ICCODE = 100
C
  400 IF ( FORMAT .EQ. 3 .AND. NSAMPS .LE. 3000 ) GO TO 600
      WRITE(IPRNTR,500)
  500 FORMAT(/13X,'** M2200 ** ERROR DETECTED BY SUBROUTINE RTAPHD:',
     *      /25X,'THE NUMBER OF SAMPLES FILED IN THE INPUT DATA SET ',
     *      /25X,'LINE HEADER EXCEEDS THE PROGRAM LIMIT.   EITHER',
     *      /25X,'CHANGE THE NUMBER OF SAMPLES ENTRY IN THE INPUT DATA',
     *      /25X,'SET LINE HEADER, OR WINDOW THAT PORTION OF THE DATA',
     *      /25X,'OF INTEREST SUCH THAT THE NUMBER OF SAMPLES CONFORMS',
     *      /25X,'TO PROGRAM RESTRICTIONS.  PROGRAM PICK ACCEPTS A',
     *      /25X,' MAXIMUM OF 6000 SAMPLES OF FORMAT 3.',/)
      ICCODE = 100
C
C---- UPDATE PROCESS HISTORY
  600 CONTINUE
      CALL HLHPRT ( IBUF, LENGTH, HLHARR, IFOUR, IPRNTR )
C
      RETURN
C
      ENTRY WTAPHD ( IHEAD, IBUF, NRPJOB, NSAMPS, OTAP, LENGTH,
     1 IPRNTR)
C
      call saver(IBUF,'NumRec', nrpnew , LINHED)
      IF ( NRPJOB .NE. 0
     *           .AND. NRPJOB .NE. nrpnew )
     *                    nrpnew = NRPJOB

      call savew (IBUF,'NumRec',nrpnew, LINHED)
      call savew (IBUF,'NumSmp',  25  , LINHED)
      call savew (IBUF,'Format',   3  , LINHED)
      call savew (IBUF,'MxUHTm',   1  , LINHED)
      call savew (IBUF,'MnUHTm',   1  , LINHED)
      call savew (IBUF,'MxTrOf',   1  , LINHED)
      call savew (IBUF,'MnTrOf',   0  , LINHED)
      call savew (IBUF,'NmDpIn',   0  , LINHED)
C     call savew (IBUF,'StWdFl',   1  , LINHED)
      call savew (IBUF,'DptInt',   0  , LINHED)
      call savew (IBUF,'TmMsSl',   1  , LINHED)
      call savew (IBUF,'TmSlIn',nsamps, LINHED)
      call savew (IBUF,'ReSpFm',   1  , LINHED)

      CALL WRTAPE ( OTAP, IBUF, LENGTH )
C
      RETURN
      END
C
