C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE SCAWT ( REFTR, XCORR, NSCW, LW, KOUNT, TRACE )
C***********************************************************************
C
C     SUBROUTINE   - SCAWT
C     LANGUAGE     - FORTRAN
C     AUTHOR       - A. DOWDY
C     DATE WRITTEN - OCTOBER 22, 1970
C     REVISION     - 05/??/78  -  CECIL JONES
C                    VPSS CONVERSION
C                    09/??/82  -  JACQUIE VINSON
C                    PASS ARRAY PROCESSOR UNIT NUMBER
C                    09/??/83  -  JACQUIE VINSON
C                    DO IN CORE INSTEAD OF A.P.
C
C      AMOCO PRODUCTION CO. PROPRIETARY
C                   TO BE MAINTAINED IN CONFIDENCE.....
C
C     ABSTRACT -
C        THIS SUBROUTINE WILL SCALE AND COMPUTE AND APPLY
C        WEIGHTING COEFFICIENTS TO AN ARRAY.
C
C     PARAMETERS PASSED -
C       REFTR  - R*4 - SUM OF ARRAYS
C       XCORR  - R*4 - SUM OF SQUARES OF ARRAYS
C       NSCW   - I*4 - LENGTH OF REFTR AND XCORR
C       LW     - I*4 - LENGTH OF WINDOW FOR COMPUTING WEIGHTING COEFF.
C       KOUNT  - I*4 - NUMBER OF OBSERVATIONS IN REFTR AND XCORR
C       TRACE  - R*4 - COEFFICIENT BUFFER
C
C***********************************************************************
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

C
      REAL     REFTR(*), XCORR(*), TRACE(*)
C
C---- SQUARE REFTR ARRAY
C---- MULTIPLY XCORR ARRAY BY KOUNT...
      DO 100 I = 1, NSCW
         TRACE(I) = REFTR(I) * REFTR(I)
         XCORR(I) = XCORR(I) * FLOAT(KOUNT)
  100 CONTINUE
C
C---- DIVIDE TRACE BY XCORR
      DO 300 I = 1, NSCW
         IF ( XCORR(I) .LT. 1.0 ) GO TO 200
         XCORR(I) = TRACE(I) / XCORR(I)
         GO TO 300
  200    XCORR(I) = 0.0
  300 CONTINUE
C
C---- PAD FRONT AND END OF XCORR ARRAY WITH LW/2 ZEROS
      KW = LW / 2
      CALL MOVE ( 0, TRACE, 0, KW * SZSMPD )
      JW = KW + NSCW + 1
      CALL MOVE ( 1, TRACE(KW + 1), XCORR(1), NSCW * SZSMPD )
      CALL MOVE ( 0, TRACE(JW), 0, KW * SZSMPD )
C
C---- SUM ADJACENT LW SAMPLES OF TRACE
      BUM = 0.0
      LW1 = LW - 1
C
      DO 400 I = 1,LW
         BUM = BUM + TRACE(I)
  400 CONTINUE
C
      XCORR(1) = BUM
C
      DO 500 I = 2, NSCW
         BUM      = BUM - TRACE(I - 1) + TRACE(I + LW1)
         XCORR(I) = BUM
  500 CONTINUE
C
      CALL MOVE ( 1, TRACE, XCORR, NSCW * SZSMPD )
C
C---- DIVIDE TRACE BY NUMBER OF SAMPLES
      KW  = KW + 1
      LWW = NSCW
      IF ( LWW .GT. LW ) LWW = LW
      J   = 0
C
      DO 600 I = KW, LWW
         J        = J + 1
         TRACE(J) = TRACE(J) / I
  600 CONTINUE
C
      LIM = IABS(NSCW - LW)
      IF ( LIM .LE. 0 ) GO TO 800
C
      DO 700 I = 1, LIM
         J        = J + 1
         TRACE(J) = TRACE(J) / LWW
  700 CONTINUE
C
  800 K    = LWW
      LAST = NSCW - J
      IF ( LAST .LE. 0 ) GO TO 1000
C
      DO 900 I = 1, LAST
         J        = J + 1
         K        = K - 1
         TRACE(J) = TRACE(J) / K
  900 CONTINUE
C
C---- WEIGHT SUMMED ARRAY
 1000 DO 1100 I = 1, NSCW
         REFTR(I) = REFTR(I) * TRACE(I)
 1100 CONTINUE
C
C---- SCALE OUTPUT
      DO 1200 I = 1, NSCW
         REFTR(I) = REFTR(I) / FLOAT(KOUNT)
 1200 CONTINUE
C
C---- THAT'S ALL -- RETURN TO CALLING ROUTINE
      RETURN
      END
C
