C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine nmo (X, v, offset, nsamp, dt, Y, work, R)
************************************************************************
*                                                                      *
*    SUBROUTINE TO PERFORM HYPERBOLIC MOVEOUT CORRECTION.              *
*      INPUTS ARE:                                                     *
*           X = DATA TO BE CORRECTED                                   *
*           V = SQUARED VELOCITY ARRAY                                *
*          PT = ARRAY TO TP's                                          *
*      OFFSET = OFFSET FOR X                                           *
*          nsamp = NUMBER SAMPLES PER TRACE                            *
*          dt = SAMPLE INTERVAL IN MS                                  *
*           Y = CORRECTED DATA                                         *
*          V0 = VELOCITY OF RECORDING MEDIUM FORM IMAGE POINT COMPS    *
*                                                                      *
************************************************************************
      implicit none

c declare variables passed from calling routine

      integer nsamp 

      real offset, dt

      real x(nsamp), v(nsamp), Y(nsamp), work(nsamp)

      logical R

c declare local variables

      integer i, it

      real dist, t0, vsq, shft, tj, f, fs, c1, c2, c3

c initialize variables

      call vclr (work, 1, nsamp)
      call vmov (x, 1, work(2), 1, nsamp)
      work (nsamp+2) = 0
      dist = offset * offset
      call vclr (work(nsamp+2), 1, 2)

      IF (.not.R) THEN

         DO  i = 1, nsamp

             t0   = float(i-1) * dt
             vsq  = v(i) * v(i)
             shft = sqrt ( t0*t0 + dist/vsq ) - t0
             shft = shft / dt

             if (shft .le. nsamp-2) then

                 if (shft .gt. 0) then
                     tj = float(i) + shft
                     it = int (tj)
                     if (it .eq. 0) it = 1
                      f  = tj - aint(tj)
                      fs = f * f
                      c1 = fs - f
                      c2 = 2.0 - 2.0 * fs
                      c3 = fs + f
                      y(i) = 0.5 * (
     :                    work(it)   * c1 +
     :                    work(it+1) * c2 +
     :                    work(it+2) * c3
     :                             )
                 else
                   y (i) = work (i)
                 endif
    
             else
               y (i) = 0
             endif

         ENDDO

      ELSE

         call vclr (y, 1, nsamp)

         DO  i = 2, nsamp

             t0   = (i-1) * dt
             vsq  = v(i) * v(i)
             shft = sqrt ( t0*t0 + dist/vsq ) - t0
             shft = shft / dt
             tj = i + shft
             it = int(tj)

             if (it .ge. 0) then

                if (it .eq. 0) it = 1
                f  = tj - aint(tj)
                fs = f * f
                c1 = fs - f
                c2 = 2.0 - 2.0 * fs
                c3 = fs + f
                y(it) = 0.5 *   (
     :                 work(i)   * c3 +
     :                 work(i+1) * c2 +
     :                 work(i+2) * c1
     :                          )
             endif

         ENDDO

      ENDIF

      RETURN
      END
