C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine bd_winit( w, xpick, zpick, npicks, nx, nz, pass, 
     :     outside, nzmin, nzmax, nxmin, nxmax, w_Across, w_Down,
     :     fringe)

#include <f77/iounit.h>

c routine to build mute mask based on input polygon definition from
c xsd pickfile

c variables passed to/from calling routine

      integer  npicks, nx, nz, nzmin, nzmax, nxmin, nxmax

      real     w(nz,nx), xpick(npicks+1), zpick(npicks+1), pass
      real     w_Across(nz,nx), w_Down(nz,nx), fringe(nz,nx)

      logical  outside

c local variables

      integer  ipick, idir, ix1, ix2, ix, iz1, iz2, iz
      integer  In(100), Out(100), CrossCount
      integer  InCount, OutCount, Count, SwitchCount
      
      real     x1, x2, z1, z2, z, a

      logical  Switch

c initialize variables

c Dan Whitmore: I changed these fills:

cdan  call vfill ( pass, w_Down, 1, nz * nx )
cdan  call vfill ( pass, w, 1, nz * nx )
cdan  call vfill ( pass, w_Across, 1, nz * nx )

c Dan Whitmore: these arrays need to be set to zero (not pass to make
c               sure all of the polygon logic will work

      call vfill ( 0.0, w, 1, nz * nx )
      call vfill ( 0.0, w_Across, 1, nz * nx )
      call vfill ( 0.0, w_Down, 1, nz * nx )
      call vfill ( 0.0 , fringe, 1, nz * nx )

      nxmax = 1
      nxmin = nx
      nzmax = 1
      nzmin = nz

c Kurt's most excellent polygon tracer

      DO ipick = 1, npicks
         x1 = xpick(ipick)
         x2 = xpick(ipick+1)
         z1 = zpick(ipick)
         z2 = zpick(ipick+1)
         nxmin = min(nxmin,nint(x1))
         nxmax = max(nxmax,nint(x1))
         nzmin = min(nzmin,nint(z1))
         nzmax = max(nzmax,nint(z1))

         IF ( abs(z2-z1) .lt. abs(x2-x1) ) then

c define line as z = ax + b           

            a = ( z2 - z1 ) / ( x2 - x1 )

            if ( x1 .lt. x2 ) then 
               idir = 1
            else
               idir = -1
            endif

            ix1 = nint(x1)
            ix2 = nint(x2)

            do ix = ix1, ix2, idir
               z = z1 + a * float( ix - ix1 )
               iz = nint(z)
               w(iz,ix) = 1.0
               fringe(iz,ix) = 1.0
            enddo
         ELSEIF ( z2 .eq. z1 ) then

c zero length segment. set point and continue.

            ix = nint(x1)
            iz = nint(z1)
            w(iz,ix) = 1.0
               fringe(iz,ix) = 1.0
         ELSE

c define line as  x = az + b           

            a = ( x2 - x1 ) / ( z2 - z1 )

            if ( z1 .lt. z2 ) then 
               idir = 1
            else
               idir = -1
            endif

            iz1 =nint(z1)
            iz2 =nint(z2)
            do iz = iz1, iz2, idir
               x = x1 + a * float( iz - iz1 )
               ix = nint(x)
               w(iz,ix) = 1.0
               fringe(iz,ix) = 1.0
            enddo
         ENDIF
      ENDDO

C Bearded Dwarf's kludgy polyfill logic for complex shapes.  What I 
c essentially do here is to build the system two ways.  First by
c scanning down the traces to detect when I am in and out of the 
c shape.  Second by going across the traces.  I then fill the output
c buy the set of like entries between the above two scans.  This is
c successful for the vast majority of weird shapes.  The only pathology
c I have found to date is to find in the interior of the polygon lines
c of zeroes where they don't belong.  So far these have been usually single 
c and at most double lines.  I treat the composite shape to a search for
c these occurances and remove them.  Though not elegant at least this is 
c FAST.

C POLYGON LOGIC ASSUMING LOOKING ACROSS TRACES

      DO iz = 1, nz

         CrossCount = 0
         SwitchCount = 0
         Switch = .false.
         InCount = 0
         OutCount = 0
         
         do i = 1, 100
            In(i) = 0
            Out(i) = 0
         enddo
         
         DO ix = 1, nx
            
            if ( w(iz,ix) .gt. 0. ) then
               
c     have just encountered the line, arm the switch
               
               if ( .not. Switch ) then
                  Switch = .true.
                  SwitchCount = SwitchCount + 1
                  CrossCount = CrossCount + 1
                  
                  if ( mod ( CrossCount, 2 ) .ne. 0 ) then
                     InCount = InCount + 1
                     In(InCount) = ix
                  elseif ( mod ( CrossCount, 2 ) .eq. 0 .and.
     :                    SwitchCount .gt. 2 .and. ix .eq. nx ) then
                     OutCount = OutCount + 1
                     Out(OutCount) = ix
                  endif
               endif
            endif
            
            if ( w(iz,ix) .lt. 1.e-32 .and. Switch ) then
               
c     have completely crossed the line, fire the switch  
               
               Switch = .false.
               SwitchCount = SwitchCount + 1
               if ( mod ( SwitchCount, 4 ) .eq. 0 ) then
                  OutCount = OutCount + 1
                  Out(OutCount) = ix
               endif
            endif
            
         ENDDO
         
c handle complex shapes resulting in an odd number of intersections

         if ( mod(CrossCount,2) .ne. 0 .and. CrossCount .gt. 1 ) then
            
            if ( CrossCount .eq. 3 ) then
               Out(1) = In(2)
               InCount = 1
            elseif ( CrossCount .eq. 5 ) then
               Out(1) = In(3)
               InCount = 1
            elseif ( CrossCount .eq. 7 ) then
               Out(1) = In(4)
               InCount = 1
            endif
         endif

c fill in this trace

         if ( CrossCount .gt. 1 ) then
            
            Count = 1
            
            DO ix = 1, nx
               
               if ( ix .lt. In(Count) ) then
                  w_Across(iz,ix) = 0.0
               else
                  if ( ix .le. Out(Count) ) then
                     w_across(iz,ix) = 1.0
                  else
                     if ( Count .lt. InCount) Count = Count + 1
                     w_Across(iz,ix) = 0.0
                  endif
               endif
            ENDDO
         endif
      ENDDO
    
C POLYGON LOGIC ASSUMING LOOKING DOWN TRACES

      DO ix = 1, nx

c debug

         if ( ix .eq.350 ) then
            write(LERR,*)'made it'
         endif
         
         CrossCount = 0
         SwitchCount = 0
         Switch = .false.
         InCount = 0
         OutCount = 0
         
         do i = 1, 100
            In(i) = 0
            Out(i) = 0
         enddo
         
         DO iz = 1, nz
            
            if ( w(iz,ix) .gt. 0. ) then
               
c     have just encountered the line, arm the switch
               
               if ( .not. Switch ) then
                  Switch = .true.
                  SwitchCount = SwitchCount + 1
                  CrossCount = CrossCount + 1
                  if ( mod ( CrossCount, 2 ) .ne. 0 ) then
                     InCount = InCount + 1
                     In(InCount) = iz
                  elseif ( mod ( CrossCount, 2 ) .eq. 0 .and.
     :                    SwitchCount .gt. 2 .and. iz .eq. nz ) then
                     OutCount = OutCount + 1
                     Out(OutCount) = iz
                  endif
               endif
            endif
            
            if ( w(iz,ix) .lt. 1.e-32 .and. Switch ) then
               
c     have completely crossed the line, fire the switch  
               
               Switch = .false.
               SwitchCount = SwitchCount + 1
               if ( mod ( SwitchCount, 4 ) .eq. 0 ) then
                  OutCount = OutCount + 1
                  Out(OutCount) = iz
               endif
            endif
         ENDDO
         
c     determine if shape is too complex
         
         if ( mod(CrossCount,2) .ne. 0 .and. CrossCount .gt. 1 ) then
            if ( CrossCount .eq. 3 ) then
               Out(1) = In(2)
               InCount = 1
            elseif ( CrossCount .eq. 5 ) then
               Out(1) = In(3)
               InCount = 1
            elseif ( CrossCount .eq. 7 ) then
               Out(1) = In(4)
               InCount = 1
            endif
         endif
         
c     fill in this trace
         
         if ( CrossCount .gt. 1 ) then
            Count = 1
            
            DO iz = 1, nz
               
               if ( iz .lt. In(Count) ) then
                  w_Down(iz,ix) = 0.0
               else
                  if ( iz .le. Out(Count) ) then
                     w_Down(iz,ix) = 1.0
                  else
                     if ( Count .lt. InCount) Count = Count + 1
                     w_Down(iz,ix) = 0.0
                  endif
               endif
            ENDDO
         endif
      ENDDO

c build w with entries from w_Down and w_Across that occurr in both

      do ix = 1, nx
         do iz = 1, nz

            if ( abs ( w_Down(iz,ix) - w_Across(iz,ix) ) .le. 1.e-32 ) 
     :           then
               w(iz,ix) = w_Across(iz,ix)
            else
               w(iz,ix) = 0.0
            endif
         enddo
      enddo

cprg fringe contains the outline of the picks (value 1.0) in an otherwise
cprg zero matrix. It looks like the logic above does not preserve this
cprg fringe so wa add it back in

      do ix = 1, nx
         do iz = 1, nz
            amp = fringe(iz,ix) + w(iz,ix)
            if (amp .eq. 2) amp = 1
               w(iz,ix) = amp
         enddo
      enddo

c watch for single lines of ones that occur within the shape

      do ix = 3, nx-2
         do iz = 3, nz-2

c down1
            if ( w(iz,ix) .le. 1.e-32  .and.
     :           ( abs( w(iz,ix-1) - 1.0 ) ) .le. 1.e-32 .and.
     :           ( abs( w(iz,ix+1) - 1.0 ) ) .le. 1.e-32 ) 
     :           w(iz,ix) = 1.0 

c down2
            if ( w(iz,ix) .le. 1.e-32  .and.
     :           ( abs( w(iz,ix-2) - 1.0 ) ) .le. 1.e-32 .and.
     :           ( abs( w(iz,ix+2) - 1.0 ) ) .le. 1.e-32 ) 
     :           w(iz,ix) = 1.0 

c across1

            if (  w(iz,ix) .le. 1.e-32  .and.
     :           ( abs( w(iz-1,ix) - 1.0 ) ) .le. 1.e-32 .and.
     :           ( abs( w(iz+1,ix) - 1.0 ) ) .le. 1.e-32 ) 
     :           w(iz,ix) = 1.0 

c across2

            if (  w(iz,ix) .le. 1.e-32  .and.
     :           ( abs( w(iz-2,ix) - 1.0 ) ) .le. 1.e-32 .and.
     :           ( abs( w(iz+2,ix) - 1.0 ) ) .le. 1.e-32 ) 
     :           w(iz,ix) = 1.0 

         enddo
      enddo

c flip filter to mute INSIDE the polygon if requested

      if ( .not. outside ) then
         do ix = 1, nx
            do iz = 1, nz
               if ( w(iz,ix) .eq. 1. ) then
                  w(iz,ix) = pass
               else
                  w(iz,ix) = 1.
               endif
            enddo
         enddo
      endif
c     do ix = 150,150
c      do iz = 5,nz,5
c        write(0,*) 'iz,ix, w =', ix,iz,w(iz,ix)
c      enddo
c     enddo

      return
      end
