C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getwgt ( wgt, nxpad, nzpad )

c routine to calculate a (x,z) pad for input polygon

c variables passed from calling routine
      
      integer nxpad, nzpad

      real    wgt (-nzpad:+nzpad, -nxpad:+nxpad )

c local variables

      integer iz, ix 

      real rmax, dxgrid, dzgrid, sumwgt, r, x2, z2, scale

c initialize variables
      
      if (nxpad .le. 1 .AND. nzpad .le. 1) return

      rmax = 1.0
      dxgrid = 1.0 / ( nxpad + 1 )
      dzgrid = 1.0 / ( nzpad + 1 )
      sumwgt = 0.0

c calculate the weights

      DO ix = -nxpad, nxpad

       x2 = ( ix * dxgrid )**2

        DO iz = -nzpad , nzpad

           z2 = ( iz * dzgrid )**2
           r = sqrt( x2 + z2 )
           if ( r .gt. rmax ) then
              wgt(iz,ix)=0.
           else
              wgt(iz,ix) = 1.0 - r / rmax
           endif
           sumwgt = sumwgt + wgt(iz,ix)
        ENDDO
      ENDDO

c normalize

      scale = 1.0 / sumwgt
      DO ix = -nxpad, nxpad
         DO iz = -nzpad, nzpad
            wgt(iz,ix) = wgt(iz,ix) * scale
         ENDDO
      ENDDO

      return
      end

