C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdpicks(segname,segnum,segcolor,npicks,
     1                   record,trace,sample,
     2                   recunit,trcunit,smpunit,recoff,trcoff,smpoff,
     3                   maxpicks,nsegments,lupicks,lerr,
     4                   nz,ntrace,nrec,temp,
     5                   nxtaper,nztaper,verbos)  
c_______________________________________________________________________
C     Simple fortran program to read in the new format xsd picks.  
c_______________________________________________________________________
      character*(*) segname
      integer       segnum(nsegments)
      integer       segcolor(nsegments)
      integer       npicks(nsegments)
      real          record(maxpicks+1,nsegments)
      real          trace(maxpicks+1,nsegments)
      real          sample(maxpicks+1,nsegments)
      real          temp(maxpicks+1)
      logical       verbos 
c_______________________________________________________________________
C     loop over number of segments.                                          
c     note segment name will not be put into an array!
c_______________________________________________________________________
      do 300 iseg=1,nsegments
       read(lupicks,101,err=99991)segnum(iseg),segname,
     1                            segcolor(iseg),npicks(iseg)
101    format(10x,i5,6x,a20,10x,i5,9x,i5)
c_______________________________________________________________________
C      loop over number of picks                                              
c_______________________________________________________________________
       do 200 ipick=1,npicks(iseg)
        read(lupicks,102,err=99992)record(ipick,iseg),trace(ipick,iseg),
     1                             sample(ipick,iseg)
102     format(f12.6,1x,f12.6,1x,f12.6)
200    continue
300   continue

      close(lupicks)
c_____________________________________________________________________
c     add scales and offsets to traces and samples, 
c     but NOT to records. (assume record picks are saved absolutely).
c_____________________________________________________________________
      do 20000 iseg=1,nsegments
       do 10000 ipick=1,npicks(iseg)
        sample(ipick,iseg)=(sample(ipick,iseg)-smpoff)/smpunit
        trace(ipick,iseg)=(trace(ipick,iseg)-trcoff)/trcunit
        record(ipick,iseg)=record(ipick,iseg)
10000  continue
20000 continue
c_____________________________________________________________________
c     close the polygon.      
c_____________________________________________________________________
      do 30000 iseg=1,nsegments
       record(npicks(iseg)+1,iseg)=record(1,iseg)
       trace(npicks(iseg)+1,iseg)=trace(1,iseg)
       sample(npicks(iseg)+1,iseg)=sample(1,iseg)
30000 continue
c_____________________________________________________________________
c     check that all picks are on the same record.
c_____________________________________________________________________
      ipickerror=0
      do 50000 iseg=1,nsegments
       do 40000 ipick=1,npicks(iseg)
        if(record(ipick,iseg) .ne. record(1,iseg)) then
           write(lerr,*) 'polygon crosses record boundaries!'
           write(lerr,*) 'segnum = ',segnum(iseg)
           write(lerr,*) 'ipick  = ',ipick
           write(lerr,*) 'record(1    ,iseg) = ',record(1    ,iseg)
           write(lerr,*) 'record(ipick,iseg) = ',record(ipick,iseg)
           ipickerror=ipickerror+1
        endif
        if(record(ipick,iseg) .lt. 0.)  then  
           write(lerr,*) 'polygon less for record less than 0!'
           write(lerr,*) 'record must be positive!'                 
           write(lerr,*) 'segnum = ',segnum(iseg)
           write(lerr,*) 'ipick  = ',ipick
           write(lerr,*) 'record(ipick,iseg)  = ',record(ipick,iseg)
           ipickerror=ipickerror+1
        endif

        if(trace(ipick,iseg) .lt. 0. .or. 
     1             trace(ipick,iseg) .gt. ntrace) then
           write(lerr,*) 'polygon goes outside sequential '
     1                   //'  trace limits!'
           write(lerr,*) 'trace must fall between 1 and ',ntrace       
           write(lerr,*) 'segnum = ',segnum(iseg)
           write(lerr,*) 'ipick  = ',ipick
           write(lerr,*) 'trace(ipick,iseg)  = ',trace(ipick,iseg)  
           ipickerror=ipickerror+1
        endif
        if(sample(ipick,iseg) .lt. 0. .or. 
     1             sample(ipick,iseg) .gt. nz) then
           write(lerr,*) 'polygon goes outside physical sample limits!'
           write(lerr,*) 'trace must fall between 1 and ',nz           
           write(lerr,*) 'segnum = ',segnum(iseg)
           write(lerr,*) 'ipick  = ',ipick
           write(lerr,*) 'sample(ipick,iseg)  = ',sample(ipick,iseg)  
           ipickerror=ipickerror+1
        endif

40000  continue
50000 continue
      if(ipickerror .gt. 0) then
         write(lerr,*) 'program aborted due to ',ipickerror,
     1                 'in routine rdpicks'
         call exit(20001)
      endif
c____________________________________________________________________
c     sort the picks in ascending order.
c____________________________________________________________________
      do 80000 iseg=1,nsegments
       do 70000 jseg=iseg+1,nsegments
        if(record(1,jseg) .lt. record(1,iseg)) then
c____________________________________________________________________
c          segment jseg out of order. swap positions.
c____________________________________________________________________
           isegnum=segnum(iseg)
           isegcolor=segcolor(iseg)
           ipicks=npicks(iseg)
c
           call vmov(record(1,iseg),1,temp,1,npicks(iseg))
           call vmov(record(1,jseg),1,record(1,iseg),1,npicks(jseg))
           call vmov(temp,1,record(1,jseg),1,npicks(iseg))
c
           call vmov(trace(1,iseg),1,temp,1,npicks(iseg))
           call vmov(trace(1,jseg),1,trace(1,iseg),1,npicks(jseg))
           call vmov(temp,1,trace(1,jseg),1,npicks(iseg))
c
           call vmov(sample(1,iseg),1,temp,1,npicks(iseg))
           call vmov(sample(1,jseg),1,sample(1,iseg),1,npicks(jseg))
           call vmov(temp,1,sample(1,jseg),1,npicks(iseg))
c
           itemp=segnum(iseg)
           segnum(iseg)=segnum(jseg)
           segnum(jseg)=itemp   
c
           itemp=segcolor(iseg)
           segcolor(iseg)=segcolor(jseg)
           segcolor(jseg)=itemp   
c
           itemp=npicks(iseg)
           npicks(iseg)=npicks(jseg)
           npicks(jseg)=itemp   
        endif
70000  continue
80000 continue
c_____________________________________________________________________
c     move picks to record edges if within the tapering window.
c_____________________________________________________________________
      do 82000 iseg=1,nsegments
       do 81000 ipick=1,npicks(iseg)
        if(trace(ipick,iseg) .le. nxtaper) then
           trace(ipick,iseg)=1
        elseif(trace(ipick,iseg) .ge. ntrace-nxtaper) then
           trace(ipick,iseg)=ntrace
        endif 
        if(sample(ipick,iseg) .le. nztaper) then
           sample(ipick,iseg)=1
        elseif(sample(ipick,iseg) .ge. nz-nztaper) then
           sample(ipick,iseg)=nz
        endif 
81000 continue
82000 continue
      if(verbos) then
         do 85000 iseg=1,nsegments
           write(lerr,*) 'segment = ',iseg,
     1                   ' record = ',record(1,iseg)
           write(lerr,'(3a15)') 'pick','trace','sample'
           write(lerr,'(i15,2f12.3)') (ipick,trace(ipick,iseg),
     1                   sample(ipick,iseg),ipick=1,npicks(iseg))
85000     continue
      endif
c
      return
c
99991 write(lerr,*) 'error in routine rdpicks!'
      write(lerr,*) 'read error in attempting to read segment header'
     1              //' card number ',iseg,' of ',nsegments
      write(lerr,*) 'Please check input pick file!'
      call exit(20002)
c
99992 write(lerr,*) 'error in routine rdpicks!'
      write(lerr,*) 'read error in attempting to read pick card ',   
     1              ipick,' of ',npicks(iseg) 
      write(lerr,*) 'segment = ',iseg,' segname = ',segname
      write(lerr,*) 'Please check input pick file!'
      call exit(20003)
c
      end
