C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wsmooth ( w, wbuf, wgt, nzgrid, nzpad, nxgrid, nxpad, 
     :     nzmin, nzmax, nxmin, nxmax )

c routine to apply radial smoothing to a muting operator

c variables passed to/from calling routine

      integer nzgrid, nzpad, nxgrid, nxpad, nzmin, nzmax, nxmin, nxmax

      real w(nzgrid,nxgrid)                             
      real wbuf(1-nzpad:nzgrid+nzpad,1-nxpad:nxgrid+nxpad)   
      real wgt(-nzpad:nzpad,-nxpad:nxpad)

c local variables

      integer ix, iz

      if (nxpad .le. 1 .AND. nzpad .le. 1) return

c initialize variables

      do ix = 1, nxgrid
         do iz = 1, nzgrid
            wbuf(iz,ix) = w(iz,ix)             
         enddo
      enddo

c extend beginning and end of traces into buffer. this
c will preserve edge values after low pass filtering.

      do ix = 1, nxgrid              
         do iz = 1 - nzpad, 0
            wbuf(iz,ix) = wbuf(1,ix)
         enddo

         do iz = nzgrid + 1, nzgrid + nzpad
            wbuf(iz,ix) = wbuf(nzgrid,ix)
         enddo
      enddo

      do iz = 1 - nzpad, nzgrid + nzpad
         do ix = 1 - nxpad, 0
            wbuf(iz,ix) = wbuf(iz,1)
         enddo

         do ix = nxgrid + 1, nxgrid + nxpad
            wbuf(iz,ix) = wbuf(iz,nxgrid)
         enddo
      enddo

c loop over all columns.   

      DO ix = 1, nxgrid

         if ( ix .lt. (nxmin - nxpad ) .or. 
     :        ix .gt. ( nxmax + nxpad ) ) then

c column lies beyond limits of smoothed polygon.

            do iz = 1, nzgrid
               w(iz,ix) = wbuf(iz,ix)
            enddo
         else

            do iz = 1, nzgrid

               if ( iz .lt. ( nzmin - nzpad ) .or. 
     :              iz .gt. ( nzmax + nzpad ) ) then

c row lies beyond limits of smoothed polygon.

                  w(iz,ix) = wbuf(iz,ix)
               else

c apply the low pass filter

                  w(iz,ix) = 0.0   
                  do jx = -nxpad, nxpad
                     do jz = -nzpad, nzpad
                        w(iz,ix) = w(iz,ix) + wgt(jz,jx) * 
     :                       wbuf(iz+jz,ix+jx)
                     enddo
                  enddo
               endif
            enddo
         endif
      ENDDO

      return
      end
