C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C 
C 
C     PROGRAM MODULE POMEGA 
C 
C**********************************************************************C 
c 
c	pomega does a slnat stack in the frequency domain to yield 
c	countours of phase velocity versus frequency 
c	Output to a disk file is the contour in a SIS trace format 
c	Output to the standard error is are the phase velocity values 
c-----
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

	integer    itr (SZLNHD )
	integer    lhed (SZLNHD )
	real       tri (SZLNHD)
	integer    nsamp, nsi, ntrc, nrec, iform
	integer    luin, luout,lbytes,nbytes,lbyout,obytes
	integer    rs, re, ns, ne
	real       gain(SZSMPM)
	character  ntap*256, otap*256, name*6
	logical    verbos
	logical    goagc
        logical    query, heap
	integer    argis
c 	complex    traces (SZSMPM,SZSPRD)
  	complex    traces
        pointer    (wkaddr, traces(1))
	complex    data(SZLNHD)
	real      ci,ce
	real      dis(SZSPRD)
	real      t0(SZSPRD)
	integer   nray
	integer   errcod,abort
#include <f77/pid.h>

c       equivalence( itr(129), tri(1) )
	equivalence( itr(  1), lhed(1) )
	data lbytes/ 0 /, nbytes / 0 /, t0/ SZSPRD * 0.0 /
        data name/'POMEGA'/
	data abort/ 0 /

c-----
c	read program paramters from command line 
c-----
	query = ( argis ( '-?' ) .gt. 0 )
	if( query ) then
		call help()
		stop
	endif

c-----
c	open printout file
c-----
#include <f77/open.h>

	call       gcmdln(ntap,otap,rs,re,ns,ne,ci,ce,
     1		fmin,fmax,nray,lw,verbos,goagc)
	if(nray.gt.500)nray=500
c-----
c	get logical unit numbers for input and output
c-----
	call getln(luin , ntap,'r', 0)
	if(otap(1:1).ne.' ')then
		call getln(luout, otap,'w', 1)
	else
		luout = 1
	endif
c------
c	read line header of input
c	save certain parameters
c-----
	call rtape ( luin, itr, lbytes)
	if(lbytes .eq. 0)then
		write(LER,*)'POMEGA: no header read from unit ',luin
		write(LER,*)'FATAL'
		stop
	endif
	call saver(itr, 'NumSmp', nsamp, LINHED)
	call saver(itr, 'SmpInt', nsi  , LINHED)
	call saver(itr, 'NumTrc', ntrc , LINHED)
	call saver(itr, 'NumRec', nrec , LINHED)
	call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


        call hlhprt (itr, lbytes, name, 6, LERR)
c------
c	set up number of points for FFT
c       npts -> power of 2 (>= nsamp)
c       npts21 = npts/2 + 1
c       df = fnyquist / (npts21-1) = fnyq / (npts/2) = (.5/dt) / (npts/2)
c          = 1. / (npts * dt)
c------
	call npow2(nsamp,npts,npts21)

        dt = real (nsi) * unitsc
        fnyq = .5 / dt

        df = 1./(float(npts)*dt)
        nsampo = fmax / df + 1

        write(LERR,*)'Frequency Increment   =  ',df
        write(LERR,*)'Number freqs to output= ',nsampo
c-----
c	ensure that command line values are compatible with data set
c-----
	call cmdchk(ns,ne,rs,re,ntrc,nrec)
c-----
c	modify line header to reflect traces output
c-----
	call savew(itr, 'NumSmp', nsampo  , LINHED)
	call savew(itr, 'NumRec', re-rs+1, LINHED)
	call savew(itr, 'NumTrc', nray   , LINHED)
	call savhlh(itr,lbytes,lbyout)
	obytes = ( nsampo + ITRWRD ) * SZSMPD
	call wrtape(luout, itr, lbyout)	
c-----
c	verbose output here
c-----
	if(verbos)then
		call verbal(ntap,otap,ci,ce,nray,
     1		fmin,fmax,rs,re,ns,ne,goagc,lw,
     2		nsamp,nsi,ntrc,nrec,iform,npts)
	end if


c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

      items = 2 * ntrc * npts21
      call galloc (wkaddr, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else 
         write(LERR,*)' ' 
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) items*SZHFWD,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
c-----
c	start processing
c-----
c	skip unwanted records
c-----
	call recskp(1,rs-1,luin,ntrc,itr)
        lw = real(lw)/real(nsi)
c-----
c	process desired trace records
c-----
	do 1000 jj=rs,re
		k=0
 		call trcskp(jj,1,ns-1,luin,ntrc,itr)
		do 1001 kk=ns,ne
		    call rtape (luin, itr, nbytes)
                    if(nbytes .eq. 0) then
                       write(LERR,*)'End of file on input:'
                       write(LERR,*)'  rec= ',jj,'  trace= ',kk
                       go to 999
                    endif

                    call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
                    call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          ist  , TRACEHEADER)
                    call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                          idis , TRACEHEADER)
                        idist = iabs( idis )

			if(ist  .ne.30000)then
            			k=k+1
				dis(k) =  idist
 				t0(k)  = 0.
				if(goagc)then
			           llw = lw/nsi
				   call dagc(nsamp,llw,1.0,tri,gain)
				   call vmult(nsamp,tri,gain)
				endif
				do 5003 LL=1,SZSMPM
					data(LL)=cmplx(0.0,0.0)
 5003 		                continue
				do 5004 LL=1,nsamp
					data(LL)=cmplx(tri(LL),0.0)
 5004 				continue
				call four(data,npts,-1,dt,df)
                                ks = (k-1)*npts21
				DO 5005 LL=1,NPTS21
  					traces(ks+LL)=data(LL)
 5005 				continue
			endif
 1001		continue
 		call trcskp(jj,1,ne+1,luin,ntrc,itr)
c-----
c	write the stack amplitudes to the output file
c-----
			dc = (ce -ci)/(nray -1)

			do 6000 i = 1,nray
				c = ci + (i-1)*dc
				ivel = c
c-----
c	now do phase velocity stacking in the frequency domain
c-----
 				call pom(traces,c,dt,df,npts,k,dis,
     1					fmin,fmax,NSI,NSAMP,t0,tri,
     2					npts21)
                                call savew2(itr,ifmt_DstSgn,l_DstSgn,
     1                                      ln_DstSgn, ivel,TRACEHEADER)
                                call savew2(itr,ifmt_DstUsg,l_DstUsg,
     1                                      ln_DstUsg, ivel,TRACEHEADER)
                                call savew2(itr,ifmt_TrcNum,l_TrcNum,
     1                                      ln_TrcNum, i   ,TRACEHEADER)

                                call vmov (tri, 1, itr(ITHWP1),1,nsampo)
				call wrtape(luout,itr,obytes)
 6000			continue
 1000 	continue
c-----
c	close data files and temporary file
c-----
999     continue
	call lbclos(luout)
	call lbclos(luin )
	end

	subroutine help
#include <f77/iounit.h>
	   write(LER,*)
     :'***************************************************************'
	write(LER,*)' '
	write(LER,*)
     :'Execute pomega by typing dump and the following arguments'
          write(LER,*)' '
	  write(LER,*)
     :' -N [ntap]    (default stdin)           : Input data file name'
	  write(LER,*)
     :' -O [otap]    (default none)           : Output data file name'
           write(LER,*)
     :' -rs [rs],    (default=1)         : beginning record number'
           write(LER,*)
     :' -re [re],    (default=last)      : ending record number'
           write(LER,*)
     :' -ns[ns],	(default=1)	: starting trace number'
	write(LER,*)
     :' -ne[ne]		(default=all)	: ending trace number'
        write(LER,*)' '
	write(LER,*)
     :' -c[ci]		(default=1000.0) :starting phase velocity'
	write(LER,*)
     :' -C[ce]		(default=10000.0) : ending phase velocity'
	write(LER,*)
     :' -fmin[fmin]     (default = 1): minimum frequency'
	write(LER,*)
     :' -fmax[fmax]     (default = 100): maximum frequency'
	write(LER,*)
     :' -nray[nray]	(default = 20)  : number of ray parameters '
	write(LER,*)
     :' -V		(default = false): verbose output'
c       write(LER,*)
c    :' -o		(default = false):c-f values from maxima'
	write(LER,*)
     :' -w [lw]         (default 500ms) : agc window in ms  '
	write(LER,*)
     :' -agc            (default false) : apply/remove AGC '
        write(LER,*)' '
	   write(LER,*)
     :'Usage: pomega -N[ntap] -re[re] -rs[rs] -ns[ns] -ne[ne] ',
     :' -c[ci] -C[ce] -fmin[] -fmax[] -nray[nray] -V   '
     :,'-w[lw] -agc '
	   write(LER,*)
     :'***************************************************************'
	return
	end

	subroutine gcmdln(ntap,otap,rs,re,ns,ne,ci,ce,
     1		fmin,fmax,nray,lw,verbos,goagc)
c-----
c	get command arguments
c
c	ntap	C*120	- input file name
c	otap	C*120	- output file name
c	ns	I*4	- starting trace index
c	ne	I*4	- ending trace index
c	rs	I*4	- starting record index
c	re	I*4	- ending trace index
c	ci	R*4	- initial phase velocity
c	ce	R*4	- final phase velocity
c	fmin	R*4	- minimum frequency
c	fmax	R*4	- maximum frequency
c	nray	I*4	- number of ray parameters
c	lw	I*4	- AGS window in ms
c	verbos	L	- verbose output on standard error
c	goagc	L	- apply agc prior to analysis
c-----
#include <f77/iounit.h>
	character ntap*(*), otap*(*)
	integer   ns, ne,rs,re,nray,lw, argis
	real      ci, ce, fmin, fmax
	logical   verbos,goagc

		call argstr('-N', ntap, ' ', ' ' )
		call argstr('-O', otap, ' ', ' ' )
	        call argi4 ('-rs',rs,1,1)
	        call argi4 ('-re',re,0,0)
		call argi4 ('-ns',ns,1,1)
		call argi4 ('-ne',ne,0,0)
		call argr4 ('-c',ci,1000.0,1000.0)
		call argr4 ('-C',ce,10000.0,10000.0)
		call argr4 ('-fmin',fmin,1.0,1.0)
		call argr4 ('-fmax',fmax,100.0,100.0)
		call argi4 ('-nray',nray,20,20)
		call argi4('-w' ,lw,500,500)
		verbos = ( argis ('-V') .gt. 0 )
		goagc = ( argis ('-agc')  .gt. 0 )
	return
	end

	subroutine     verbal(ntap,otap,ci,ce,nray,
     1		fmin,fmax,rs,re,ns,ne,goagc,lw,
     2		nsamp,nsi,ntrc,nrec,iform,npts)
c-----
c	get command arguments
c
c	ntap	C*120	- input file name
c	otap	C*120	- output file name
c	ns	I*4	- starting trace index
c	ne	I*4	- ending trace index
c	rs	I*4	- starting record index
c	re	I*4	- ending trace index
c	ci	R*4	- initial phase velocity
c	ce	R*4	- final phase velocity
c	nray	I*4	- number of ray parameters
c	fmin	R*4	- minimum frequency
c	fmax	R*4	- maximum frequency
c	lw	I*4	- AGS window in ms
c	goagc	L	- apply agc prior to analysis
c	nsamp	I*4	- number of samples
c	nsi	I*4	- sample interval in ms
c	ntrc	I*4	- number of traces
c	nrec	I*4	- number of records
c	iform	I*4	- format code
c	npts	I*4	- number of points in FFT
c-----
#include <f77/iounit.h>
	character ntap*(*), otap*(*)
	integer   ns, ne,rs,re,nray,lw
	integer   nsamp,nsi,ntrc,nrec,iform
	real      ci, ce, fmin, fmax
	logical   goagc

	write(LERR,*)' Values read from file command line'
	write(LERR,*)' Input  data file                        =  ',ntap
	write(LERR,*)' Output data file                        =  ',otap
	write(LERR,*)' Starting phase velocity        	      =  ',ci
	write(LERR,*)' Ending   phase velocity                 =  ',ce
	write(LERR,*)' Minimum frequency                       =  ',fmin
	write(LERR,*)' Maximum frequency                       =  ',fmax
	write(LERR,*)' Number of ray parameters                =  ',nray
	write(LERR,*)' First record to process                 =  ',rs
	write(LERR,*)' Last record to process                  =  ',re
	write(LERR,*)' Starting trace number                   =  ',ns
	write(LERR,*)' Ending   trace number                   =  ',ne
	write(LERR,*)' AGC Gain Applied Prior and Removed     =  ',goagc
	write(LERR,*)' Length of AGC Window in (ms)            =  ',lw
	write(LERR,*)' Number of Samples/Trace                =  ',nsamp
	write(LERR,*)' Sample Interval                         =  ',nsi
	write(LERR,*)' Traces per Record                       =  ',ntrc
	write(LERR,*)' Records per Line                        =  ',nrec
	write(LERR,*)' Format of Data                         =  ',iform
	write(LERR,*)' FFT NPTS                                =  ',NPTS
	return
	end

	subroutine npow2(nsamp,npts,npts21)
c-----
c	Given nsamp, find npts >= nsamp such that npts is a power of 2
c-----	
	integer*4 nsamp, npts, npts21
	npts = 1
 1000	continue
	npts = 2*npts
	if(npts.lt.nsamp)goto 1000
	npts21 = npts/2 + 1
	return
	end


	subroutine pom(traces,c,dt,df,npts,k,dis,
     1  	fmin,fmax,nsi,nsamp,t0,tri,
     2					npts21)
c-----
c	subroutine to perform p-omega stack
c	the procedure is to evaluate
c	
c	SUM cos(phi(i) + omega p r(i))
c
c	This is consistent with the definition of the FFT used
c
c	E.g. G(f) = SUM g(t)exp(-i 2 pi f t) dt
c
c-----
c*****
c	WE DO NOT CONSIDER THE TWO LOWEST FFT FREQUENCIES
c       0.0 dt and 1.0df
c*****
c	SUBROUTINE ARGUMENTS
c
c	traces	R*4	Two dimensional array of spectra of trace
c			traces(LL,LR) for trace LR and freq LL
c	c	R*4	Phase velocity
c	dt	R*4	Sample interval in seconds
c	df	R*4	Frequency sampling interval in Hz
c	npts	I*4	Number of points for FFT
c	k	I*4	Number of traces
c	dis	R*4	Array of source-receiver distances
c	fmin	R*4	- minimum frequency
c	fmax	R*4	- maximum frequency
c	ntap	C*120	File name
c	nsi	I*4	Sample interval in milliseconds
c	NSAMP	I*4	Number of samples in original time series
c	t0	R*4	Array of times of first sample
c-----
c
c-----
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
c	complex traces (SZSMPM,SZSPRD)
 	complex traces (npts21, k)
	complex cfac1
	real    tri(SZSMPM)
	real    dis(SZSPRD)
	real    t0(SZSPRD)
	real    xmax
	complex data
	complex cfac
c-----
c	get number of positive frequency points
c	check maximum plot frequency so it does not exceed nyquist
c-----
c	npts21 = npts/2 + 1
	fnyq = 0.5/dt
c-----
c	SPECIFY LIMITS OF FREQUENCY SAMPLING
c	ALSO DO NOT USE FREQ = 0.0 DF and 1.0 DF
c-----
	if(fmax.gt.fnyq)fmax = fnyq
	NFLOW = FMIN/df  + 1
	NFUPR = FMAX/df +0.5 + 1
	if(NFLOW.LT.3)NFLOW = 3
	if(NFUPR.gt.npts21)NFUPR = npts21
c-----
c	do p-omega stack
c-----
	recmax = 0.0
		p = 1./c
		xmax = -1.0e+38
c	DO STACK FOR EACH FREQUENCY, BUT ANALYTICALLY DIVIDE OUT
c	THE RESPONSE OF THE FIRST TRACE TO REMOVE ANY SOURCE,
c	DISTANT INDEPENDENT PHASE TERM, e.g., Bessel Function
c	If first trace is of low amplitude at any  frequency,
c	do not perform the correction. This may just be a rare
c	numerical event.
c
c	However, if other traces exhibit a very low amplitude,
c	do not include them in the stack [ if(ca .gt.0.0) ] below
c
c-----
		n1 = 3
		call vclr(tri,1,npts21)
		do  100 LL=NFLOW,NFUPR
			omega = 6.2831853*(LL-1)*df
			omegap= omega*p
			data = cmplx(0.0,0.0)
			ompr = omegap*dis(1) - omega*t0(1)
			ca = cabs(traces(LL,1))
			if(ca.gt.0.0)then
			  cfac = traces(LL,1)/ca
			else
			  cfac = cmplx(1.0,0.0)
			endif
			cfac = cfac*cmplx(cos(ompr),sin(ompr))
			cfac = conjg(cfac)

			DO 200 LR = 1,k
c                              isf = LL + (LR-1)*npts21
					r = dis(LR)
					ompr=omegap*r-omega*t0(LR)
					ca = cabs(traces(LL,LR))
					if(ca.gt.0.0)then
					cfac1 = traces(LL,LR)/ca
					else
					cfac1 = cmplx(0.0,0.0)
					endif
				cfac1 = cfac1*cmplx(cos(ompr),sin(ompr))
					data=data+cfac1*cfac
  200   		CONTINUE

		tri(LL) = cabs(data)
  100    	continue
  400   	continue

	return
	end


