C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
CPROG CELLPR
      SUBROUTINE CELLPR (IPR,ISGN,NX,NY,NXY,KOUNT)
C***********************************************************************
C     SUBROUTINE - CELLPR
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: DOUGLAS BODDY
C
C     DATE WRITTEN: NOVEMBER, 1983
C
C     AMOCO PRODUCTION CO. PROPRIETARY _ TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT -
C          PRINT CELL INFORMATION
C
C***********************************************************************
C
      INTEGER KOUNT(1)
cmam  INTEGER*2 KOUNT(1)
C
ccc   CHARACTER*1 LIST(22)/'(','1','X',',','I','4',',','''',
ccc  $  ' ','|','''',',',' ',' ','I','4',',','''',' ','|','''',')'/
ccc   CHARACTER*1 DASH(19)/'(','6','X',',','I','1',',',' ',' ',' ','(',
ccc  $ '''','-','''',')',',','I','1',')'/
ccc   CHARACTER*1 SPACE(17)/'(','6','X',',','''','|','''',',',
ccc  $ ' ',' ',' ','X',',','''','|','''',')'/
	CHARACTER*1 LIST(22), DASH(19), SPACE(17)

      DATA LIST/'(','1','X',',','I','4',',','''',

     $  ' ','|','''',',',' ',' ','I','4',',','''',' ','|','''',')'/

      DATA DASH/'(','6','X',',','I','1',',',' ',' ',' ','(',

     $ '''','-','''',')',',','I','1',')'/

      DATA SPACE/'(','6','X',',','''','|','''',',',

     $ ' ',' ',' ','X',',','''','|','''',')'/

      CHARACTER*4 BCD
C
C-----------------------------------------------------------------------
C     TRAP THE MAXIMUM FOLD (MAXIMUM "NO. OF TRACES" IN ANY ONE CELL)
C     TRAP THE TOTAL NUMBER OF LIVE TRACES IN THE GRID
C-----------------------------------------------------------------------
C
      MAX               = 0
      NTR               = 0
C
      DO 10 IX = 1,NXY
         KNT = KOUNT(IX)
         IF (MAX.LT.KNT) MAX = KNT
         NTR = NTR + KNT
 10   CONTINUE
C
C=======================================================================
C     GENERATE PRINTER CHART OF CELL CONTENTS
C=======================================================================
C
C     DETERMINE WHICH DIMENSION IS MOST EFFICIENT ACROSS THE PAGE
C         1- CELLS IN X-DIRECTION ACROSS A PAGE ?
C         2- CELLS IN Y-DIRECTION ACROSS A PAGE ?
C
C-----------------------------------------------------------------------
C
      IF (NX.GT.NY) GO TO 20
C
      NCELLX            =  31
      NLOOP             = (NX + NCELLX - 1)  / NCELLX
      NLEFT             =  NX - ((NX - 1) / NCELLX * NCELLX)
      GO TO 30
C
 20   NCELLY            =  31
      NLOOP             = (NY + NCELLY - 1)  / NCELLY
      NLEFT             =  NY - ((NY - 1) / NCELLY * NCELLY)
      GO TO 100
C
C-----------------------------------------------------------------------
C     FILL PRINTER CHART LINES USING THE FOLLOWING FORMATS:
C         1- LIST (1)-LIST (22); (1X,I4,' |',??I4,' |)
C         2- DASH (1)-DASH (19); (6X,I1,???('-'),I1)
C         3- SPACE(1)-SPACE(17); (6X,'|',???X,'|')
C-----------------------------------------------------------------------
C
C-----------------------------------------------------------------------
C     BUILD THE AXES USING DELTA-X ACROSS THE PAGE
C-----------------------------------------------------------------------
C
 30   DO 90 LOOP = 1,NLOOP
C
         WRITE (IPR,40)
 40      FORMAT ('1')
C
         NXSIZE            = (LOOP  - 1)     * NCELLX
         JSTART            = NXSIZE + 1
         IF (LOOP.EQ.NLOOP) NCELLX   = NLEFT
         JEND              = JSTART + NCELLX - 1
C
C=======================================================================
C======= CODE DIFFERENCES BETWEEN IBM AND PERKIN-ELMER =================
C=============================           ===============================
C        CALL ENCODF (NCELLX,BCD,4)
         WRITE (BCD,45) NCELLX
C        ENCODE (BCD,45) NCELLX
 45      FORMAT (I4)
C=============================           ===============================
C=======================================================================
C
         LIST(13)          = BCD(3:3)
         LIST(14)          = BCD(4:4)
C
C=======================================================================
C======= CODE DIFFERENCES BETWEEN IBM AND PERKIN-ELMER =================
C=============================           ===============================
         NCELXX = NCELLX * 4 + 1
         WRITE (BCD,45) NCELXX
C        CALL ENCODF (NCELXX,BCD,4)
C        ENCODE (BCD,45) NCELXX
C=============================           ===============================
C=======================================================================
C
         DASH( 8)          = BCD(2:2)
         DASH( 9)          = BCD(3:3)
         DASH(10)          = BCD(4:4)
C
         SPACE( 9)         = BCD(2:2)
         SPACE(10)         = BCD(3:3)
         SPACE(11)         = BCD(4:4)
C
         WRITE (IPR,50) (IX,IX=JSTART,JEND)
 50      FORMAT (' CELL  ',31I4)
C
         IF (ISGN.EQ.1) GO TO 70
C
C-----------------------------------------------------------------------
C     FILL THE PRINTER CHART BASED UPON GRID ORIENTATION
C-----------------------------------------------------------------------
C
C     GRID CONFIGURATION #1:     1---------4
C                                |         |
C                                |         |
C                                2---------3
C
C-----------------------------------------------------------------------
C
         IL                = 1
         IR                = 4
         WRITE (IPR,DASH) IL,IR
         WRITE (IPR,SPACE)
C
         DO 60 IY = 1,NY
            IL             =(IY-1) * NX     + 1 + NXSIZE
            IR             = IL    + NCELLX - 1
            WRITE (IPR,LIST) IY,(KOUNT(IX),IX=IL,IR)
 60      CONTINUE
C
         WRITE (IPR,SPACE)
C
         IL                = 2
         IR                = 3
         WRITE (IPR,DASH) IL,IR
         WRITE (IPR,50) (IX,IX=JSTART,JEND)
         GO TO 90
C
C-----------------------------------------------------------------------
C
C     GRID CONFIGURATION #2:     2---------3
C                                |         |
C                                |         |
C                                1---------4
C
C-----------------------------------------------------------------------
C
 70      IL                = 2
         IR                = 3
         WRITE (IPR,DASH) IL,IR
         WRITE (IPR,SPACE)
         INDY              = NY + 1
C
         DO 80 I = 1,NY
            IY             = INDY  - I
            IL             =(IY-1) * NX     + 1 + NXSIZE
            IR             = IL    + NCELLX - 1
            WRITE (IPR,LIST) IY,(KOUNT(IX),IX=IL,IR)
 80      CONTINUE
C
         WRITE (IPR,SPACE)
C
         IL                = 1
         IR                = 4
         WRITE (IPR,DASH) IL,IR
         WRITE (IPR,50) (IX,IX=JSTART,JEND)
C
 90   CONTINUE
C
      GO TO 150
C
C-----------------------------------------------------------------------
C     BUILD AXES USING DELTA-Y ACROSS THE PAGE
C-----------------------------------------------------------------------
C
 100  DO 140 LOOP = 1,NLOOP
C
         WRITE (IPR,40)
C
         NYSIZE            = (NX    * NCELLY) * (LOOP   - 1)
         JSTART            = (LOOP  - 1) * NCELLY + 1
         IF (LOOP.EQ.NLOOP) NCELLY   = NLEFT
         JEND              = JSTART + NCELLY  -  1
C
C=======================================================================
C======= CODE DIFFERENCES BETWEEN IBM AND PERKIN-ELMER =================
C=============================           ===============================
         WRITE (BCD,45) NCELLY
C        CALL ENCODF (NCELLY,BCD,4)
C        ENCODE (BCD,45) NCELLY
C=============================           ===============================
C=======================================================================
C
         LIST(13)          = BCD(3:3)
         LIST(14)          = BCD(4:4)
C
C=======================================================================
C======= CODE DIFFERENCES BETWEEN IBM AND PERKIN-ELMER =================
C=============================           ===============================
         NCELYY = NCELLY * 4 + 1
         WRITE (BCD,45) NCELYY
C        CALL ENCODF (NCELYY,BCD,4)
C        ENCODE (BCD,45) NCELYY
C=============================           ===============================
C=======================================================================
C
         DASH( 8)          = BCD(2:2)
         DASH( 9)          = BCD(3:3)
         DASH(10)          = BCD(4:4)
C
         SPACE( 9)         = BCD(2:2)
         SPACE(10)         = BCD(3:3)
         SPACE(11)         = BCD(4:4)
C
         WRITE (IPR,50) (IY,IY=JSTART,JEND)
C
         IF (ISGN.EQ.-1) GO TO 120
C
C-----------------------------------------------------------------------
C
C     GRID CONFIGURATION #3:     1---------2
C                                |         |
C                                |         |
C                                4---------3
C
C-----------------------------------------------------------------------
C
         IL                = 1
         IR                = 2
         WRITE (IPR,DASH) IL,IR
         WRITE (IPR,SPACE)
C
         DO 110 IX = 1,NX
            IR             =(NCELLY-1) * NX + IX + NYSIZE
            IL             = IX + NYSIZE
            WRITE (IPR,LIST) IX,(KOUNT(IY),IY=IL,IR,NX)
 110     CONTINUE
C
         WRITE (IPR,SPACE)
C
         IL                = 4
         IR                = 3
         WRITE (IPR,DASH) IL,IR
         WRITE (IPR,50) (IY,IY=JSTART,JEND)
         GO TO 140
C
C-----------------------------------------------------------------------
C
C     GRID CONFIGURATION #4:     4---------3
C                                |         |
C                                |         |
C                                1---------2
C
C-----------------------------------------------------------------------
C
 120     IL                = 4
         IR                = 3
         WRITE (IPR,DASH) IL,IR
         WRITE (IPR,SPACE)
         INDX              = NX + 1
C
         DO 130 I = 1,NX
            IXX            = INDX  - I
            IX             = IXX       + NYSIZE
            IR             =(NCELLY-1) * NX + IX
            WRITE (IPR,LIST) IXX,(KOUNT(IY),IY=IX,IR,NX)
 130     CONTINUE
C
         WRITE (IPR,SPACE)
C
         IL                = 1
         IR                = 2
         WRITE (IPR,DASH) IL,IR
         WRITE (IPR,50) (IY,IY=JSTART,JEND)
C
 140  CONTINUE
C
C-----------------------------------------------------------------------
C     PRINT INFORMATION ABOUT THE GRID
C-----------------------------------------------------------------------
C
 150  WRITE (IPR,160) NX,NY
 160  FORMAT (///, 1X, 'NO. OF CELLS ALONG SIDE 1-4 = ', I5,
     $             5X, 'NO. OF CELLS ALONG SIDE 1-2 = ', I5, /)
C
C-----------------------------------------------------------------------
C     WRITE SOME FINAL STATISTICS
C-----------------------------------------------------------------------
C
      WRITE (IPR,170) NTR,MAX
 170  FORMAT ( / 1X, 'NO. OF LIVE TRACES CONTAINED IN AREA = ', I6,
     $       5X, 'MAX. NO. OF LIVE TRACES/CELL = ', I4)
C
      RETURN
      END
