C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine bldwt (nw, taper, cost, bart, weight)
#include <f77/iounit.h>
      real    weight (*)
      real    taper
      integer nw
      logical cost, bart

         call vfill (1.0, weight, 1, nw)
         tp = .5 * taper / 100
         nw2 = tp * nw

         if (nw2 .lt. 3) then
            write(LERR,*)'WARNING:'
            write(LERR,*)'Length of taper= ',lw2,' < 3'
            write(LERR,*)'No taper applied'
            cost = .false.
            bart = .false.
         endif

         IF    (cost)  THEN

            do  i = 1, nw2
                ang = 3.14159265 * float(nw2-i)/float(nw2)
                weight(i) = .5 * (1. + cos ( ang ))
                weight(nw-i+1) = weight(i)
            enddo

         ELSEIF (bart) THEN

          do  i = 1, nw2
              weight(i) = float(i)/ float(nw2)
              weight(nw-i+1) = weight(i)
          enddo

         ENDIF

         write(LERR,*)' '
         write(LERR,*)'Design Wondow Taper Weights'
         write(LERR,100)(weight(ii),ii=1,nw)
         write(LERR,*)' '
100      format(8f8.2)

      return
      end
