c -----------------  Main Routine -----------------------
c
c     copyright 2001, Amoco Production Company 
c              All rights reserved
c        an affiliate of BP America Inc.
c
c -----------------  ------------ -----------------------

c     Program Changes:

c      - original written: June 26, 2001

c     Program Description:

c      - template for trace processing in USP.  This is a very basic version
c     and contains only the bare minimum of functionality.  For a complete
c     picture see usp/src/cmd/prgm.F

      implicit none

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin , luout, lbytes, nbytes, lbyout, obytes
      integer     ist, iend, irs, ire, ns, ne, argis, jerr
      integer     JJ, KK

      real        tri ( SZLNHD )
      real        UnitSc, dt

      character   ntap*255, otap*255, name*4

      logical     verbos

c Program Specific _ dynamic memory variables

      integer TraceSize, errcd1, abort

      real    Trace_WorkSpace

      pointer ( mem_Trace_WorkSpace, Trace_WorkSpace(2))

c Program Specific _ static memory variables

      integer ifmt_RecNum,l_RecNum,ln_RecNum, RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum, TrcNum
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn, DstSgn
      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer length, lenth

c Initialize variables

      data abort/0/
      data name/"PRGM"/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos )

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         length = lenth(ntap)
         write(LERR,*)'PRGM: no line header on input dataset',
     :        ntap(1:length)
         write(LER,*)' '
         write(LER,*)'PRGM: '
         write(LER,*)' no line header on input dataset',ntap(1:length)
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', UnitSc, LINHED)

c define pointers to header words required by your routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)

c POLICEMAN: check header for units scaling.  Using UnitSc, remember
c that UnitSc default is milliseconds [i.e. 0.001] and UnitSc
c is a floating point variable.  A UnitSc entry of 1.0 would
c mean units are in seconds.  A UnitSc entry of 0 indicates that
c the unit was not defined.  In this case milliseconds are 
c assumed and loaded to the header for further processing.

      if ( UnitSc .eq. 0.0 ) then
         write(LERR,*)'********************************************'
         write(LERR,*)'WARNING: sample unit scaler in LH = ',UnitSc
         write(LERR,*)'         will set to .001 (millisec default)'
         write(LERR,*)'********************************************'
         UnitSc = 0.001
         call savew ( itr, 'UnitSc', UnitSc, LINHED)
      endif

c compute delta T in seconds

      dt = real (nsi) * UnitSc

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

c this logic assumes parameterization in units of the dataset

      ist = nint ( float(ist) / float(nsi) ) + 1
      if ( ist .eq. 0 ) ist = 1

      if ( iend .eq. -99999 ) then
         iend = nsamp
      else
         iend = nint ( float(iend) / float(nsi) ) + 1
         if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp
      endif

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

c modify line header to reflect actual record configuration output
c NOTE: in this case the sample limits ist and iend are used to 
c       limit processing only.   All data samples are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, ns, ne, verbos)

c dynamic memory allocation:  

      TraceSize = nsamp 
      call galloc (mem_Trace_WorkSpace, TraceSize * SZSMPD, errcd1, 
     :     abort)
    
      if ( errcd1 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) TraceSize * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call move ( 0, Trace_WorkSpace, 0, TraceSize*SZSMPD )

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         DO KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c get required trace header information

            call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :           RecNum, TRACEHEADER )

            call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           TrcNum, TRACEHEADER) 

            call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

c process only live traces

            if ( StaCor .ne. 30000) then

c Put your subroutine here [remember to declare any arguments you need
c over and above those already declared]
c load trace portion of itr[] to real array tri[]
 
               call move ( 1, tri, itr(ITHWP1), nsamp*SZSMPD )
               call subs_r ( tri, Trace_WorkSpace, nsamp, ist, iend )
               call move ( 1, itr(ITHWP1), tri, nsamp*SZSMPD )

            endif
c write output data

            call wrtape (luout, itr, obytes)
 
         ENDDO
 
c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'prgm: Normal Termination'
      write(LER,*)'prgm: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'prgm: ABNORMAL Termination'
      write(LER,*)'prgm: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for prgm: USP template'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman or see the USP'
      write(LER,*)' intranet site '
      write(LER,*)' '
      write(LER,*)'Input......................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                     (stdin)'
      write(LER,*)'-O[]   -- output data set                   (stdout)'
      write(LER,*)'-s[]   -- process start time (ms)                (1)'
      write(LER,*)'-e[]   -- process end time (ms)        (last sample)'
      write(LER,*)'-ns[]  -- start trace number                     (1)'
      write(LER,*)'-ne[]  -- end trace number              (last trace)'
      write(LER,*)'-rs[]  -- start record                           (1)'
      write(LER,*)'-re[]  -- end record                   (last record)'
      write(LER,*)'-V     -- verbos printout' 
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       prgm -N[] -O[] -s[] -e[] -ns[] -ne[] -rs[]'
      write(LER,*)'            -re[] -V'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos )

      implicit none

#include <f77/iounit.h>

      integer    ist, iend, ns, ne, irs, ire, argis

      character  ntap*(*), otap*(*), name*(*)

      logical    verbos

           call argi4 ( '-e', iend, -99999, -99999 )

           call argi4 ( '-ne', ne, 0, 0 )
           call argi4 ( '-ns', ns, 0, 0 )
           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )

           call argi4 ( '-s', ist, 1, 1 )

           verbos = (argis('-V') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's (eat,die)

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, ns, ne, verbos)

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, ns, ne, nsi

      character  ntap*(*), otap*(*)

      logical    verbos

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', irs 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





