C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c routine: pstack

c changes: 
c
c         May 1 2001: now check that LinInd and DphInd are not negative which was happening
c                     for Kenny Gullette when running some DDS type software that hosed some
c                     of the trace indices.  Hopefully this change does not resurface when
c                     someone comes along with valid negative indices.
c         Garossino
c
c         Mar22/96  added -phase option for Greg Partyka to do phase vector
c                    sum.  Better debug this on monday by testing old funcitonality
c                    and do global compile etc. and release
c         Garossino

c Author Paul G. A. Garossino
c Requested by Todd Jones 
c    declare variables
c
c get machine dependent parameters 

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c dimension standard USP variables 

      integer     itr( SZLNHD )
      integer     nsamp,nsampo,nsi,ntrc,ntrco,nrec,nreco,iform
      integer     luin,luout,lbytes,nbytes,obytes,lufold
      integer     argis,ist,iend,irs,ire,ns,ne
      integer     JJ,KK
      
      real        tri ( SZLNHD )
      character   name*6, ntap*255, otap*255, foldtap*255
      
      logical     verbos
      
c dimension program specific variables

c dimension variables used to load output trace headers of stacked
c trace  with appropriate information from gather.  

c 3D orientated header entries

      integer      SrRcMX, l_SrRcMX, fmt_SrRcMX, ln_SrRcMX
      integer      SrRcMY, l_SrRcMY, fmt_SrRcMY, ln_SrRcMY
      integer      DphInd, l_DphInd, fmt_DphInd, ln_DphInd
      integer      LinInd, l_LinInd, fmt_LinInd, ln_LinInd
      integer      CDPBCX, l_CDPBCX, fmt_CDPBCX, ln_CDPBCX
      integer      CDPBCY, l_CDPBCY, fmt_CDPBCY, ln_CDPBCY

c dead trace flag
      
      integer      StaCor, l_StaCor, fmt_StaCor, ln_StaCor

c mute restore entries based on near offset value

      integer      VPick1, l_VPick1, fmt_VPick1, ln_VPick1
      integer      VPick2, l_VPick2, fmt_VPick2, ln_VPick2

c restore datum entry for arcsdatum based on near offset value

      integer      TVPT21, l_TVPT21, fmt_TVPT21, ln_TVPT21

c shot point over 2D depth point

      integer      SrcPnt, l_SrcPnt, fmt_SrcPnt, ln_SrcPnt

c near offset

      integer      DstSgn, l_DstSgn, fmt_DstSgn, ln_DstSgn

c group elevation

      integer      GrpElv, l_GrpElv, fmt_GrpElv, ln_GrpElv

c NOTE: will continue to add any values requested by users.  No attempt
c       has been made to do exhaustive headerwork here.

      integer      LastDstSgn, NumDeadTraces

      real        SumTrace ( SZLNHD ), FoldTrace ( SZLNHD ), Dot
      real        ExponentTrace (SZLNHD), Denominator_Exponent
      real        X ( SZLNHD ), Y ( SZLNHD )

      logical phase

c initialize necessary variables 

      data name/'PSTACK'/
      data lbytes/0/

c get online help if necessary 

      if ( argis ('-?') .gt. 0 .or. 
     :     argis ('-h') .gt. 0 .or. 
     :     argis ('-help') .gt. 0)then
         call help ()
         stop
      endif

#include <f77/open.h>

c get command line parameters 

      call cmdln ( ntap, otap, foldtap, ist, iend, irs, ire, ns, ne, 
     :     Denominator_Exponent, phase, verbos )

c get logical units 

      call getln ( luin, ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )

      if ( foldtap .ne. ' ' ) call getln ( lufold, foldtap, 'w', 1 )

      write(LERR,*)'Input unit # is ',luin,' for DSN= ',ntap

      lbytes = 0
      call rtape ( luin, itr, lbytes )
      write(LERR,*)'lbytes= ',lbytes

      if(lbytes .eq. 0) then
         write(LERR,*)'PSTACK: no header read on input dataset ',ntap
         write(LERR,*)'Check existence of file & rerun'
         write(LERR,*)'FATAL'
         stop
      endif

c record Historical Line Header in printout file

      call hlhprt ( itr, lbytes, name, 6, LERR )

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      if(nsamp .gt. SZSMPM) nsamp=SZSMPM

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c set record start and end defaults 

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 ) ire = nrec

c determine number of records to process 

      nreco=ire-irs+1

c convert start and end time to start and end sample 

      ist = ist / nsi
      iend = iend / nsi
      if ( ist .lt. 1 ) ist = 1
      if ( iend .lt. 1 ) iend = nsamp

c determine number of output samples 

      nsampo = iend - ist + 1

c assign output number of traces/record to be unity [1] 

      ntrco = 1

c build pointers for later access of trace header entries 

      call savelu ( 'SrRcMX', fmt_SrRcMX, l_SrRcMX, ln_SrRcMX, 
     :     TRACEHEADER )
      call savelu ( 'SrRcMY', fmt_SrRcMY, l_SrRcMY, ln_SrRcMY, 
     :     TRACEHEADER )
      call savelu ( 'StaCor', fmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )
      call savelu ( 'SrcPnt', fmt_SrcPnt, l_SrcPnt, ln_SrcPnt, 
     :     TRACEHEADER )
      call savelu ( 'DphInd', fmt_DphInd, l_DphInd, ln_DphInd, 
     :     TRACEHEADER )
      call savelu ( 'VPick1', fmt_VPick1, l_VPick1, ln_VPick1, 
     :     TRACEHEADER )
      call savelu ( 'VPick2', fmt_VPick2, l_VPick2, ln_VPick2, 
     :     TRACEHEADER )
      call savelu ( 'DstSgn', fmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :     TRACEHEADER )
      call savelu ( 'CDPBCX', fmt_CDPBCX, l_CDPBCX, ln_CDPBCX, 
     :     TRACEHEADER )
      call savelu ( 'CDPBCY', fmt_CDPBCY, l_CDPBCY, ln_CDPBCY, 
     :     TRACEHEADER )
      call savelu ( 'LinInd', fmt_LinInd, l_LinInd, ln_LinInd, 
     :     TRACEHEADER )
      call savelu ( 'TVPT21', fmt_TVPT21, l_TVPT21, ln_TVPT21,
     :     TRACEHEADER )
      call savelu ( 'GrpElv', fmt_GrpElv, l_GrpElv, ln_GrpElv,
     :     TRACEHEADER )

c write output line header 

      call savhlh ( itr, lbytes, lbyout )
      
c adjust output line header for new number of records etc. 

      call savew ( itr, 'NumRec', nreco, LINHED) 
      call savew ( itr, 'NumSmp', nsampo, LINHED) 
      call savew ( itr, 'NumTrc', ntrco, LINHED) 

      call wrtape ( luout, itr, lbyout )

      if ( foldtap .ne. ' ') call wrtape (lufold, itr, lbyout )

c determine number of output bytes per trace

      obytes = SZTRHD + SZSMPD * nsampo

c printout 

      call verbal ( nsamp, nsampo, nsi, ntrc, ntrco, nrec, nreco, iform,
     :     ist, iend,  ns, ne, irs, ire, Denominator_Exponent, phase, 
     :     verbos ) 

c skip to start record 

      call recskp(1,irs-1,luin,ntrc,itr)

      DO 100 JJ = irs, ire

c clear SumTrace and FoldTrace for this record

         call vclr ( SumTrace, 1, nsamp )
         call vclr ( FoldTrace, 1, nsamp )
         call vclr ( X, 1, nsamp )
         call vclr ( Y, 1, nsamp )
         NumDeadTraces = 0

c skip to desired trace 

         call trcskp(jj,1,ns-1,luin,ntrc,itr)

C initialize trace header search variables
         
         LastDstSgn = 999999
         DphInd = 999999
         LinInd = 999999
         SrcPnt = 999999
         CDPBCX = 999999
         CDPBCY = 999999
         SrRcMX = 999999
         SrRcMY = 999999
         GrpElv = 999999

         DO 99 KK = ns,ne

            nbytes = 0
            call rtape(luin,itr,nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',KK
               go to 999
            endif

c check if dead trace 
            call saver2 (itr, fmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :           TRACEHEADER ) 

c monitor trace header variables if trace is live

            if ( StaCor .ne. 30000 ) then

c check to see if GrpElv is defined for this output trace yet,
c if not keep reading it

               if ( GrpElv .eq. 999999 )
     :              call saver2 (itr, fmt_GrpElv, l_GrpElv, ln_GrpElv,
     :              GrpElv, TRACEHEADER )

c check to see if SrRcMX is defined for this output trace yet,
c if not keep reading it

               if ( SrRcMX .eq. 999999 ) 
     :              call saver2 (itr, fmt_SrRcMX, l_SrRcMX, ln_SrRcMX, 
     :              SrRcMX, TRACEHEADER ) 

c check to see if SrRcMY is defined for this output trace yet,
c if not keep reading it

               if ( SrRcMY .eq. 999999 ) 
     :              call saver2 (itr, fmt_SrRcMY, l_SrRcMY, ln_SrRcMY, 
     :              SrRcMY, TRACEHEADER ) 

c check to see if LinInd is defined for this output trace yet,
c if not keep reading it

               if ( LinInd .eq. 999999 .or. LinInd .le. 0 ) 
     :              call saver2 (itr, fmt_LinInd, l_LinInd, ln_LinInd, 
     :              LinInd, TRACEHEADER ) 

c check to see if CDPBCX is defined for this output trace yet,
c if not keep reading it

               if ( CDPBCX .eq. 999999 ) 
     :              call saver2 (itr, fmt_CDPBCX, l_CDPBCX, ln_CDPBCX, 
     :              CDPBCX, TRACEHEADER ) 

c check to see if CDPBCY is defined for this output trace yet,
c if not keep reading it

               if ( CDPBCY .eq. 999999 ) 
     :              call saver2 (itr, fmt_CDPBCY, l_CDPBCY, ln_CDPBCY, 
     :              CDPBCY, TRACEHEADER ) 

c check to see if DphInd is defined for this output trace yet,
c if not keep reading it

               if ( DphInd .eq. 999999 .or. DphInd .le. 0 ) 
     :              call saver2 (itr, fmt_DphInd, l_DphInd, ln_DphInd, 
     :              DphInd, TRACEHEADER ) 

c check to see if SrcPnt is defined for this output trace yet,
c if not keep reading it (this is source point over depth index)

               if ( SrcPnt .eq. 999999 ) 
     :              call saver2 (itr, fmt_SrcPnt, l_SrcPnt, ln_SrcPnt, 
     :              SrcPnt, TRACEHEADER ) 

c if this is trace with nearest offset then save VPick1 for latter
c on mute and VPick2 for latter off mute restore on the stack.  Also
c recover TVPT21 for later datum restoration using arcsdatum.  This was
c requested by Steve Harris.

               call saver2 (itr, fmt_DstSgn, l_DstSgn, ln_DstSgn,  
     :              DstSgn, TRACEHEADER )

               if ( iabs(DstSgn) .lt. LastDstSgn ) then
                  call saver2 (itr, fmt_VPick1, l_VPick1, 
     :                 ln_VPick1, VPick1, TRACEHEADER )
                  call saver2 (itr, fmt_VPick2, l_VPick2, 
     :                 ln_VPick2, VPick2, TRACEHEADER )
                  call saver2 (itr, fmt_TVPT21, l_TVPT21, 
     :                 ln_TVPT21, TVPT21, TRACEHEADER )
                  LastDstSgn = iabs(DstSgn)
               endif

            endif

            if ( phase ) then

c keep the rectangular coordinate of the vector summation in [X,Y] and when finished
c convert back to polar  coordinates.  Put out the angle of the vector [in degrees]
c to the output trace sample.  Do NOT normalize or divide by exponent or any of that
c stuff for this option.  The phase input is to be between 180 and -180 which is 
c west.  East is zero, north is 90 and south is -90.

               if ( StaCor .ne. 30000 ) then
                  call vmov ( itr(ITHWP1), 1, tri(1), 1, nsamp)
                  call vector_sum (tri, nsamp, X, Y)
               else
                  NumDeadTraces = NumDeadTraces + 1
               endif

            else

               call vmov ( itr(ITHWP1), 1, tri(1), 1, nsamp)
               call vadd ( SumTrace, 1, tri, 1, SumTrace, 1, nsamp )
            endif

            call LiveSamples ( tri, FoldTrace, nsamp )

 99      CONTINUE

c skip to end of record 

         call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)

c check for dead record and set StaCor accordingly

         if ( .not. phase ) then
            
            call dotpr ( FoldTrace, 1, FoldTrace, 1, Dot, nsamp )
         
            if ( Dot .lt. 1.e-30 ) then
               StaCor = 30000
            else
               StaCor = 0
            endif
         else
            if ( NumDeadTraces .eq. ntrc ) StaCor = 30000
         endif

c load output header with StaCor, DphInd, LinInd, CDPBCX, CDPBCY, 
c LastDstSgn, SrcPnt, VPick1, VPick2, TVPT21, SrRcMX and SrRcMY, GrpElv

c if the input record is dead then output whatever was in the last
c itr along with a 30000 in StaCor

         
         if ( StaCor .ne. 30000 ) then

            call savew2 ( itr, fmt_SrRcMX, l_SrRcMX, ln_SrRcMX, 
     :           SrRcMX, TRACEHEADER )
            call savew2 ( itr, fmt_SrRcMY, l_SrRcMY, ln_SrRcMY, 
     :           SrRcMY, TRACEHEADER )
            call savew2 ( itr, fmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )
            call savew2 ( itr, fmt_DphInd, l_DphInd, ln_DphInd, 
     :           DphInd, TRACEHEADER )
            call savew2 ( itr, fmt_LinInd, l_LinInd, ln_LinInd, 
     :           LinInd, TRACEHEADER )
            call savew2 ( itr, fmt_CDPBCX, l_CDPBCX, ln_CDPBCX, 
     :           CDPBCX, TRACEHEADER )
            call savew2 ( itr, fmt_CDPBCY, l_CDPBCY, ln_CDPBCY, 
     :           CDPBCY, TRACEHEADER )
            call savew2 ( itr, fmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           LastDstSgn, TRACEHEADER )
            call savew2 ( itr, fmt_SrcPnt, l_SrcPnt, ln_SrcPnt, 
     :           SrcPnt, TRACEHEADER )
            call savew2 ( itr, fmt_VPick1, l_VPick1, ln_VPick1, 
     :           VPick1, TRACEHEADER )
            call savew2 ( itr, fmt_VPick2, l_VPick2, ln_VPick2, 
     :           VPick2, TRACEHEADER )
            call savew2 ( itr, fmt_TVPT21, l_TVPT21, ln_TVPT21, 
     :           TVPT21, TRACEHEADER )
            call savew2 ( itr, fmt_GrpElv, l_GrpElv, ln_GrpElv,
     :           GrpElv, TRACEHEADER )

         else

            call savew2 ( itr, fmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

         endif

         if ( abs(Denominator_Exponent) .lt. 1.e-30 .and. 
     :        .not. phase ) then 

c weight stack by number of live samples

            call vdivz ( SumTrace, 1, FoldTrace, 1, 0, tri, 1, 
     :           nsamp)

         elseif ( .not. phase ) then
            
c weight stack by number of live samples raised to an exponent supplied
c on the command line

            call vclr ( ExponentTrace, 1, nsamp )
            do i = 1, nsamp
               ExponentTrace(i) = FoldTrace(i) ** Denominator_Exponent
            enddo
            call vdivz ( SumTrace, 1, ExponentTrace, 1, 0, tri, 1, 
     :           nsamp)

         elseif ( phase ) then

            if ( StaCor .ne. 30000 ) then
               call rec2pol(tri, X, Y, nsamp)
            else
               call vclr ( tri, 1, nsamp )
            endif
         endif

c write output trace 

         call vmov ( tri(ist), 1, itr(ITHWP1), 1, nsampo)

         call wrtape ( luout, itr, obytes )

         if ( foldtap .ne. ' ' ) then
            call vclr ( itr(ITHWP1), 1, nsamp)
            call vmov ( FoldTrace(ist), 1, itr(ITHWP1), 1, 
     :           nsampo)
            call wrtape ( lufold, itr, obytes )
         endif
         
 100  CONTINUE

 999  continue

      call lbclos(luin)
      call lbclos(luout)
      if ( foldtap .ne. ' ' ) call lbclos(lufold)
        
      stop
      end
