C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rec2pol( tri, X, Y, nsamp )

      integer nsamp

      real tri(nsamp), X(nsamp), Y(nsamp)

c declare local variables

      real rad2deg

      rad2deg = 57.29578 

      do i = 1, nsamp

c RECTANGULAR -> POLAR 

c quadrant one

         IF( X(i) .ge. 0. .and. Y(i) .ge. 0. ) then
            
            if ( abs(Y(i)) .lt. 1.e-31 ) then
               tri(i) = 0.0
            else
               tri(i) = atan( Y(i) / X(i) ) * rad2deg
            endif

c quadrant two

         ELSEIF ( X(i) .gt. 0. .and. Y(i) .lt. 0. ) then
      
            tri(i) = 0. - atan( abs( Y(i) ) / X(i) ) * rad2deg

c quadrant three

         ELSEIF ( X(i) .lt. 0. .and. Y(i) .lt. 0.) then

            tri(i)= -90.0 - atan( abs( X(i) ) / abs( Y(i) )) * rad2deg

c quadrant four
                     
         ELSEIF ( X(i) .lt. 0. .and. Y(i) .gt. 0. ) then

            tri(i) = 90 + atan( abs(X(i)) / Y(i) ) * rad2deg

         ENDIF

      enddo

      return
      end


