C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine vector_sum (tri, nsamp, X, Y)

      integer nsamp

      real tri(nsamp), X(nsamp), Y(nsamp)

c declare local variables

      real deg2rad

      deg2rad = 0.017453293

c quadrant dependant summation
c
c  zero degrees is east, 90 is north, -90 is  south and 180/-180 is west
c

      do i = 1, nsamp    
         
         if ( tri(i) .ge. 0.0 .and. tri(i) .le. 90. ) then

c quadrant 1

            X(i) = X(i) + cos ( tri(i) * deg2rad )
            Y(i) = Y(i) + sin ( tri(i) * deg2rad )

         elseif ( tri(i) .gt. 90. .and. tri(i) .le. 180. ) then

c quadrant 4

            X(i) = X(i) - sin ( (180. - tri(i)) * deg2rad )
            Y(i) = Y(i) + cos ( (180. - tri(i)) * deg2rad )

         elseif ( tri(i) .lt. 0.0 .and. tri(i) .ge. -90. ) then

c quadrant 2

            X(i) = X(i) + cos ( abs(tri(i)) * deg2rad )
            Y(i) = Y(i) - sin ( abs(tri(i)) * deg2rad )

         elseif ( tri(i) .lt. -90. .and. tri(i) .ge. -180. ) then

c quadrant 3

            X(i) = X(i) - sin ( abs (90. + tri(i)) * deg2rad )
            Y(i) = Y(i) - cos ( abs (90. + tri(i)) * deg2rad )

         endif
      enddo

      return
      end

      
