C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c reads in common group  records (with reduced travel times and windowed 
c	to include only first breaks)
c arranges traces in ascending shot or cdp order.
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      integer * 2 itr ( SZLNHD ),itrh(SZLNHD),itrhs(SZLNHD)
      integer     lhed( 1500 ), icount(9999)
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     nblock, jtr, nsampo, itwd, iwd, pad
 
c------
c  dynamic memory allocation for big arrays, eg whole records
      real        bigar1
      pointer     (wkadr1, bigar1(1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     static
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      real        tri ( SZSMPM ), dum (SZSMPM)
      character   ntap * 100, otap * 100, name*2
      logical     verbos, query, heap1, cdp
      integer     argis
 
c-----
c    we acces the floating point data through an equivalence statement
c    that starts the reals at 1/2-word 129
c-----
      equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
      equivalence ( itr(  1), itrh(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'QC'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ist,iend,pad,iblank,cdp, verbos)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'QC  : no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain parameters
 
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
 
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      if (iend .eq. 0 ) iend = nsamp*nsi
      itwd = iend - ist
      iwd  = itwd/nsi
c     nblock = nsi * nsamp / (itwd + pad)
 
c     if (nblock .lt. 2) then
c        write(LERR,*)'Window time must be < 1/2 input trace length'
c        write(LERR,*)'Check input GIs to estimate window around 1st'
c        write(LERR,*)'breaks which will accomplish this'
c        write(LERR,*)'Re-run with new cmd line args'
c        stop
c     endif
 
      ist  = ist/nsi
      iend = iend/nsi
      pad  = pad/nsi
      if (ist .lt. 1) ist = 1
      nsampo = (iwd + pad)   
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 2, LERR)
 
 
c---------------------------------------------------
c  malloc only space we're going to use
      heap1 = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      item1 = (ntrc + iblank) * nsampo * SZSMPD
 
	if ( ( (ntrc + iblank) * nsampo ) .gt. 8192) then
		write (LERR,*) 'Program aborted' 
                write (LERR,*) ' due to #samples > 8192'
		go to 999
	endif
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 1  (allocation succeeded)
c     errcod = 0  (allocation failed)
c--------
 
      call galloc (wkadr1, item1, errcd1, abort1)
 
      if (errcd1 .ne. 0.) heap1 = .false.
 
      if (.not. heap1) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
 
 
c-----
c     modify line header to reflect actual number of samples output
c-----
c     xtr = nrec/nblock
	total = nrec*ntrc
	xtr = total/real(ntrc+iblank)
	jtr = xtr + .9999
      call savew(itr, 'NumRec', jtr  , LINHED)
      call savew(itr, 'NumTrc', 1    , LINHED)
      call savew(itr, 'NumSmp',nsampo*(ntrc+iblank), LINHED)
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsampo*(ntrc+iblank) * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout                 )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  pad,nblock,ist,iend,ntap,otap)
      end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      if (nsi .le. 32) then
         dt = real (nsi) /1000.
      else
         dt = real (nsi) /1000000.
      endif
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
 
c-----
c     process desired trace records
c-----
	ijk = 0
	kk = 0
	call vclr(icount,1,9999)
      do 1000 jj = 1, nrec*ntrc
	kk = kk + 1
        nbytes = 0
        call rtape( luin, itr, nbytes)
        if(nbytes .eq. 0) then
            write(LERR,*)'End of file on input:'
            write(LERR,*)'  rec= ',jj,'  trace= ',kk
            go to 999 
        endif
        If (cdp) then
            call saver (itr,'DphInd', isi, TRCHED)
	else
	    call saver (itr,'PrRcNm', isi, TRCHED)
	endif
	if (jj .eq. 1) is0 = isi
            call saver (itr,'StaCor', static, TRCHED)
c----------------------
c  pack data into array OR write out, then pack into array as 1st element
        if (static .ne. 30000) then
		icheck = abs(isi-is0)
		iskip = mod(icheck,ntrc+iblank)
		istrc = iskip*nsampo
c	write(LERR,*)'PRI',isi,'iskip',iskip,'GI',itr(118),'isi',isi,
c    *		'k=',kk
		if (icount(isi).eq.0) then
                  icount(isi)=1
                  call vmov (tri(ist),1, bigar1(istrc+1),1,iwd)
		else
                  call vmov (tri(ist),1,dum(1),1,iwd )
                  call move (1,itrhs,itr,SZTRHD)
                  call move(1,itr,itrh,SZTRHD)
                  ijk = ijk + 1
c                  write(LERR,*)'Rec(top loop) =',ijk
                  call savew(itr,'RecNum',ijk,TRCHED)
                  call savew(itr,'TrcNum',1  ,TRCHED)
                  call vmov (bigar1(1),1,tri,1,nsampo*(ntrc+iblank))
                  call wrtape (luout, itr, obytes)
                  call vclr (bigar1, 1,(ntrc + iblank)* nsampo)
                  call vmov (dum,1, bigar1(istrc+1),1,iwd)
                  call move (1,itrh,itrhs,SZTRHD)
                  isave = icount(isi)
                  call vclr(icount,1,9999)
                  icount(isi)= isave
                  kk = 1
                  go to 1000
		endif
        endif
 
 
c---------------------
c  extract traces from
c  output array and
c  write output data
	if (kk .eq. (ntrc+iblank) .or. jj .eq. (nrec*ntrc)) then
		call move(1,itr,itrh,SZTRHD)
		ijk = ijk + 1
c		write(LERR,*)'Rec (from bottom loop)=',ijk
		call move(1,itr,itrh,SZTRHD)
		call savew(itr,'RecNum',ijk,TRCHED)
		call savew(itr,'TrcNum',1  ,TRCHED)
        	call vmov (bigar1(1),1,tri,1,nsampo*(ntrc+iblank))
        	call wrtape (luout, itr, obytes)
		call vclr (bigar1, 1,(ntrc + iblank)* nsampo)
		call vclr(icount,1,9999)
		kk = 0
	endif
 1000       continue
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
            write(LERR,*)'end of qc  , processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'qc   does dark and terrible things to seismic data:'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute qc   by typing qc   and the of program parameters'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)        : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)        : output data file name'
        write(LER,*)
     :' -s[ist]      (default = none)    : start window time (ms)'
        write(LER,*)
     :' -e[iend]     (default = none)    : end window time (ms)'
        write(LER,*)
     :' -p[pad]      (default =  0ms)    : zero pad for window'
        write(LER,*)
     :' -b[iblank]   (default = 1   )    : add iblank swaths to plot'
        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   qc   -N[ntap] -O[otap] -s[ist] -e[iend] -p[pad] -V'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ist, iend, pad, iblank,cdp, verbos)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     ist   - I*4      starting time
c     iend  - I*4      ending time
c     pad   - I*4      zero pad time
c     iblank- I*4      pad by iblank strips
c     verbos  L        verbose output or not
c     cdp     L        cdp output(default = shot output)
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     ist, iend, pad
      logical     verbos,cdp
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program qc   might be invoked in the following way:
 
c     qc    -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into farr and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-s', ist ,    0  ,  0    )
            call argi4 ( '-e', iend ,   0  ,  0    )
            call argi4 ( '-p', pad  ,   0  ,  0    )
            call argi4 ( '-b', iblank  ,   1  ,  1    )
		if (iblank .lt. 0 ) iblank = 1
            verbos =   (argis('-V') .gt. 0)
            cdp    =   (argis('-D') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  pad,nblock,ist,iend,ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     ist   - I*4      starting time
c     iend  - I*4      ending time
c   nblock  - I*4      number of recs stacked into 1
c     pad   - I*4      zero pad time
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, ist, iend, nblock, pad
      character   ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' start window (smps)=  ',ist
            write(LERR,*) ' end window (smps)  =  ',iend
            write(LERR,*) ' number vert recs   =  ',nblock
            write(LERR,*) ' Farr window 0-pad  =  ',pad
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
