C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine qdsub(itr,xtr,itrh,fs,ft,lfshalf,lfthalf,
     1                 work,works,workt,mutezn,nsampo,ntrc,
     2                 luin,luout,obytes,
     3                 dip,eof,irec,ist,iend,ns,ne,ntrcc,
     4                 wb,vw,nsi,
     5                 ifmt_WDepDP,l_WDepDP,ln_WDepDP,
     6                 ifmt_StaCor,l_StaCor,ln_StaCor,
     6                 TRACEHEADER)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
      
      INTEGER     ITR (SZLNHD)
      INTEGER     itrh(ITRWRD,ntrc)
      integer     obytes, ns, ne, TRACEHEADER
      INTEGER     mutezn (ntrc)

      REAL        xtr(SZLNHD)
      real        fs(-lfshalf:lfshalf)
      real        ft(-lfthalf:lfthalf)
      real        work(nsampo,ntrcc)
      real        works(nsampo,ntrcc)
      real        workt(1-lfthalf:nsampo+lfthalf,ntrcc)

      logical     eof

c----------------------
c  read record & store
c----------------------
      wgt1=.5
      wgt2=.5*dip
      eof=.false.
      ic = 0
c------------------------
c  pass first part of rec
      nbytes = obytes
      call trcrw (irec, 1, ns-1, luin, ntrc, itr, luout, nbytes)
      if (nbytes  .eq. 0) then
         eof = .true.
         return
      endif
c
      sumzw=0.
      nlive=0

      DO 10000 itrace = ns, ne
         nbytes = 0
         CALL RTAPE  ( LUIN , ITR, NBYTES         )
         if(nbytes .eq. 0) then
            write(LERR,*)'End of file on input:'
            write(LERR,*)'  rec= ',irec,'  trace= ',itrace
            eof=.true.
            return
         endif
         ic = ic + 1
         call vmov(itr(ITHWP1), 1, xtr, 1, nsampo)

         do  ii = 1, nsampo

c            work(ii,itrace) = xtr (ii)

c this fails if loading up second bit of record only so changed 
c to following to keep data loading in declared memory

            work(ii,itrace - ns + 1) = xtr (ii)
         enddo

c-------------------
c  save tr headers
c-------------------
         call move (1, itrh(1,ic), itr, ITRWRD*SZSMPD)

c-------------------
c  detect early mute
c-------------------
         call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1        istatic, TRACEHEADER)

         if(istatic .ne. 30000) then
            call earlym(xtr(1), nsampo, ic, mutezn, 0)
            if(wb .ne. 0.) then
c___________________________________________________________________
c            accumulate water bottom depths.                             
c___________________________________________________________________

               call saver2(itr,ifmt_WDepDP,l_WDepDP, ln_WDepDP,
     1              izw    , TRACEHEADER)
               zw = izw
               sumzw=sumzw+zw
               nlive=nlive+1
            endif
         endif   
10000 CONTINUE

      if(wb .ne. 0. .and. nlive .ne. 0) then
c___________________________________________________________________
c        calculate start time of filter as function of water bottom
c___________________________________________________________________
         zwavg=sumzw/nlive
         tstart=2.*wb*zwavg/vw
         ist=1000.*tstart/nsi 
      endif
c-------------------
c     spatial hilbert transform for the interior traces.
c-------------------
      CALL vclr(works,1,ntrcc*nsampo)    

      DO 13000 itrace=1,ntrcc
         DO 12000 j=-lfshalf,lfshalf,2
            ktrace=itrace+j
            if(ktrace .ge. 1 .and. ktrace .le. ntrc) then
               do 11000 isamp=1,nsampo
                  works(isamp,ktrace)=works(isamp,ktrace)
     1                 +work(isamp,itrace)*fs(j)
11000          continue
            endif
12000    continue
13000 continue

c-----------------------------------------
c     clear buffer.
c     for efficiency (vectorization) and cleanliness of coding,
c     output array workt is padded on both ends by lfthalf samples.
c-----------------------------------------
      lent=nsampo+2*lfthalf
      CALL vclr(workt,1,ntrcc*lent)    
c-----------------------------------------
c     do temporal hilbert & write to output
c-----------------------------------------
      DO 30000  itrace = 1, ntrcc
         DO 22000 isamp=1,nsampo                
            DO 21000 j=-lfthalf,lfthalf,2
               ksamp=isamp+j
               workt(ksamp,itrace)=workt(ksamp,itrace)
     1              +works(isamp,itrace)*ft(j)
21000       continue
22000    continue
c-----------------------------------------
c     copy original data in zone before filter begins.      
c-----------------------------------------
         do 23000 isamp=1,ist-1
            xtr(isamp)=work(isamp,itrace)
23000    continue
c-----------------------------------------
c     copy in filtered data.                                       
c-----------------------------------------
         do 24000 isamp=ist,iend  
            xtr(isamp) = wgt1*work(isamp,itrace)
     1           +wgt2*workt(isamp,itrace)
24000    continue
c-----------------------------------------
c     copy original data in zone after filter ends.         
c-----------------------------------------
         do 25000 isamp=iend+1,nsampo
            xtr(isamp)=work(isamp,itrace)
25000    continue
c--------------------
c  get back headers
c--------------------
         call vmov (itrh (1, itrace), 1, itr, 1, ITRWRD)

         call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1        istatic, TRACEHEADER)

         if(istatic .eq. 30000) then
c--------------------------
c         kill dead trace samples
c--------------------------
            do  ii = 1, nsampo
               xtr (ii) = 0.
            enddo
         else
c--------------------------
c         otherwise preserve early mute
c--------------------------
            call earlym (xtr, nsampo, itrace, mutezn, 1)
         endif
c--------------------------
         call vmov (xtr, 1, itr(ITHWP1), 1, nsampo)
         CALL WRTAPE(LUOUT,ITR,OBYTES)
30000 CONTINUE

c------------------------
c  pass remainder of rec
      nbytes = obytes
      call trcrw (irec, ne+1, ntrc, luin, ntrc, itr, luout, nbytes)
      if (nbytes  .eq. 0) then
         eof = .true.
         return
      endif


c
      return
      end
