      subroutine gcmdln ( ntap, otap, cardin, verbos,lucrd,crd,
     1                    qtap, qtape, dorec,stk,rmute,qnull,qmin,scale,
     2                    smh, noscl,itype,lw,ampscl,phz)
c     Modified by R. L. Crider 4-27-90
c
c     this routine processes the command line arguments for use in
c     program QIFL on SUN.
c
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      character ntap*256, otap*256, cardin*256
      character qtap*256
      logical   verbos, there, crd, qtape, stk, d3, threed, rmute
      logical   dorec, noscl,phz
      integer   argis, smh, itype, lw
      real      qnull, qmin, scale
 
      verbos = .false.
      noscl  = .false.
      phz    = .false.
 
      stk    = .true.
      dorec  = (argis('-rec') .gt. 0)
      if ( dorec ) stk = .false.
      d3     = (argis('-threed') .gt. 0)
      if (threed) stk = .true.
      noscl  = (argis('-noscl') .gt. 0)
      phz    = (argis('-phz') .gt. 0)

      verbos = (argis('-V') .gt. 0)
      qtape  = (argis('-Q') .gt. 0)
      crd    = (argis('-C') .gt. 0)
      rmute  = (argis('-R') .gt. 0)

      call argstr ('-N',ntap,' ',' ')
      call argstr ('-O',otap,' ',' ')
      call argstr ('-D',cardin,' ',' ')
      call argr4 ('-null', qnull, 500.0, 500.)
      call argr4 ('-qmin', qmin, 20.0, 20.0)
      call argr4 ('-scl', scale, 1.0, 1.0)
      call argi4 ('-sm', smh, 0, 0)
      call argi4 ('-sc', itype, 0, 0)
      call argi4 ('-lw', lw, 1000, 1000)
      call argr4 ('-s', ampscl, 15.0, 15.0)

      write(LERR,*)''
      write(LERR,*)'Defaults from cmd line:'
      write(LERR,*)'Record oriented processing  = ',dorec
      write(LERR,*)'Stack oriented processing   = ',stk
      write(LERR,*)'3D stack data               = ',d3
      write(LERR,*)'USP format Q input          = ',qtape
      write(LERR,*)'Q asci file Q input         = ',crd
      write(LERR,*)'Restore mute                = ',rmute
      write(LERR,*)''
      write(LERR,*)'Null Q value                = ',qnull
      write(LERR,*)'Minimum Q value             = ',qmin
      write(LERR,*)'Turn gain off               = ',noscl
      write(LERR,*)'Smoothing order for gain    = ',smh
      write(LERR,*)'Type of gain                = ',itype
      write(LERR,*)'0 = ratio of envelope;  1 = ratio of agc'
      write(LERR,*)'agc gain window             = ',lw
      write(LERR,*)'agc % 2047                  = ',ampscl
      write(LERR,*)''
      write(LERR,*)''
      ampscl = 20.47 * ampscl

      call argstr ('-qt',qtap,' ',' ')

      ikp = in_ikp()

c     if (.not.qtape .AND. ikp .eq. 1) then
c        if (cardin(1:1) .eq. ' ') then
c           write(LERR,*)'FATAL ERROR in qifl:'
c           write(LERR,*)'Must supply a QTIM card file using -D[]'
c           stop 666
c        endif
c     endif

      if(cardin.ne. ' ') then
	    inquire(file = cardin, exist = there)
	    if(.not.there)then
	         write(LERR, '(3a)')'   File ',cardin,' not found.'
		 call ccexit (100)
		endif
            open(unit=lucrd, file=cardin, status='old',
     :           form='formatted',access='sequential')
            rewind (lucrd)
      endif

      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       POWER2                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      POWER2  (NSMP,N,NN,LUP,IER)                                     *
C  ARGUMENTS:                                                          *
C      NSMP    INTEGER  ??IOU* -                                       *
C      N       INTEGER  ??IOU* -                                       *
C      NN      INTEGER  ??IOU* -                                       *
C      LUP     INTEGER  ??IOU* -                                       *
C      IER     INTEGER  ??IOU* -                                       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/08/05  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/08/05  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine power2(nsmp,n,nn,lup,ier)
      n = 64
  100 n = n + n
      if (n.lt.nsmp)go to 100
	  nn = n/2+1
	  return
	  end
