C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine bdsub(y,dt,nsamp,x,v2,v4,remove,z,top,bot,rnum,XY,luXY,
     :     t)
c
c Author>Ilya Tsvankin (TRC:X4306)


#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c ----7--0---5--------------------------------------------------------72
c       Arguments 
c
c      y = data trace
c      v2 = velocity trace (velocity vs sample)
c     dt = sample interval
c  nsamp = number samples/trace
c      x = distance
c    v4 = v4 trace (v4 vs sample)
c remove = if true to 'unmormal movelout'
c      z = working array
c    top = use top nmo map
c    bot = use bot nmo map
c   rnum = random number array used to fill out zero data
c     XY = flag for xgraph output
c   luXY = logical unit for output of tvdnmo_fcn data
c
c----------------------------------------------------------------

      integer nsamp,cros_ndx,icount,j,cros_ndx2,start_index
      integer luXY
      real y(*), v2(*), v4(*), z(*), rnum(*),t(*)
      real workx(2*SZSMPM),worky(2*SZSMPM)
      real y2(2*SZSMPM),ypn,yp1,yj
      real x,dt,xv2i,xt,tnmo
      real rj
      logical remove,top,bot,XY 

c----------------------------------------------------------------
c      Additional Variables
c
c    cros_ndx = sample value at velocity cross-over
c    icount   = active sample counter
c    inewcnt  = new active sample counter
c    j,k      = index variables
c    workx    = working array of times (tnmo or 1...nsamp)
c    worky    = working array of tnmo or amp (forward or back)
c    t        = array of floating point samples
c    y2       = array of second derivatives
c    ypn      = second derivative at nsamp
c    yp1      = second derivative at 1st sample
c    yj       = interpolated value from splint subroutine
c    rj       = floating point index used as arg to splint
c    rad      = degree to radian conversion factor
c    xt       = distance/sample interval
c    xvi      = xt/velocity
c    tnmo     = floating point sample required for nmo
c    temp1    = working variable for sort algorithm
c    temp2    = working variable for sort algorithm
c
c----------------------------------------------------------------

c
c ----- initialization of variables ----- 
c

      if(remove)call vclr(workx,1,nsamp)

      DO i=1,nsamp

        z(i) = 0.
        worky(i) = 0.

c
c ----- the spline routine hates consecutive zeros in the trace data -----
c       this logic replaces zeros with very small random numbers so 
c       that ieee errors of underflow are not encountered in spline

        if(y(i).lt.1.e-30)then
            y(i)=y(i)+rnum(i)
        endif

c ----- ----- -----

      ENDDO


c ----- use natural cubic spline -----
c see Numerical Recipes pp.88
c second derivative will be zero  on each boundary
c

      yp1 = 1.e+31
      ypn = 1.e+31

c
c ----- reduce x by delta t which causes time to be calculated when loops
c       incremented by samples
c

        xt = x/dt
c
c ----- reset the tnmo function element counter -----
c

      icount = 0

c
c ----- reset the cross-over index to zero -----
c

      cros_ndx = 0
      cros_ndx2 = 0
      start_index = 0

c
c ----- body of trace -----
c
      DO 1000 i = 1,nsamp

            xv2i = xt/( v2(i) )
            if(v2(i).lt.1.e-29)v2(i) = 1.e5 
            if(v4(i).lt.1.e-29)v4(i) = 1.e6
            t0dt = float(i-1)
            if((i-1).lt.1)t0dt = 0.1
            tanem =  t0dt**2 + xv2i**2 - 
     :                    (xt/v4(i))**4/t0dt**2
            if(tanem.lt.0.)tanem=1.e-19
            tnmo =  sqrt (tanem)+1.

            j= tnmo

c
c ----- check for bounds -----
c
          if (j .ge. 1 .and. j .le. (nsamp-1)) then
c
c ----- if it does then flag which output sample this occured at -----
c       This is the start of the map for this trace as shown above
c

            if(start_index.eq.0)start_index = i

c
c ----- REVERSE NMO MAP -----
c

            IF (remove) then 
              
               workx(i) = tnmo
               worky(i) = y(i)

c
c ----- keep track of number of entries in tnmo table -----
c       This will prevent zeros at the start of the function
c       which kills the spline interpolator
c
               icount = icount + 1
c
c ----- output i,tnmo data for qc -----
c       remove for production version
c

               if(XY)then
                 write(luXY,6666)float(i),workx(i)
               endif

           ELSE

c
c ----- FORWARD NMO MAP -----
c

               workx(i) = float(i) 
               worky(i) = tnmo
               icount = icount + 1
c
c ----- output i,tnmo data for qc -----
c       remove for production version
c
               if(XY) then
                  write(luXY,6666)workx(i),worky(i)
 6666             format(f10.4,1x,f10.4)
               endif

            ENDIF

         endif

 1000 CONTINUE

c
c ----- CROSS-OVER DETERMINATION -----
c

c
c ----- examine tnmo from sample nsamp to sample 1 -----
c       looking for cross-over point.  Tag that point.
c       The following is expensive in terms of number of
c       lines of code, however, it runs faster.  When
c       removing nmo search workx(), when applying nmo
c       search worky().
c

      IF(remove)then

         DO j=icount+start_index-1,start_index+1,-1

            if(cros_ndx.eq.0)then

               if(workx(j).lt.workx(j-1))then

                  cros_ndx = j

               endif

            else

               if(workx(j).gt.workx(j-1))then

                  cros_ndx2 = j
                  goto 2500

               endif

            endif

         ENDDO

      ENDIF

      IF(.not.remove) then

         DO j = start_index+icount-1,start_index+1,-1

            if(cros_ndx.eq.0) then

               if(worky(j).lt.worky(j-1))then

                  cros_ndx = j

               endif

            else
            
               if(worky(j).gt.worky(j-1).and.worky(j-1).gt.1.e-8)then

                  cros_ndx2 = j
                  goto 2500

               endif

            endif

         ENDDO

      ENDIF

c
c ----- if removing nmo and using only the bottom of the -----
c       nmo map then the number of entries in the nmo map
c       will be the total number (icount) minus the number
c       of samples before the cross-over (cros_ndx-start_index)
c

 2500 if(remove.and.bot.and.cros_ndx.ne.0)
     :     icount=icount-(cros_ndx-start_index) 

c
c ----- when removing nmo using the top of the nmo map -----
c       this routine will only recover data above the 
c       first cross-over point (cros_ndx) if it exists and
c       below the second (cros_ndx2).  To do more would
c       be non-linear and force me to decide which moved
c       out sample should be honoured (Canadian spelling)
c       at the single output sample location.  Obviously
c       this is an ongoing struggle in the world of nmo and
c       may end up being handled by some type of curve fitting
c       to the nmo map to smooth out the cross-overs (first
c       contemplated by the Hon. Paul Gutowski).  For now though
c       what you see is what you get.
c
  
      if(cros_ndx2.eq.0)cros_ndx2 = 2

c
c ----- when removing nmo using the top option, if there is -----
c       no cross-over (ie:cros_ndx = 0) then there is no data
c       associated with the top of the map for this offset.
c       In this case return a zero trace, otherwise reset 
c       icount to be the cross-over point as we are not interested
c       in any data from beyond that point.
c

      if(top) then

         if(cros_ndx.lt.1)return
         icount = cros_ndx

      endif

c
c ----- if forward and bot and no cross-over then set cros_ndx to 1 ----
c       This stops workx(cros_ndx)from being workx(0) which is
c       undefined in this routine.
c

      if(.not.remove.and.bot.and.cros_ndx.lt.1)cros_ndx=1

c
c ----- if bot then move data from below cross-over to top of array -----
c       again to prevent zero values from corrupting the second 
c       derivative calculation used in the spline interpolator, 
c       else just continue with new icount from above
c

      IF(remove.and.bot)then

         if(cros_ndx.gt.0) then

            DO j=1,icount

               workx(j) = workx(cros_ndx + j - 1)
               worky(j) = worky(cros_ndx + j - 1)
c
c ----- if 2 consecutive sample indices are equal the second derivative  -----
c       calculation packs it in with a zero divide.. the following code
c       covers for the shitty interpolator.  Note only near the 
c       cross-over do values attempt this miraculous feat
c

               if(j.gt.1)then

                  if(abs(workx(j)-workx(j-1)).lt.1.e-3)then

                     workx(j)=workx(j)+1.e-3

                  endif

               endif

            ENDDO

         endif

      ELSEIF(remove.and..not.bot)then

         DO j=1,icount-start_index+1

            if(cros_ndx.gt.0) then

               workx(j) = workx(start_index + j - 1)
               worky(j) = worky(start_index + j - 1)

            endif

         ENDDO

         icount = icount - start_index + 1

      ENDIF

c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c      REMOVE OPTION
c
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      IF(remove) then

c
c ----- interpolate new output trace -----
c

         if(.not.bot) then

c
c ----- sort tnmo,amplitude arrays -----
c

            call sort(icount,workx,worky)

         endif

c
c ----- if 2 consecutive sample indices are equal the second derivative  -----
c       calculation packs it in with a zero divide.. the following code
c       covers for the shitty interpolator.  Note only near the 
c       cross-over do values attempt this miraculous feat
c

         DO j=icount,2,-1

            if(abs(workx(j)-workx(j-1)).lt.1.e-3)workx(j)=workx(j)+1.e-3

         ENDDO

c
c ----- if cross-over occurs within 4 samples of the bottom of -----
c       the trace then just zero the trace and call it a day.
c       The cubic spline second derivative calculations don't work
c       with less than 4 samples.
c

         if(icount.lt.4)then

            write(LERR,*)' less than 4 input samples used in '
            write(LERR,*)' moveout map.  Trace at offset ',x
            write(LERR,*)' will be deleted.'
            write(LERR,*)' '
            return

         endif 

c
c ----- create array of second derivatives (y2) -----
c

         call spline(workx,worky,icount,yp1,ypn,y2)

c
c ----- form output trace -----
c

         DO 5000 j=1,nsamp

            rj=float(j)

            if(bot) then

               if((rj.lt.workx(2)).or.(rj.gt.workx(icount)))then
c
c ----- if j outside the range of data in transfer function  -----
c       set amplitude to zero, if it didn't go forward it can't
c       come back.
c

                  z(j) = 0.

               else
c
c ----- interpolate amplitude at j from tnmo,input amplitude data
c     
                  call splint(workx,worky,y2,icount,rj,yj) 
                  z(j) = yj

               endif

            endif

c
c ----- this next bit handles the top map between cros_ndx2 and cros_ndx -----
c       which icount is now equal to.
c


            if(.not.bot) then

               if((rj.lt.workx(cros_ndx2)).or.(rj.gt.workx(icount)))then


c
c ----- if j outside the range of data in transfer function  -----
c       set amplitude to zero, if it didn't go forward it can't
c       come back.
c

                  z(j) = 0.

               else
c
c ----- interpolate amplitude at j from tnmo,input amplitude data
c
                  call splint(workx,worky,y2,icount,rj,yj)
                  z(j) = yj

               endif

            endif


 5000    CONTINUE  

c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c     FORWARD NMO
c
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      ELSE

c
c ----- if the trace has less than 4 samples then just zero -----
c       the trace and call it a day.  The cubic spline second
c       derivative calculations don't work with less than 4 samples.
c

      if(nsamp.lt.4)then

         write(LERR,*)' less than 4 input samples used in '
         write(LERR,*)' moveout map.  Trace at offset ',x
         write(LERR,*)' will be deleted.'
         write(LERR,*)' '
         return

      endif  

c
c ----- form array of second derivatives -----
c    

      call spline(t,y,nsamp,yp1,ypn,y2)


c
c ----- INTERPOLATE OUTPUT TRACE FOR APPLICATION OF NMO  OPTION -----
c

      DO 6000 j=1,nsamp 

c
c ----- determine if there is an amplitude associated with the current -----
c       output sample.  If not then leave a zero entry, if so then
c       interpolate a value.
c

         if(top)then
            
            if((j.lt.ifix(t(1))).or.(j.gt.ifix(t(cros_ndx))))
     :           goto 6000 

         endif

         if(bot)then

            if((j.lt.ifix(t(cros_ndx))).or.(j.gt.ifix(t(icount+
     :           start_index-1))))goto 6000

         endif

         if(.not.top.and..not.bot)then 

            if((j.lt.ifix(t(1))).or.(j.gt.ifix(t(icount+
     :           start_index-1))))goto 6000

         endif


         call splint(t,y,y2,nsamp,worky(j),yj)

         z(j) = yj
 
 6000 CONTINUE

      ENDIF

c
c nmo routine completed, return to calling routine
c

      XY = .false.
      return
      end
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c
c                         SUBROUTINES
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

c subroutine spline
c
c from Numerical Recipes - Press etal - pp 88
c
      subroutine spline(x,y,n,yp1,ypn,y2)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer n
      real x(*),y(*),y2(*)
      real u(SZSMPM),yp1,ypn
      if(yp1.gt.0.99e+30)then
        y2(1) = 0.
        u(1) = 0.
      else
        y2(1)=-0.5
        u(1)=(3./(x(2)-x(1)))*((y(2)-y(1))/(x(2)-X(1))-yp1)
      endif

      do 11 k= 2,n-1
	sig=(x(k)-x(k-1))/(x(k+1)-x(k-1))
	p=sig*y2(k-1)+2.
	y2(k)=(sig-1.)/p
c
c ----- debug -----
c       rdenom1 = (x(k+1)-x(k))-(y(k)-y(k-1))
c       rdenom2 = (x(k)-x(k-1))
c       rdenom3 = (x(k+1)-x(k-1))-sig*u(k-1)
c       u(k)=(6.*((y(k+1)-y(k))/rdenom1/rdenom2)/rdenom3)/p
c ----- ----- -----
 	u(k)=(6.*((y(k+1)-y(k))/(x(k+1)-x(k))-(y(k)-y(k-1))
     1	     /(x(k)-x(k-1)))/(x(k+1)-x(k-1))-sig*u(k-1))/p
11    continue
      if(ypn.gt.0.99e+30)then
	qn=0.
	un=0.
      else
	qn=0.5
	un=(3./(x(n)-x(n-1)))*(ypn-(y(n)-y(n-1))/(x(n)-x(n-1)))
      endif

      y2(n)=(un-qn*u(n-1))/(qn*y2(n-1)+1.)
      do 12 k=n-1,1,-1
	y2(k)=y2(k)*y2(k+1)+u(k)
12    continue
      return
      end
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c subroutine splint
c
c from Numerical Recipes - Press etal - pp 89
c
      subroutine splint(xa,ya,y2a,n,x,y)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer n
      real xa(*),ya(*),y2a(*)
      real x,y

      klo=1
      khi=n
1	if (khi-klo.gt.1)then
		k=(khi+klo)/2
		if(xa(k).gt.x)then
			khi=k
		else
			klo=k
		endif
	 goto 1
	endif
      h=xa(khi)-xa(klo)
      if(h.eq.0)goto 999
      a=(xa(khi)-x)/h
      b=(x-xa(klo))/h
      y=a*ya(klo)+b*ya(khi)+
     *         ((a**3-a)*y2a(klo)+(b**3-b)*y2a(khi))*(h**2)/6.
      return
999   write (LERR,*)'xa(',klo,') == xa(',khi,') == ',xa(klo) 
      write(LERR,*)' FATAL -- for now'
      stop
      end
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c subroutine sort
c
c from Numerical Recipes - Press etal - pp 231
c
      subroutine sort(n,ra,rb)
      real ra(*),rb(*)
      integer n
       
      l=n/2+1
      ir=n

10    continue
      
        if(l.gt.1)then
          
          l=l-1
          rra=ra(l)
          rrb=rb(l)

        else

          rra=ra(ir)
          rrb=rb(ir) 
          ra(ir)=ra(1)
          rb(ir)=rb(1)
          ir=ir-1
          
          if(ir.eq.1)then

            ra(1)=rra
            rb(1)=rrb
            return

          endif

        endif
      
        i=l
        j=l+l

20      if(j.le.ir)then

          if(j.lt.ir) then

            if(ra(j).lt.ra(j+1))j=j+1

          endif

          if(rra.lt.ra(j))then

            ra(i)=ra(j)
            rb(i)=rb(j)
            i=j
            j=j+j

          else

            j=ir+1

          endif
         
        goto 20
        
        endif
        
       ra(i)=rra
       rb(i)=rrb
      goto10
      end
