C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c horvel reads velspec semblance records, 2 velocity-time
c picks (which define a velocity fairway), and picks made from
c several horizons of a stacked section
c and puts it all together to automatically generate velocity
c functions (velocity tape), and
c writes the results to an output file

c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77

#include <f77/iounit.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      real        head( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     iseg
      integer     irec, itrc
      integer     srcloc, recind, dphind, dstsgn

c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
c     integer     static
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      real        vtr ( SZLNHD )

      real        tf   (SZLNHD)
      real        velf2(SZLNHD)
      real        velf4(SZLNHD)
      real        work1(SZLNHD), jacob(3*SZLNHD)
      real        vout2(SZLNHD)
      real        vout4(SZLNHD)
      real        vlst2(SZLNHD), vnxt2(SZLNHD)
      real        vlst4(SZLNHD), vnxt4(SZLNHD)
      real        recz(SZLNHD), dists(SZLNHD), tz(SZLNHD)
      integer     nseg(SZLNHD), nrecs(SZLNHD)
      character   ntap * 256, otap * 256, name*6
      character   velpik * 256
      logical     verbos, query, first, num
      logical     nmor
      integer     argis,lunvel
 
      equivalence ( itr(  1), lhed(1), head(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'QUEVEL'/, first/.true./
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln (ntap,otap,velpik,lunvel,nmor,maxitr,
     1             verbos,prew)

c-----
c     get logical unit numbers for input and output of seismic data

c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used

c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'QUEVEL: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

c------
c     save certain parameters

c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position

c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


c------
c     hlhprt prints out the historical line header of length lbytes AND

c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 7, LERR)

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap,velpik,prew)
c     end if

      prew = prew / 100.

c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary

      si = nsi
      dt = real (nsi) * unitsc

c--------------------------------------------------
c-----
c     BEGIN PROCESSING

c----
c find number of segments in event pik file:
c----
      num = .true.
      call  pikrd ( nblk, nseg, iunit, iseg,nsi,itrs,itre, nrecs,
     1              nsmp,recpik,recz,dists,tz,num,lunvel,irec,
     2              nrecc, maxpik,xmin,xmax)

      write(LERR,*)' '
      write(LERR,*)'Number of records in picks              = ',nrecc
      write(LERR,*)'Maxumum number of picks in any seg      = ',maxpik
      write(LERR,*)'Number of segs in each record           = ',
     1              (nrecs(i),i=1,nrecc)
      write(LERR,*)'Number traces in                        = ',itrs,
     1              itre
      write(LERR,*)'Max trace value                         =  ',xmax
      write(LERR,*)'Min trace value                         =  ',xmin
      write(LERR,*)'Number horizons picked in stack section = ',nblk
      write(LERR,*)'Segments                                = ',
     1              (nseg(i),i=1,nblk)
      write(LERR,*)' '
      num = .false.

c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)

      call savhlh(itr,lbytes,lbyout)
      call savew(itr, 'NumTrc',  2   , LINHED)
      call savew(itr, 'NumRec', nrec , LINHED)
      obytes = SZTRHD + nsamp * SZSMPD
c----------------------

c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout                 )


c-----
c     read velocity trace, get pick segments at each control location,
c     fit quartic moveout and extract v2 & v4, and write out v2-v4
c     velocity trace pairs (interpolating between control points)
c-----

      ir    = 0
      irec0 = 1
      ireclst = 1

c-----
c   read over all control points along line
c-----
      DO   JJ = 1, nrecc
 
c-----
c   for each control point process all segments with common record
c-----
         nfunc  = nrecs(JJ)
         DO  KK = 1, nfunc

            ir = ir + 1
            iseg = ir
            call  pikrd ( nblk, nseg, iunit, iseg,nsi,itrs,itre, nrecs,
     1                    nsmp,recpik,recz,dists,tz,num,lunvel,irec,
     2                    nrecc,maxpik,xmin,xmax)
            npicks = nseg (ir)
c-----
c     get NMO velocity trace for this control point
c-----
            if (KK .eq. 1) then

                  call recskp ( irec0, irec-1, luin, ntrc, itr)
                  call rtape  ( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (lhed(ITHWP1), 1, vtr, 1, nsamp)

                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        irec0  , TRACEHEADER)
                  call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        itrc   , TRACEHEADER)
                  call saver2(lhed,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                        srcloc , TRACEHEADER)
                  call saver2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                        recind , TRACEHEADER)
                  call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        dphind , TRACEHEADER)
                  call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        dstsgn , TRACEHEADER)
            endif
c-----

c-----
c     if picks made on NMO corrected data put moveout back in
c-----
            if (nmor) then
               call nmocor (tz, dt, npicks, nsamp, dists, vtr)
            endif


c           call maxmgv (dists, 1, xmax, ix, npicks)
            call minmgv (tz, 1, tmin, it, npicks)
            it0   = tmin / si + 1
            
            if (first) then
               v2 = vtr (it0)
               v4 = 4 * vtr (it0)
            endif
         
            write(LERR,*)' '
            write(LERR,*)'Max distance= ',xmax,'  T0= ',tmin
            write(LERR,*)' '
            write(LERR,*)'Pick      distance    time'
            do  i = 1, npicks
                write(LERR,*)'i= ',i,dists(i),tz(i)
            enddo
            write(LERR,*)' '

            call v2v4 (dists, tz, maxpik, npicks, maxitr, work1, jacob,
     1                 t0, v2, v4, xmax, tmin, ierr, prew)
             tf   (kk) = t0
             velf2(kk) = v2
             velf4(kk) = v4

         ENDDO
c-----
c     now have v2(i),i=1,nfunc and v4(i),i=1,nfunc for times tf(i),i=1,nfunc
c     generate v2 & v4 velocity traces for this control point
c-----
         write(LERR,*)' '
         write(LERR,*)'Record =  ',irec,' estimetes: iters, ierr= ',
     1                 maxitr, ierr
         write(LERR,*)'       T0         V2         V4'
         do  i = 1, nfunc
             write(LERR,*)tf(i),velf2(i),velf4(i)
         enddo

         call vel (tf, velf2, nsamp, si, nfunc, vnxt2)
         call vel (tf, velf4, nsamp, si, nfunc, vnxt4)

         write(LERR,*)' '
         write(LERR,*)'V2(t)'
         write(LERR,*)(vnxt2(i),i=1,nsamp)
         write(LERR,*)'V4(t)'
         write(LERR,*)(vnxt4(i),i=1,nsamp)
         write(LERR,*)' '

         IF (first) THEN

            call vmov (vnxt2, 1, vlst2, 1, nsamp)
            call vmov (vnxt4, 1, vlst4, 1, nsamp)

            do  k = 1, irec

                call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                      k      , TRACEHEADER)
                call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                      1      , TRACEHEADER)
                call vmov   (vlst2, 1, lhed(ITHWP1), 1, nsamp)
                call wrtape (luout, itr, obytes)
                call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                      2      , TRACEHEADER)
                call vmov   (vlst4, 1, lhed(ITHWP1), 1, nsamp)
                call wrtape (luout, itr, obytes)
            enddo

         ELSE

            drec = irec - ireclst
            do  k = ireclst+1, irec

                s = float (k - ireclst) / drec           
                do  i = 1, nsamp

                    vout2(i) = vlst2(i) + s * (vnxt2(i) - vlst2(i))
                    vout4(i) = vlst4(i) + s * (vnxt4(i) - vlst4(i))
                enddo

                call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                      k      , TRACEHEADER)
                call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                      1      , TRACEHEADER)
                call vmov   (vout2, 1, lhed(ITHWP1), 1, nsamp)
                call wrtape (luout, itr, obytes)
                call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                      2      , TRACEHEADER)
                call vmov   (vout4, 1, lhed(ITHWP1), 1, nsamp)
                call wrtape (luout, itr, obytes)
            enddo

            call vmov (vnxt2, 1, vlst2, 1, nsamp)
            call vmov (vnxt4, 1, vlst4, 1, nsamp)

         ENDIF

         first = .false.
         ireclst = irec
      ENDDO

      IF (irec .lt. nrec) THEN

          call vmov (vnxt2, 1, vout2, 1, nsamp)
          call vmov (vnxt4, 1, vout4, 1, nsamp)

          do  k = irec+1, nrec

                call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                      k      , TRACEHEADER)
                call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                      1      , TRACEHEADER)
                call vmov   (vout2, 1, lhed(ITHWP1), 1, nsamp)
                call wrtape (luout, itr, obytes)
                call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                      2      , TRACEHEADER)
                call vmov   (vout4, 1, lhed(ITHWP1), 1, nsamp)
                call wrtape (luout, itr, obytes)
          enddo
      ENDIF
         

  999 continue

c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )

            write(LERR,*)'end of quevel, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'quevel shifts seismic records based on interpolated rec/time'
        write(LER,*)
     :'pairs or interpolated picks from an xsd pick file'
        write(LER,*)
     :'see manual pages for details ( online by typing uman quevel )'
        write(LER,*)' '
        write(LER,*)
     :'execute quevel by typing quevel and the program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)    : input NMO velocity tape file name'
        write(LER,*)
     :' -O [otap]    (stdout)   : output velocity tape file name'
        write(LER,*)
     :' -P [velpik]  (none)     : picks defining velocity fairway'
        write(LER,*) ' '
        write(LER,*)
     :' -i [maxitr]    (10)     : maximum number iterations allowed'
        write(LER,*) ' '
        write(LER,*)
     :' -nmo  data picked on NMO corrected data'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   quevel -N[] -O[] -v[] -P[] -i[]'
        write(LER,*)
     :'                 [-L -R -nmo -V]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,velpik,lunvel,nmor,maxitr,
     1                  verbos,prew)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     verbos  L        verbose output or not
c-----
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      character   ntap*(*), otap*(*), velpik*(*)
      logical     verbos, nmor
      integer     argis, lunvel, maxitr
 
      lunvel = 28
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.

c     For example program prgm might be invoked in the following way:

c     prgm  -Nxyz -Oabc

c     in which case xyz is a string (the name of the input data set)
c     which will be imported into prgm and associated with the variable
c     "ntap"

c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-P', velpik, ' ', ' ' )

            call argr4 ('-p', prew  , 1. , 1. )
            call argi4 ('-i', maxitr, 10, 10)

            IF (velpik(1:1) .eq. ' ') THEN

               write(LERR,*)'Must enter event pickfile -- FATAL'
               stop

            ENDIF

            open (unit=lunvel,file=velpik,status='old',iostat=ierr)

            if (ierr .ne. 0) then
               write(LERR,*)'Could not open velpik file ',velpik
               write(LERR,*)'Check existence'
               stop
            endif



            nmor   =   (argis('-nmo') .gt. 0)
            verbos =   (argis('-V') .gt. 0)

c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap,velpik,prew)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>

      integer     nsamp, nsi, ntrc, nrec, iform
      character   ntap*(*), otap*(*), velpik*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' prewhitening       =  ', prew
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
