C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine v2v4 (x, Tm, maxpic, npicks, maxitr, deltaT, Jacob,
     1                 T0, V2, V4, xmax, tmin, ierr, prew)
*
* x - (input) array of x values
* Tm - (input) array of t values
* maxpic - (input) declared size of x and Tm
* npicks - (input) actual number of picks (<= maxpic)
* maxitr - (input) maximum number of iterations before we should give up
* deltaT - (input) workspace (real array of size maxpic)
* Jacob - (input) workspace (real array of size maxpic*3)
* T0 - (output) T0 from the quartic equation
* V2 - (output) V2 from the quatric equation
* V4 - (output) V4 from the quatric equation
* ierr - (output) 0 if ok.  non-0 on error conditions.
*
* Notes: Should probably provide an epsilon argument.  Also may need
*        to provide a way for the user to give a hint about an initial
*        guess for T0, V2, and V4.
*
      integer maxpic, npicks, maxitr, ierr
      real x(maxpic), Tm(maxpic), deltaT(maxpic), Jacob(maxpic,3)
      real T0, V2, V4

      real JtJ(3,3), z(3)
      real xmax, a(3), b(3), eps, prew
      real Tqmfun, Tqm, Jcom, xj2, xj4

      integer iperm(3)
      integer iter, i, j, k, l

      write(0,*)'maxitr= ',maxitr,prew
* No problems yet.
      ierr = 0

* Actual work starts here.

      a(1) = tmin / 1000.

* a(1), a(2), and a(3) represent T0, V2, and V4.  Their relationship is:
*    a(1) = T0 / 1000.
*    a(2) = xmax / V2
*    a(3) = xmax / V4
*
* Set up the remaining a's (initial guess)
* These may need to be fiddled with...
      a(2) = xmax / v2
      a(3) = xmax / v4
*
* I've tried several different values.  Note that a(2)=0 or a(3)=0 will
* never work.  a(1) is set to the smallest Tm.  Other possibilities for
* a(2) and a(3) that have worked at times are:
*    a(2) = 1.0, a(3) = 1.0
*    a(2) = a(1), a(3) = a(1)
*    a(2) = 1.0 / a(1), a(3) = 1.0 / a(1)
*
* What really need to be done is an assessment of the magnitude of the
* numbers to determine where a good starting point it.
*

* Normalize the x(i) picks around xmax.
      do 20 i = 1, npicks
c     write(0,*)'t/x= ',x(i),Tm(i)
         x(i) = x(i) / xmax
        Tm(i) = Tm(i) / 1000.
 20   continue

* Iterative loop.  Don't try more than maxitr times.
      do 100 iter = 1, maxitr
         write(0,*)'********** iteration ',iter,' **********'
         write(0,*)'a(i) = ', a(1), a(2), a(3),a(1)*1000,
     1   xmax/a(2),xmax/a(3)

* Form the Jacobian equations.  The derivative of the function requires
* the chain rule:
*
*    D f(g(x)) = f'g(x)g'(x)
*     x
*
c         write(0,*)'Jacobian matrix:'
         do 40 j = 1, npicks
            xj2 = x(j) * x(j)
            xj4 = xj2 * xj2
            a12 = a(1) * a(1)
            a22 = a(2) * a(2)
            a33 = a(3) * a(3) * a(3)
            a34 = a33 * a(3)

*           The quartic moveout equation T
            Tqm = (a12 + a22*xj2 - a34*xj4/a12)**0.5

* Form the deltaT vector
            deltaT(j) = Tm(j) - Tqm

* Form the Jacobian
            Jcom = 1.0 / (2.0 * Tqm)
            Jacob(j,1) = Jcom * (2.*a(1) + 2.*a34*xj4/(a12*a(1)))
            Jacob(j,2) = Jcom * 2. * a(2) * xj2
c - had to move the minus sign inside the parentheses for the c90 - jmw
c           Jacob(j,3) = Jcom * -(4. * a33 * xj4 / a12)
            Jacob(j,3) = Jcom * (-4. * a33 * xj4 / a12)
*            print 38,Jcom,(Jacob(j,i),i=1,3)
* 38         format(1x,f15.8,' | ',3(3x,f15.8))
 40      continue
c         write(0,*)'deltaT = ',(deltaT(j),j=1,npicks)

* Form JtJ = Transpose[Jacob] * Jacob.  Keep track of the largest
* element on the diagonal.  Also form b = Transpose[Jacob] * deltaT.
         eps = -1.e-30
         do 60 j = 1, 3
            do 55 k = 1, 3
               s = 0.0
               do 50 l = 1, npicks
                  s = s + Jacob(l,k) * Jacob(l,j)
 50            continue
               JtJ(j,k) = s
 55         continue
            s = 0.0
            do 57 l = 1, npicks
               s = s + Jacob(l,j) * deltaT(l)
 57         continue
            b(j) = s
            if (j .ne. 1) then
               if (JtJ(j,j) .gt. eps) eps = JtJ(j,j)
            else
               eps = JtJ(1,1)
            endif
 60      continue

* Add in the epsilon adjustment (1% of largest JtJ diagonal element)
         eps = prew * eps
         do 70 j = 1, 3
            JtJ(j,j) = JtJ(j,j) + eps
 70      continue

*         print*,'Transpose[Jacob] * Jacob (JtJ x = b)'
*         do 73 j = 1, 3
* 73         print 74,(JtJ(j,k),k=1,3),b(j)
* 74         format(1x,'|',3(3x,f15.8),' | x | ',f15.8,' |')

** Solve the system using Mathadvantage (rmfufs - Real Matrix, Full,
** Symmetric, Factor and Solve).
*         ztol = 1.0E-5
*         call rmfufs(JtJ, 3, 3, b, 3, 3, ztol, iperm, deltaA, 3, ierr)

** Factor the symmetric matrix.
*         do 83 k = 1, 2
*            do 82 i = k+1, 3
*               t = JtJ(k,i) / JtJ(k,k)
*               do 81 j = i, 3
*                  JtJ(i,j) = JtJ(i,j) - t*JtJ(k,j)
* 81            continue
* 82         continue
* 83      continue

* Forward elimination
*         do 85 i = 2, 3
*            do 84 j = 1, i-1
*               b(i) = b(i) - JtJ(i,j)*b(j)
* 84         continue
* 85      continue
* Use the 3x3 2 line version
*         b(2) = b(2) - JtJ(2,1)*b(1)
*         b(3) = b(3) - JtJ(3,1)*b(1) - JtJ(3,2)*b(2)

* Back substitutition
*         do 87 i = 3, 1, -1
*            do 86 j = i+1, 3
*               b(i) = b(i) - JtJ(i,j)*b(j)
* 86         continue
*            b(i) = b(i) / JtJ(i,i)
* 87      continue
* Use the 3x3 3 line version
*         b(3) = b(3) / JtJ(3,3)
*         b(2) = (b(2) - JtJ(2,3)*b(3)) / JtJ(2,2)
*         b(1) = (b(1) - JtJ(1,2)*b(2) - JtJ(1,3)*b(3)) / JtJ(1,1)

* Solve the system using linpack.  sgefa factors the matrix JtJ.  sgeco
* is the same as sgefa, but it also computes a condition number.  Once
* our algorithm is reasonably stable, we can switch back to sgefa.
*        call sgefa(JtJ,3,3,iperm,ierr)
         call sgeco(JtJ,3,3,iperm,rcond,z)
*        print*,'rcond = ',rcond

*        if (ierr .ne. 0) then
c           write(0,*) 'Error in call to sgefa.'
*           stop
*        endif
         call sgesl(JtJ,3,3,iperm,b,0)

c        write(0,*)'b = ',(b(j),j=1,3)

* Update our current guess.
         do 90 j = 1, 3
            a(j) = a(j) + b(j)
 90      continue

* Check for convergence...couldn't get this to work...now doing
* simple sum of absolute values (1-norm, I think)
*         convrg = .true.
*         do 95 j = 1, 3
*            if (abs(b(j)) .lt. .001 * abs(a(j))) convrg = .false.
* 95      continue
*         if (convrg) print*,'goto 110 -- would have converged by now...'
         if (abs(b(1))+abs(b(2))+abs(b(3)) .lt. 1.E-05) then
c           write(0,*)'Converged!!!'
            goto 110
         endif

 100  continue

* We didn't converge, so we dropped out of the loop.  Make some adjustments
* and try again.
      continue

* Target for loop exit when we converge.
 110  continue

* Return T0, V2, and V4
      T0 = a(1) * 1000.
      if (a(2) .ne. 0.0) then
         V2 = xmax / a(2)
      else
         V2 = a(2)
         ierr = -1
      endif
      if (a(3) .ne. 0.0) then
         V4 = xmax / a(3)
      else
         V4 = a(3)
         ierr = -1
      endif

      end
