C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine aztapr(awgt,a1,a2,a3,a4,minawgt,maxawgt)
      real      awgt(minawgt:maxawgt)       
c_______________________________________________________________________
c     compute a taper in the azimuth domain applicable over 2 full cycles.
c_______________________________________________________________________
c     initialize.
c_______________________________________________________________________
      da=1.
      ka1=nint(a1)
      ka2=nint(a2)
      ka3=nint(a3)
      ka4=nint(a4)
      do 10000 k=-360,+360           
       awgt(k)=0.
10000 continue
c_______________________________________________________________________
c     roll in between a1 and a2.
c_______________________________________________________________________
      taper=a2-a1
      if(taper .eq. 0) then
         k=ka1
         if(k .ge. -360 .and. k .le. +360) then
            awgt(k)=0.
            if(k-360 .ge. -180) awgt(k-360)=awgt(k)
            if(k+360 .le. +180) awgt(k+360)=awgt(k)
         endif
      else
        factuk=3.141592/taper
        do 20000 k=ka1,ka2
          if(k .ge. -360 .and. k .le. +360) then
             azim=k*da
             arg=(a2-azim)*factuk
             awgt(k)=.5*(1.+cos(arg))
             if(k-360 .ge. -180) awgt(k-360)=awgt(k)
             if(k+360 .le. +180) awgt(k+360)=awgt(k)
          endif
20000   continue
      endif
c_______________________________________________________________________
c     all pass between a2 and a3.
c_______________________________________________________________________
      do 300 k=ka2+1,ka3-1
        if(k .ge. -360 .and. k .le. +360) then
           awgt(k)=1.
           if(k-360 .ge. -180) awgt(k-360)=awgt(k)
           if(k+360 .le. +180) awgt(k+360)=awgt(k)
        endif
300   continue
c_______________________________________________________________________
c     roll out between a3 and a4.
c_______________________________________________________________________
      taper=a4-a3
      if(taper .eq. 0) then
        k=ka3
        if(k .ge. -360 .and. k .le. +360) then
           awgt(k)=0.                         
           if(k-360 .ge. -180) awgt(k-360)=awgt(k)
           if(k+360 .le. +180) awgt(k+360)=awgt(k)
        endif
      else
        factuk=3.141592/taper
        do 350 k=ka3,ka4
          if(k .ge. -360 .and. k .le. +360) then
             azim=k*da
             arg=(azim-a3)*factuk
             awgt(k)=.5*(1.+cos(arg))
             if(k-360 .ge. -180) awgt(k-360)=awgt(k)
             if(k+360 .le. +180) awgt(k+360)=awgt(k)
          endif
350     continue
      endif
c
      return
      end
